# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated


class GetRecentTradeHistoryOldReq(BaseModel):
    """
    GetRecentTradeHistoryOldReq

    Attributes:
        current_page (int): Current request page.
        page_size (int): Number of results per request. Minimum is 10, maximum is 500.
    """

    current_page: Optional[int] = Field(default=1,
                                        description="Current request page.",
                                        alias="currentPage")
    page_size: Optional[Annotated[
        int, Field(le=500, strict=True, ge=10)]] = Field(
            default=None,
            description=
            "Number of results per request. Minimum is 10, maximum is 500.",
            alias="pageSize")

    __properties: ClassVar[List[str]] = ["currentPage", "pageSize"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetRecentTradeHistoryOldReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
        cls,
        obj: Optional[Dict[str,
                           Any]]) -> Optional[GetRecentTradeHistoryOldReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currentPage":
            obj.get("currentPage")
            if obj.get("currentPage") is not None else 1,
            "pageSize":
            obj.get("pageSize")
        })
        return _obj


class GetRecentTradeHistoryOldReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_current_page(self,
                         value: int) -> GetRecentTradeHistoryOldReqBuilder:
        """
        Current request page.
        """
        self.obj['currentPage'] = value
        return self

    def set_page_size(self, value: int) -> GetRecentTradeHistoryOldReqBuilder:
        """
        Number of results per request. Minimum is 10, maximum is 500.
        """
        self.obj['pageSize'] = value
        return self

    def build(self) -> GetRecentTradeHistoryOldReq:
        return GetRecentTradeHistoryOldReq(**self.obj)
