# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated


class GetTradeHistoryOldReq(BaseModel):
    """
    GetTradeHistoryOldReq

    Attributes:
        symbol (str): symbol
        order_id (str): The unique order id generated by the trading system (If orderId is specified，please ignore the other query parameters)
        side (SideEnum): specify if the order is to 'buy' or 'sell'
        type (TypeEnum): limit, market, limit_stop or market_stop 
        trade_type (TradeTypeEnum): The type of trading:TRADE - Spot Trading(TRADE as default), MARGIN_TRADE - Cross Margin Trading, MARGIN_ISOLATED_TRADE - Isolated Margin Trading.
        start_at (int): Start time (milisecond)
        end_at (int): End time (milisecond)
        current_page (int): Current request page.
        page_size (int): Number of results per request. Minimum is 10, maximum is 500.
    """

    class SideEnum(Enum):
        """
        Attributes:
            BUY: buy
            SELL: sell
        """
        BUY = 'buy'
        SELL = 'sell'

    class TypeEnum(Enum):
        """
        Attributes:
            LIMIT: limit
            MARKET: market
            LIMIT_STOP: limit_stop
            MARKET_STOP: market_stop
        """
        LIMIT = 'limit'
        MARKET = 'market'
        LIMIT_STOP = 'limit_stop'
        MARKET_STOP = 'market_stop'

    class TradeTypeEnum(Enum):
        """
        Attributes:
            TRADE: Spot Trading
            MARGIN_TRADE: Cross Margin Trading
            MARGIN_ISOLATED_TRADE: Isolated Margin Trading
        """
        TRADE = 'TRADE'
        MARGIN_TRADE = 'MARGIN_TRADE'
        MARGIN_ISOLATED_TRADE = 'MARGIN_ISOLATED_TRADE'

    symbol: Optional[str] = Field(default=None, description="symbol")
    order_id: Optional[str] = Field(
        default=None,
        description=
        "The unique order id generated by the trading system (If orderId is specified，please ignore the other query parameters)",
        alias="orderId")
    side: Optional[SideEnum] = Field(
        default=None, description="specify if the order is to 'buy' or 'sell'")
    type: Optional[TypeEnum] = Field(
        default=None, description="limit, market, limit_stop or market_stop ")
    trade_type: Optional[TradeTypeEnum] = Field(
        default=TradeTypeEnum.TRADE,
        description=
        "The type of trading:TRADE - Spot Trading(TRADE as default), MARGIN_TRADE - Cross Margin Trading, MARGIN_ISOLATED_TRADE - Isolated Margin Trading.",
        alias="tradeType")
    start_at: Optional[int] = Field(default=None,
                                    description="Start time (milisecond)",
                                    alias="startAt")
    end_at: Optional[int] = Field(default=None,
                                  description="End time (milisecond)",
                                  alias="endAt")
    current_page: Optional[int] = Field(default=1,
                                        description="Current request page.",
                                        alias="currentPage")
    page_size: Optional[Annotated[
        int, Field(le=500, strict=True, ge=10)]] = Field(
            default=None,
            description=
            "Number of results per request. Minimum is 10, maximum is 500.",
            alias="pageSize")

    __properties: ClassVar[List[str]] = [
        "symbol", "orderId", "side", "type", "tradeType", "startAt", "endAt",
        "currentPage", "pageSize"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetTradeHistoryOldReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetTradeHistoryOldReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol":
            obj.get("symbol"),
            "orderId":
            obj.get("orderId"),
            "side":
            obj.get("side"),
            "type":
            obj.get("type"),
            "tradeType":
            obj.get("tradeType") if obj.get("tradeType") is not None else
            GetTradeHistoryOldReq.TradeTypeEnum.TRADE,
            "startAt":
            obj.get("startAt"),
            "endAt":
            obj.get("endAt"),
            "currentPage":
            obj.get("currentPage")
            if obj.get("currentPage") is not None else 1,
            "pageSize":
            obj.get("pageSize")
        })
        return _obj


class GetTradeHistoryOldReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_symbol(self, value: str) -> GetTradeHistoryOldReqBuilder:
        """
        symbol
        """
        self.obj['symbol'] = value
        return self

    def set_order_id(self, value: str) -> GetTradeHistoryOldReqBuilder:
        """
        The unique order id generated by the trading system (If orderId is specified，please ignore the other query parameters)
        """
        self.obj['orderId'] = value
        return self

    def set_side(
            self, value: GetTradeHistoryOldReq.SideEnum
    ) -> GetTradeHistoryOldReqBuilder:
        """
        specify if the order is to 'buy' or 'sell'
        """
        self.obj['side'] = value
        return self

    def set_type(
            self, value: GetTradeHistoryOldReq.TypeEnum
    ) -> GetTradeHistoryOldReqBuilder:
        """
        limit, market, limit_stop or market_stop 
        """
        self.obj['type'] = value
        return self

    def set_trade_type(
        self, value: GetTradeHistoryOldReq.TradeTypeEnum
    ) -> GetTradeHistoryOldReqBuilder:
        """
        The type of trading:TRADE - Spot Trading(TRADE as default), MARGIN_TRADE - Cross Margin Trading, MARGIN_ISOLATED_TRADE - Isolated Margin Trading.
        """
        self.obj['tradeType'] = value
        return self

    def set_start_at(self, value: int) -> GetTradeHistoryOldReqBuilder:
        """
        Start time (milisecond)
        """
        self.obj['startAt'] = value
        return self

    def set_end_at(self, value: int) -> GetTradeHistoryOldReqBuilder:
        """
        End time (milisecond)
        """
        self.obj['endAt'] = value
        return self

    def set_current_page(self, value: int) -> GetTradeHistoryOldReqBuilder:
        """
        Current request page.
        """
        self.obj['currentPage'] = value
        return self

    def set_page_size(self, value: int) -> GetTradeHistoryOldReqBuilder:
        """
        Number of results per request. Minimum is 10, maximum is 500.
        """
        self.obj['pageSize'] = value
        return self

    def build(self) -> GetTradeHistoryOldReq:
        return GetTradeHistoryOldReq(**self.obj)
