# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class ModifyOrderReq(BaseModel):
    """
    ModifyOrderReq

    Attributes:
        client_oid (str): The old client order id,orderId and clientOid must choose one
        symbol (str): symbol
        order_id (str): The old order id, orderId and clientOid must choose one
        new_price (str): The modified price of the new order, newPrice and newSize must choose one
        new_size (str): The modified size of the new order, newPrice and newSize must choose one
    """

    client_oid: Optional[str] = Field(
        default=None,
        description=
        "The old client order id,orderId and clientOid must choose one",
        alias="clientOid")
    symbol: Optional[str] = Field(default=None, description="symbol")
    order_id: Optional[str] = Field(
        default=None,
        description="The old order id, orderId and clientOid must choose one",
        alias="orderId")
    new_price: Optional[str] = Field(
        default=None,
        description=
        "The modified price of the new order, newPrice and newSize must choose one",
        alias="newPrice")
    new_size: Optional[str] = Field(
        default=None,
        description=
        "The modified size of the new order, newPrice and newSize must choose one",
        alias="newSize")

    __properties: ClassVar[List[str]] = [
        "clientOid", "symbol", "orderId", "newPrice", "newSize"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[ModifyOrderReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[ModifyOrderReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "clientOid": obj.get("clientOid"),
            "symbol": obj.get("symbol"),
            "orderId": obj.get("orderId"),
            "newPrice": obj.get("newPrice"),
            "newSize": obj.get("newSize")
        })
        return _obj


class ModifyOrderReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_client_oid(self, value: str) -> ModifyOrderReqBuilder:
        """
        The old client order id,orderId and clientOid must choose one
        """
        self.obj['clientOid'] = value
        return self

    def set_symbol(self, value: str) -> ModifyOrderReqBuilder:
        """
        symbol
        """
        self.obj['symbol'] = value
        return self

    def set_order_id(self, value: str) -> ModifyOrderReqBuilder:
        """
        The old order id, orderId and clientOid must choose one
        """
        self.obj['orderId'] = value
        return self

    def set_new_price(self, value: str) -> ModifyOrderReqBuilder:
        """
        The modified price of the new order, newPrice and newSize must choose one
        """
        self.obj['newPrice'] = value
        return self

    def set_new_size(self, value: str) -> ModifyOrderReqBuilder:
        """
        The modified size of the new order, newPrice and newSize must choose one
        """
        self.obj['newSize'] = value
        return self

    def build(self) -> ModifyOrderReq:
        return ModifyOrderReq(**self.obj)
