# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class AllTickersEvent(BaseModel):
    """
    AllTickersEvent

    Attributes:
        best_ask (str): 
        best_ask_size (str): 
        best_bid (str): 
        best_bid_size (str): 
        price (str): 
        sequence (str): 
        size (str): 
        time (int): The matching time of the latest transaction
    """

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    best_ask: Optional[str] = Field(default=None, alias="bestAsk")
    best_ask_size: Optional[str] = Field(default=None, alias="bestAskSize")
    best_bid: Optional[str] = Field(default=None, alias="bestBid")
    best_bid_size: Optional[str] = Field(default=None, alias="bestBidSize")
    price: Optional[str] = None
    sequence: Optional[str] = None
    size: Optional[str] = None
    time: Optional[int] = Field(
        default=None,
        description="The matching time of the latest transaction")

    __properties: ClassVar[List[str]] = [
        "bestAsk", "bestAskSize", "bestBid", "bestBidSize", "price",
        "sequence", "size", "time"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[AllTickersEvent]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[AllTickersEvent]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bestAsk": obj.get("bestAsk"),
            "bestAskSize": obj.get("bestAskSize"),
            "bestBid": obj.get("bestBid"),
            "bestBidSize": obj.get("bestBidSize"),
            "price": obj.get("price"),
            "sequence": obj.get("sequence"),
            "size": obj.get("size"),
            "time": obj.get("time")
        })
        return _obj


AllTickersEventCallback = Callable[[str, str, AllTickersEvent], None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (AllTickersEvent): event data
"""


class AllTickersEventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: AllTickersEventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = AllTickersEvent.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
