# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from .model_symbol_snapshot_data_market_change1h import SymbolSnapshotDataMarketChange1h
from .model_symbol_snapshot_data_market_change24h import SymbolSnapshotDataMarketChange24h
from .model_symbol_snapshot_data_market_change4h import SymbolSnapshotDataMarketChange4h


class SymbolSnapshotData(BaseModel):
    """
    SymbolSnapshotData

    Attributes:
        ask_size (float): 
        average_price (float): 
        base_currency (str): 
        bid_size (float): 
        board (BoardEnum): Trading pair partition： 0.primary partition 1.KuCoin Plus\", example = \"1\"
        buy (float): 
        change_price (float): 
        change_rate (float): 
        close (float): 
        datetime (int): 
        high (float): 
        last_traded_price (float): 
        low (float): 
        maker_coefficient (float): 
        maker_fee_rate (float): 
        margin_trade (bool): 
        mark (MarkEnum): Trading Pair Mark： 0.default 1.ST. 2.NEW\", example = \"1\"
        market (str): 
        market_change1h (SymbolSnapshotDataMarketChange1h): 
        market_change24h (SymbolSnapshotDataMarketChange24h): 
        market_change4h (SymbolSnapshotDataMarketChange4h): 
        markets (list[str]): 
        open (float): 
        quote_currency (str): 
        sell (float): 
        site_types (list[str]): 
        sort (int): sorting number(Pointless)
        symbol (str): 
        symbol_code (str): 
        taker_coefficient (float): 
        taker_fee_rate (float): 
        trading (bool): 
        vol (float): 
        vol_value (float): 24-hour rolling transaction volume, refreshed every 2s
    """

    class BoardEnum(Enum):
        """
        Attributes:
            T_0: primary partition
            T_1: KuCoin Plus
        """
        T_0 = 0
        T_1 = 1

    class MarkEnum(Enum):
        """
        Attributes:
            T_0: default
            T_1: ST
            T_2: NEW
        """
        T_0 = 0
        T_1 = 1
        T_2 = 2

    ask_size: Optional[float] = Field(default=None, alias="askSize")
    average_price: Optional[float] = Field(default=None, alias="averagePrice")
    base_currency: Optional[str] = Field(default=None, alias="baseCurrency")
    bid_size: Optional[float] = Field(default=None, alias="bidSize")
    board: Optional[BoardEnum] = Field(
        default=None,
        description=
        "Trading pair partition： 0.primary partition 1.KuCoin Plus\", example = \"1\""
    )
    buy: Optional[float] = None
    change_price: Optional[float] = Field(default=None, alias="changePrice")
    change_rate: Optional[float] = Field(default=None, alias="changeRate")
    close: Optional[float] = None
    datetime: Optional[int] = None
    high: Optional[float] = None
    last_traded_price: Optional[float] = Field(default=None,
                                               alias="lastTradedPrice")
    low: Optional[float] = None
    maker_coefficient: Optional[float] = Field(default=None,
                                               alias="makerCoefficient")
    maker_fee_rate: Optional[float] = Field(default=None, alias="makerFeeRate")
    margin_trade: Optional[bool] = Field(default=None, alias="marginTrade")
    mark: Optional[MarkEnum] = Field(
        default=None,
        description=
        "Trading Pair Mark： 0.default 1.ST. 2.NEW\", example = \"1\"")
    market: Optional[str] = None
    market_change1h: Optional[SymbolSnapshotDataMarketChange1h] = Field(
        default=None, alias="marketChange1h")
    market_change24h: Optional[SymbolSnapshotDataMarketChange24h] = Field(
        default=None, alias="marketChange24h")
    market_change4h: Optional[SymbolSnapshotDataMarketChange4h] = Field(
        default=None, alias="marketChange4h")
    markets: Optional[List[str]] = None
    open: Optional[float] = None
    quote_currency: Optional[str] = Field(default=None, alias="quoteCurrency")
    sell: Optional[float] = None
    site_types: Optional[List[str]] = Field(default=None, alias="siteTypes")
    sort: Optional[int] = Field(default=None,
                                description="sorting number(Pointless)")
    symbol: Optional[str] = None
    symbol_code: Optional[str] = Field(default=None, alias="symbolCode")
    taker_coefficient: Optional[float] = Field(default=None,
                                               alias="takerCoefficient")
    taker_fee_rate: Optional[float] = Field(default=None, alias="takerFeeRate")
    trading: Optional[bool] = None
    vol: Optional[float] = None
    vol_value: Optional[float] = Field(
        default=None,
        description="24-hour rolling transaction volume, refreshed every 2s",
        alias="volValue")

    __properties: ClassVar[List[str]] = [
        "askSize", "averagePrice", "baseCurrency", "bidSize", "board", "buy",
        "changePrice", "changeRate", "close", "datetime", "high",
        "lastTradedPrice", "low", "makerCoefficient", "makerFeeRate",
        "marginTrade", "mark", "market", "marketChange1h", "marketChange24h",
        "marketChange4h", "markets", "open", "quoteCurrency", "sell",
        "siteTypes", "sort", "symbol", "symbolCode", "takerCoefficient",
        "takerFeeRate", "trading", "vol", "volValue"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[SymbolSnapshotData]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of market_change1h
        if self.market_change1h:
            _dict['marketChange1h'] = self.market_change1h.to_dict()
        # override the default output from pydantic by calling `to_dict()` of market_change24h
        if self.market_change24h:
            _dict['marketChange24h'] = self.market_change24h.to_dict()
        # override the default output from pydantic by calling `to_dict()` of market_change4h
        if self.market_change4h:
            _dict['marketChange4h'] = self.market_change4h.to_dict()
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[SymbolSnapshotData]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "askSize":
            obj.get("askSize"),
            "averagePrice":
            obj.get("averagePrice"),
            "baseCurrency":
            obj.get("baseCurrency"),
            "bidSize":
            obj.get("bidSize"),
            "board":
            obj.get("board"),
            "buy":
            obj.get("buy"),
            "changePrice":
            obj.get("changePrice"),
            "changeRate":
            obj.get("changeRate"),
            "close":
            obj.get("close"),
            "datetime":
            obj.get("datetime"),
            "high":
            obj.get("high"),
            "lastTradedPrice":
            obj.get("lastTradedPrice"),
            "low":
            obj.get("low"),
            "makerCoefficient":
            obj.get("makerCoefficient"),
            "makerFeeRate":
            obj.get("makerFeeRate"),
            "marginTrade":
            obj.get("marginTrade"),
            "mark":
            obj.get("mark"),
            "market":
            obj.get("market"),
            "marketChange1h":
            SymbolSnapshotDataMarketChange1h.from_dict(obj["marketChange1h"])
            if obj.get("marketChange1h") is not None else None,
            "marketChange24h":
            SymbolSnapshotDataMarketChange24h.from_dict(obj["marketChange24h"])
            if obj.get("marketChange24h") is not None else None,
            "marketChange4h":
            SymbolSnapshotDataMarketChange4h.from_dict(obj["marketChange4h"])
            if obj.get("marketChange4h") is not None else None,
            "markets":
            obj.get("markets"),
            "open":
            obj.get("open"),
            "quoteCurrency":
            obj.get("quoteCurrency"),
            "sell":
            obj.get("sell"),
            "siteTypes":
            obj.get("siteTypes"),
            "sort":
            obj.get("sort"),
            "symbol":
            obj.get("symbol"),
            "symbolCode":
            obj.get("symbolCode"),
            "takerCoefficient":
            obj.get("takerCoefficient"),
            "takerFeeRate":
            obj.get("takerFeeRate"),
            "trading":
            obj.get("trading"),
            "vol":
            obj.get("vol"),
            "volValue":
            obj.get("volValue")
        })
        return _obj
