from .common import (WEAKNESS_BEFORE_STOP_WORDS, WEAKNESS_PATTERN, CONFIGURATION_PATTERN, COMPONENT_PATTERN,
                     IMPACT_PATTERN, IMPACT_BEFORE_STOP_WORDS, VECTOR_PATTERN, VECTOR_BEFORE_STOP_WORDS,
                     CONFIGURATION_BEFORE_STOP_WORDS, COMPONENT_AFTER_STOP_WORDS, ATTACKER_BEFORE_STOP_WORDS,
                     ATTACKER_PATTERN, ROOT_CAUSE_BEFORE_STOP_WORD, ROOT_CAUSE_PATTERN)


# component - config - weakness
COMPONENT_STARTING_DETAIL_PATTERN = (r'(?:The |)' + COMPONENT_PATTERN + COMPONENT_AFTER_STOP_WORDS
                                     + CONFIGURATION_BEFORE_STOP_WORDS + CONFIGURATION_PATTERN
                                     + WEAKNESS_BEFORE_STOP_WORDS + WEAKNESS_PATTERN)

# component - config - weakness - attacker - impact - vector
DETAILS_6_1 = (COMPONENT_STARTING_DETAIL_PATTERN + ATTACKER_BEFORE_STOP_WORDS + ATTACKER_PATTERN +
               IMPACT_BEFORE_STOP_WORDS + IMPACT_PATTERN + VECTOR_BEFORE_STOP_WORDS + VECTOR_PATTERN + r'\.')


# component - config - weakness - vector - impact
DETAILS_5_1 = (COMPONENT_STARTING_DETAIL_PATTERN + VECTOR_BEFORE_STOP_WORDS + VECTOR_PATTERN +
               IMPACT_BEFORE_STOP_WORDS + IMPACT_PATTERN + r'\.')

# component - config - weakness - vector - root_cause
DETAILS_5_2 = (COMPONENT_STARTING_DETAIL_PATTERN + VECTOR_BEFORE_STOP_WORDS + VECTOR_PATTERN +
               ROOT_CAUSE_BEFORE_STOP_WORD + ROOT_CAUSE_PATTERN + r'\.')

# component - config - weakness - vector
DETAILS_4_1 = COMPONENT_STARTING_DETAIL_PATTERN + VECTOR_BEFORE_STOP_WORDS + VECTOR_PATTERN + r'\.'

# component - config - weakness - root_cause
DETAILS_4_2 = COMPONENT_STARTING_DETAIL_PATTERN + ROOT_CAUSE_BEFORE_STOP_WORD + ROOT_CAUSE_PATTERN + r'\.'

# component - config - weakness
DETAILS_3_1 = COMPONENT_STARTING_DETAIL_PATTERN + r'\.$'


COMPONENT_PATTERNS = {
    '6_1': DETAILS_6_1,
    '5_1': DETAILS_5_1,
    '5_2': DETAILS_5_2,
    '4_1': DETAILS_4_1,
    '4_2': DETAILS_4_2,
    '3_1': DETAILS_3_1
}
