# DO NOT MODIFY -- This file is generated by type_spec
# flake8: noqa: F821
# ruff: noqa: E402
# fmt: off
# isort: skip_file
# ruff: noqa: PLR0904
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from uncountable.types import async_batch as async_batch_t
from uncountable.types import base as base_t
import uncountable.types.api.recipes.create_recipe as create_recipe_t
import uncountable.types.api.recipes.edit_recipe_inputs as edit_recipe_inputs_t
from uncountable.types import identifier as identifier_t
from uncountable.types import recipe_identifiers as recipe_identifiers_t
from uncountable.types import recipe_metadata as recipe_metadata_t
from uncountable.types import recipe_workflow_steps as recipe_workflow_steps_t
import uncountable.types.api.recipes.set_recipe_metadata as set_recipe_metadata_t
import uuid
from abc import ABC, abstractmethod
from dataclasses import dataclass
from pkgs.serialization_util.serialization_helpers import serialize_for_api


class AsyncBatchProcessorBase(ABC):
    @abstractmethod
    def _enqueue(self, req: async_batch_t.AsyncBatchRequest) -> None:
        ...

    @abstractmethod
    def send(self) -> base_t.ObjectId:
        ...

    def create_recipe(
        self,
        *,
        material_family_id: base_t.ObjectId,
        workflow_id: base_t.ObjectId,
        name: typing.Optional[str] = None,
        workflow_variant_id: typing.Optional[typing.Optional[base_t.ObjectId]] = None,
        recipe_metadata: typing.Optional[list[recipe_metadata_t.MetadataValue]] = None,
        identifiers: typing.Optional[recipe_identifiers_t.RecipeIdentifiers] = None,
        definition_key: typing.Optional[identifier_t.IdentifierKey] = None,
        depends_on: typing.Optional[list[str]] = None,
    ) -> async_batch_t.QueuedBatchRequest:
        """Returns the id of the recipe being created.

        :param name: The name for the recipe
        :param material_family_id: The material family for the recipe
        :param workflow_id: The identifier of the workflow to create the recipe with
        :param workflow_variant_id: The identifier of the workflow variant to create the recipe with
        :param recipe_metadata: Metadata values to populate the recipe with
        :param identifiers: A recipe won't be created if it matches the identifier.  An identifier must be unique in the schema
        :param definition_key: The entity definition identifier, default is used if not supplied
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = create_recipe_t.Arguments(
            name=name,
            material_family_id=material_family_id,
            workflow_id=workflow_id,
            workflow_variant_id=workflow_variant_id,
            recipe_metadata=recipe_metadata,
            identifiers=identifiers,
            definition_key=definition_key,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.CREATE_RECIPE,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def edit_recipe_inputs(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        recipe_workflow_step_identifier: recipe_workflow_steps_t.RecipeWorkflowStepIdentifierType,
        edits: list[edit_recipe_inputs_t.RecipeInputEdit],
        depends_on: typing.Optional[list[str]] = None,
    ) -> async_batch_t.QueuedBatchRequest:
        """Clear, update, or add inputs on a recipe

        :param recipe_key: Identifier for the recipe
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = edit_recipe_inputs_t.Arguments(
            recipe_key=recipe_key,
            recipe_workflow_step_identifier=recipe_workflow_step_identifier,
            edits=edits,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.EDIT_RECIPE_INPUTS,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def set_recipe_metadata(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        recipe_metadata: list[recipe_metadata_t.MetadataValue],
        depends_on: typing.Optional[list[str]] = None,
    ) -> async_batch_t.QueuedBatchRequest:
        """Set metadata values on a recipe

        :param recipe_key: Identifier for the recipe
        :param recipe_metadata: Metadata values to populate the recipe with
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = set_recipe_metadata_t.Arguments(
            recipe_key=recipe_key,
            recipe_metadata=recipe_metadata,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.SET_RECIPE_METADATA,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )
