import { Test } from 'nodeunit';
declare const _default: {
    'a stack can be serialized into a CloudFormation template, initially it\'s empty'(test: Test): void;
    'stack objects have some template-level propeties, such as Description, Version, Transform'(test: Test): void;
    'Stack.isStack indicates that a construct is a stack'(test: Test): void;
    'stack.id is not included in the logical identities of resources within it'(test: Test): void;
    'stack.templateOptions can be used to set template-level options'(test: Test): void;
    'Overriding `Stack._toCloudFormation` allows arbitrary post-processing of the generated template during synthesis'(test: Test): void;
    'Stack.getByPath can be used to find any CloudFormation element (Parameter, Output, etc)'(test: Test): void;
    'Stack names can have hyphens in them'(test: Test): void;
    'Stacks can have a description given to them'(test: Test): void;
    'Stack descriptions have a limited length'(test: Test): void;
    'Include should support non-hash top-level template elements like "Description"'(test: Test): void;
    'Pseudo values attached to one stack can be referenced in another stack'(test: Test): void;
    'Cross-stack references are detected in resource properties'(test: Test): void;
    'cross-stack references in lazy tokens work'(test: Test): void;
    'Cross-stack use of Region and account returns nonscoped intrinsic because the two stacks must be in the same region anyway'(test: Test): void;
    'cross-stack references in strings work'(test: Test): void;
    'CfnSynthesisError is ignored when preparing cross references'(test: Test): void;
    'Stacks can be children of other stacks (substack) and they will be synthesized separately'(test: Test): void;
    'cross-stack reference (substack references parent stack)'(test: Test): void;
    'cross-stack reference (parent stack references substack)'(test: Test): void;
    'cannot create cyclic reference between stacks'(test: Test): void;
    'stacks know about their dependencies'(test: Test): void;
    'cannot create references to stacks in other regions/accounts'(test: Test): void;
    'urlSuffix does not imply a stack dependency'(test: Test): void;
    'stack with region supplied via props returns literal value'(test: Test): void;
    'overrideLogicalId(id) can be used to override the logical ID of a resource'(test: Test): void;
    'Stack name can be overridden via properties'(test: Test): void;
    'Stack name is inherited from App name if available'(test: Test): void;
    'stack construct id does not go through stack name validation if there is an explicit stack name'(test: Test): void;
    'stack validation is performed on explicit stack name'(test: Test): void;
    'Stack.of(stack) returns the correct stack'(test: Test): void;
    'Stack.of() throws when there is no parent Stack'(test: Test): void;
    'Stack.of() works for substacks'(test: Test): void;
    'stack.availabilityZones falls back to Fn::GetAZ[0],[2] if region is not specified'(test: Test): void;
    'stack.templateFile is the name of the template file emitted to the cloud assembly (default is to use the stack name)'(test: Test): void;
    'when feature flag is enabled we will use the artifact id as the template name'(test: Test): void;
    'allow using the same stack name for two stacks (i.e. in different regions)'(test: Test): void;
    'metadata is collected at the stack boundary'(test: Test): void;
};
export = _default;
