import json

VENUS_LENS_ABI = json.loads('''
[
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "poolRegistryAddress",
        "type": "address"
      }
    ],
    "name": "getAllPools",
    "outputs": [
      {
        "components": [
          {
            "internalType": "string",
            "name": "name",
            "type": "string"
          },
          {
            "internalType": "address",
            "name": "creator",
            "type": "address"
          },
          {
            "internalType": "address",
            "name": "comptroller",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "blockPosted",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "timestampPosted",
            "type": "uint256"
          },
          {
            "internalType": "string",
            "name": "category",
            "type": "string"
          },
          {
            "internalType": "string",
            "name": "logoURL",
            "type": "string"
          },
          {
            "internalType": "string",
            "name": "description",
            "type": "string"
          },
          {
            "internalType": "address",
            "name": "priceOracle",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "closeFactor",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "liquidationIncentive",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "minLiquidatableCollateral",
            "type": "uint256"
          },
          {
            "components": [
              {
                "internalType": "address",
                "name": "vToken",
                "type": "address"
              },
              {
                "internalType": "uint256",
                "name": "exchangeRateCurrent",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "supplyRatePerBlock",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "borrowRatePerBlock",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "reserveFactorMantissa",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "supplyCaps",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "borrowCaps",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "totalBorrows",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "totalReserves",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "totalSupply",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "totalCash",
                "type": "uint256"
              },
              {
                "internalType": "bool",
                "name": "isListed",
                "type": "bool"
              },
              {
                "internalType": "uint256",
                "name": "collateralFactorMantissa",
                "type": "uint256"
              },
              {
                "internalType": "address",
                "name": "underlyingAssetAddress",
                "type": "address"
              },
              {
                "internalType": "uint256",
                "name": "vTokenDecimals",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "underlyingDecimals",
                "type": "uint256"
              }
            ],
            "internalType": "struct PoolLens.VTokenMetadata[]",
            "name": "vTokens",
            "type": "tuple[]"
          }
        ],
        "internalType": "struct PoolLens.PoolData[]",
        "name": "",
        "type": "tuple[]"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "account",
        "type": "address"
      },
      {
        "internalType": "address",
        "name": "comptrollerAddress",
        "type": "address"
      }
    ],
    "name": "getPendingRewards",
    "outputs": [
      {
        "components": [
          {
            "internalType": "address",
            "name": "distributorAddress",
            "type": "address"
          },
          {
            "internalType": "address",
            "name": "rewardTokenAddress",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "totalRewards",
            "type": "uint256"
          },
          {
            "components": [
              {
                "internalType": "address",
                "name": "vTokenAddress",
                "type": "address"
              },
              {
                "internalType": "uint256",
                "name": "amount",
                "type": "uint256"
              }
            ],
            "internalType": "struct PoolLens.PendingReward[]",
            "name": "pendingRewards",
            "type": "tuple[]"
          }
        ],
        "internalType": "struct PoolLens.RewardSummary[]",
        "name": "",
        "type": "tuple[]"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "comptrollerAddress",
        "type": "address"
      }
    ],
    "name": "getPoolBadDebt",
    "outputs": [
      {
        "components": [
          {
            "internalType": "address",
            "name": "comptroller",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "totalBadDebtUsd",
            "type": "uint256"
          },
          {
            "components": [
              {
                "internalType": "address",
                "name": "vTokenAddress",
                "type": "address"
              },
              {
                "internalType": "uint256",
                "name": "badDebtUsd",
                "type": "uint256"
              }
            ],
            "internalType": "struct PoolLens.BadDebt[]",
            "name": "badDebts",
            "type": "tuple[]"
          }
        ],
        "internalType": "struct PoolLens.BadDebtSummary",
        "name": "",
        "type": "tuple"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "poolRegistryAddress",
        "type": "address"
      },
      {
        "internalType": "address",
        "name": "comptroller",
        "type": "address"
      }
    ],
    "name": "getPoolByComptroller",
    "outputs": [
      {
        "components": [
          {
            "internalType": "string",
            "name": "name",
            "type": "string"
          },
          {
            "internalType": "address",
            "name": "creator",
            "type": "address"
          },
          {
            "internalType": "address",
            "name": "comptroller",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "blockPosted",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "timestampPosted",
            "type": "uint256"
          },
          {
            "internalType": "string",
            "name": "category",
            "type": "string"
          },
          {
            "internalType": "string",
            "name": "logoURL",
            "type": "string"
          },
          {
            "internalType": "string",
            "name": "description",
            "type": "string"
          },
          {
            "internalType": "address",
            "name": "priceOracle",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "closeFactor",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "liquidationIncentive",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "minLiquidatableCollateral",
            "type": "uint256"
          },
          {
            "components": [
              {
                "internalType": "address",
                "name": "vToken",
                "type": "address"
              },
              {
                "internalType": "uint256",
                "name": "exchangeRateCurrent",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "supplyRatePerBlock",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "borrowRatePerBlock",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "reserveFactorMantissa",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "supplyCaps",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "borrowCaps",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "totalBorrows",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "totalReserves",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "totalSupply",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "totalCash",
                "type": "uint256"
              },
              {
                "internalType": "bool",
                "name": "isListed",
                "type": "bool"
              },
              {
                "internalType": "uint256",
                "name": "collateralFactorMantissa",
                "type": "uint256"
              },
              {
                "internalType": "address",
                "name": "underlyingAssetAddress",
                "type": "address"
              },
              {
                "internalType": "uint256",
                "name": "vTokenDecimals",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "underlyingDecimals",
                "type": "uint256"
              }
            ],
            "internalType": "struct PoolLens.VTokenMetadata[]",
            "name": "vTokens",
            "type": "tuple[]"
          }
        ],
        "internalType": "struct PoolLens.PoolData",
        "name": "",
        "type": "tuple"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "poolRegistryAddress",
        "type": "address"
      },
      {
        "components": [
          {
            "internalType": "string",
            "name": "name",
            "type": "string"
          },
          {
            "internalType": "address",
            "name": "creator",
            "type": "address"
          },
          {
            "internalType": "address",
            "name": "comptroller",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "blockPosted",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "timestampPosted",
            "type": "uint256"
          }
        ],
        "internalType": "struct PoolRegistryInterface.VenusPool",
        "name": "venusPool",
        "type": "tuple"
      }
    ],
    "name": "getPoolDataFromVenusPool",
    "outputs": [
      {
        "components": [
          {
            "internalType": "string",
            "name": "name",
            "type": "string"
          },
          {
            "internalType": "address",
            "name": "creator",
            "type": "address"
          },
          {
            "internalType": "address",
            "name": "comptroller",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "blockPosted",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "timestampPosted",
            "type": "uint256"
          },
          {
            "internalType": "string",
            "name": "category",
            "type": "string"
          },
          {
            "internalType": "string",
            "name": "logoURL",
            "type": "string"
          },
          {
            "internalType": "string",
            "name": "description",
            "type": "string"
          },
          {
            "internalType": "address",
            "name": "priceOracle",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "closeFactor",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "liquidationIncentive",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "minLiquidatableCollateral",
            "type": "uint256"
          },
          {
            "components": [
              {
                "internalType": "address",
                "name": "vToken",
                "type": "address"
              },
              {
                "internalType": "uint256",
                "name": "exchangeRateCurrent",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "supplyRatePerBlock",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "borrowRatePerBlock",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "reserveFactorMantissa",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "supplyCaps",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "borrowCaps",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "totalBorrows",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "totalReserves",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "totalSupply",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "totalCash",
                "type": "uint256"
              },
              {
                "internalType": "bool",
                "name": "isListed",
                "type": "bool"
              },
              {
                "internalType": "uint256",
                "name": "collateralFactorMantissa",
                "type": "uint256"
              },
              {
                "internalType": "address",
                "name": "underlyingAssetAddress",
                "type": "address"
              },
              {
                "internalType": "uint256",
                "name": "vTokenDecimals",
                "type": "uint256"
              },
              {
                "internalType": "uint256",
                "name": "underlyingDecimals",
                "type": "uint256"
              }
            ],
            "internalType": "struct PoolLens.VTokenMetadata[]",
            "name": "vTokens",
            "type": "tuple[]"
          }
        ],
        "internalType": "struct PoolLens.PoolData",
        "name": "",
        "type": "tuple"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "poolRegistryAddress",
        "type": "address"
      },
      {
        "internalType": "address",
        "name": "asset",
        "type": "address"
      }
    ],
    "name": "getPoolsSupportedByAsset",
    "outputs": [
      {
        "internalType": "address[]",
        "name": "",
        "type": "address[]"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "poolRegistryAddress",
        "type": "address"
      },
      {
        "internalType": "address",
        "name": "comptroller",
        "type": "address"
      },
      {
        "internalType": "address",
        "name": "asset",
        "type": "address"
      }
    ],
    "name": "getVTokenForAsset",
    "outputs": [
      {
        "internalType": "address",
        "name": "",
        "type": "address"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "contract VToken",
        "name": "vToken",
        "type": "address"
      },
      {
        "internalType": "address",
        "name": "account",
        "type": "address"
      }
    ],
    "name": "vTokenBalances",
    "outputs": [
      {
        "components": [
          {
            "internalType": "address",
            "name": "vToken",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "balanceOf",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "borrowBalanceCurrent",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "balanceOfUnderlying",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "tokenBalance",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "tokenAllowance",
            "type": "uint256"
          }
        ],
        "internalType": "struct PoolLens.VTokenBalances",
        "name": "",
        "type": "tuple"
      }
    ],
    "stateMutability": "nonpayable",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "contract VToken[]",
        "name": "vTokens",
        "type": "address[]"
      },
      {
        "internalType": "address",
        "name": "account",
        "type": "address"
      }
    ],
    "name": "vTokenBalancesAll",
    "outputs": [
      {
        "components": [
          {
            "internalType": "address",
            "name": "vToken",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "balanceOf",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "borrowBalanceCurrent",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "balanceOfUnderlying",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "tokenBalance",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "tokenAllowance",
            "type": "uint256"
          }
        ],
        "internalType": "struct PoolLens.VTokenBalances[]",
        "name": "",
        "type": "tuple[]"
      }
    ],
    "stateMutability": "nonpayable",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "contract VToken",
        "name": "vToken",
        "type": "address"
      }
    ],
    "name": "vTokenMetadata",
    "outputs": [
      {
        "components": [
          {
            "internalType": "address",
            "name": "vToken",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "exchangeRateCurrent",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "supplyRatePerBlock",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "borrowRatePerBlock",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "reserveFactorMantissa",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "supplyCaps",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "borrowCaps",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "totalBorrows",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "totalReserves",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "totalSupply",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "totalCash",
            "type": "uint256"
          },
          {
            "internalType": "bool",
            "name": "isListed",
            "type": "bool"
          },
          {
            "internalType": "uint256",
            "name": "collateralFactorMantissa",
            "type": "uint256"
          },
          {
            "internalType": "address",
            "name": "underlyingAssetAddress",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "vTokenDecimals",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "underlyingDecimals",
            "type": "uint256"
          }
        ],
        "internalType": "struct PoolLens.VTokenMetadata",
        "name": "",
        "type": "tuple"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "contract VToken[]",
        "name": "vTokens",
        "type": "address[]"
      }
    ],
    "name": "vTokenMetadataAll",
    "outputs": [
      {
        "components": [
          {
            "internalType": "address",
            "name": "vToken",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "exchangeRateCurrent",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "supplyRatePerBlock",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "borrowRatePerBlock",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "reserveFactorMantissa",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "supplyCaps",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "borrowCaps",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "totalBorrows",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "totalReserves",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "totalSupply",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "totalCash",
            "type": "uint256"
          },
          {
            "internalType": "bool",
            "name": "isListed",
            "type": "bool"
          },
          {
            "internalType": "uint256",
            "name": "collateralFactorMantissa",
            "type": "uint256"
          },
          {
            "internalType": "address",
            "name": "underlyingAssetAddress",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "vTokenDecimals",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "underlyingDecimals",
            "type": "uint256"
          }
        ],
        "internalType": "struct PoolLens.VTokenMetadata[]",
        "name": "",
        "type": "tuple[]"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "contract VToken",
        "name": "vToken",
        "type": "address"
      }
    ],
    "name": "vTokenUnderlyingPrice",
    "outputs": [
      {
        "components": [
          {
            "internalType": "address",
            "name": "vToken",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "underlyingPrice",
            "type": "uint256"
          }
        ],
        "internalType": "struct PoolLens.VTokenUnderlyingPrice",
        "name": "",
        "type": "tuple"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "contract VToken[]",
        "name": "vTokens",
        "type": "address[]"
      }
    ],
    "name": "vTokenUnderlyingPriceAll",
    "outputs": [
      {
        "components": [
          {
            "internalType": "address",
            "name": "vToken",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "underlyingPrice",
            "type": "uint256"
          }
        ],
        "internalType": "struct PoolLens.VTokenUnderlyingPrice[]",
        "name": "",
        "type": "tuple[]"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  }
]
''')