# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetGvcResult',
    'AwaitableGetGvcResult',
    'get_gvc',
    'get_gvc_output',
]

@pulumi.output_type
class GetGvcResult:
    """
    A collection of values returned by getGvc.
    """
    def __init__(__self__, alias=None, controlplane_tracing=None, cpln_id=None, description=None, domain=None, endpoint_naming_format=None, env=None, id=None, lightstep_tracing=None, load_balancer=None, locations=None, name=None, otel_tracing=None, pull_secrets=None, self_link=None, sidecar=None, tags=None):
        if alias and not isinstance(alias, str):
            raise TypeError("Expected argument 'alias' to be a str")
        pulumi.set(__self__, "alias", alias)
        if controlplane_tracing and not isinstance(controlplane_tracing, dict):
            raise TypeError("Expected argument 'controlplane_tracing' to be a dict")
        pulumi.set(__self__, "controlplane_tracing", controlplane_tracing)
        if cpln_id and not isinstance(cpln_id, str):
            raise TypeError("Expected argument 'cpln_id' to be a str")
        pulumi.set(__self__, "cpln_id", cpln_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if endpoint_naming_format and not isinstance(endpoint_naming_format, str):
            raise TypeError("Expected argument 'endpoint_naming_format' to be a str")
        pulumi.set(__self__, "endpoint_naming_format", endpoint_naming_format)
        if env and not isinstance(env, dict):
            raise TypeError("Expected argument 'env' to be a dict")
        pulumi.set(__self__, "env", env)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lightstep_tracing and not isinstance(lightstep_tracing, dict):
            raise TypeError("Expected argument 'lightstep_tracing' to be a dict")
        pulumi.set(__self__, "lightstep_tracing", lightstep_tracing)
        if load_balancer and not isinstance(load_balancer, dict):
            raise TypeError("Expected argument 'load_balancer' to be a dict")
        pulumi.set(__self__, "load_balancer", load_balancer)
        if locations and not isinstance(locations, list):
            raise TypeError("Expected argument 'locations' to be a list")
        pulumi.set(__self__, "locations", locations)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if otel_tracing and not isinstance(otel_tracing, dict):
            raise TypeError("Expected argument 'otel_tracing' to be a dict")
        pulumi.set(__self__, "otel_tracing", otel_tracing)
        if pull_secrets and not isinstance(pull_secrets, list):
            raise TypeError("Expected argument 'pull_secrets' to be a list")
        pulumi.set(__self__, "pull_secrets", pull_secrets)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if sidecar and not isinstance(sidecar, dict):
            raise TypeError("Expected argument 'sidecar' to be a dict")
        pulumi.set(__self__, "sidecar", sidecar)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def alias(self) -> builtins.str:
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="controlplaneTracing")
    def controlplane_tracing(self) -> Optional['outputs.GetGvcControlplaneTracingResult']:
        return pulumi.get(self, "controlplane_tracing")

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> builtins.str:
        return pulumi.get(self, "cpln_id")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Selecting a domain on a GVC will be deprecated in the future. Use the 'cpln_domain resource' instead.""")
    def domain(self) -> Optional[builtins.str]:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="endpointNamingFormat")
    def endpoint_naming_format(self) -> builtins.str:
        return pulumi.get(self, "endpoint_naming_format")

    @property
    @pulumi.getter
    def env(self) -> Optional[Mapping[str, builtins.str]]:
        return pulumi.get(self, "env")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lightstepTracing")
    def lightstep_tracing(self) -> Optional['outputs.GetGvcLightstepTracingResult']:
        return pulumi.get(self, "lightstep_tracing")

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional['outputs.GetGvcLoadBalancerResult']:
        return pulumi.get(self, "load_balancer")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="otelTracing")
    def otel_tracing(self) -> Optional['outputs.GetGvcOtelTracingResult']:
        return pulumi.get(self, "otel_tracing")

    @property
    @pulumi.getter(name="pullSecrets")
    def pull_secrets(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "pull_secrets")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> builtins.str:
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def sidecar(self) -> Optional['outputs.GetGvcSidecarResult']:
        return pulumi.get(self, "sidecar")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "tags")


class AwaitableGetGvcResult(GetGvcResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGvcResult(
            alias=self.alias,
            controlplane_tracing=self.controlplane_tracing,
            cpln_id=self.cpln_id,
            description=self.description,
            domain=self.domain,
            endpoint_naming_format=self.endpoint_naming_format,
            env=self.env,
            id=self.id,
            lightstep_tracing=self.lightstep_tracing,
            load_balancer=self.load_balancer,
            locations=self.locations,
            name=self.name,
            otel_tracing=self.otel_tracing,
            pull_secrets=self.pull_secrets,
            self_link=self.self_link,
            sidecar=self.sidecar,
            tags=self.tags)


def get_gvc(controlplane_tracing: Optional[Union['GetGvcControlplaneTracingArgs', 'GetGvcControlplaneTracingArgsDict']] = None,
            domain: Optional[builtins.str] = None,
            endpoint_naming_format: Optional[builtins.str] = None,
            env: Optional[Mapping[str, builtins.str]] = None,
            lightstep_tracing: Optional[Union['GetGvcLightstepTracingArgs', 'GetGvcLightstepTracingArgsDict']] = None,
            load_balancer: Optional[Union['GetGvcLoadBalancerArgs', 'GetGvcLoadBalancerArgsDict']] = None,
            locations: Optional[Sequence[builtins.str]] = None,
            name: Optional[builtins.str] = None,
            otel_tracing: Optional[Union['GetGvcOtelTracingArgs', 'GetGvcOtelTracingArgsDict']] = None,
            pull_secrets: Optional[Sequence[builtins.str]] = None,
            sidecar: Optional[Union['GetGvcSidecarArgs', 'GetGvcSidecarArgsDict']] = None,
            tags: Optional[Mapping[str, builtins.str]] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGvcResult:
    """
    Use this data source to access information about an existing [Global Virtual Cloud (GVC)](https://docs.controlplane.com/reference/gvc) within Control Plane.

    ## Required

    - **name** (String) Name of the GVC.

    ## Outputs

    The following attributes are exported:

    - **cpln_id** (String) The ID, in GUID format, of the GVC.
    - **name** (String) Name of the GVC.
    - **alias** (String) The alias name of the GVC.
    - **description** (String) Description of the GVC.
    - **tags** (Map of String) Key-value map of resource tags.
    - **self_link** (String) Full link to this resource. Can be referenced by other resources.
    - **domain** (String) Custom domain name used by associated workloads.
    - **locations** (List of String) A list of [locations](https://docs.controlplane.com/reference/location#current) making up the Global Virtual Cloud.
    - **pull_secrets** (List of String) A list of [pull secret](https://docs.controlplane.com/reference/gvc#pull-secrets) names used to authenticate to any private image repository referenced by Workloads within the GVC.
    - **lightstep_tracing** (Block List, Max: 1) (see below).
    - **otel_tracing** (Block List, Max: 1) (see below).
    - **controlplane_tracing** (Block List, Max: 1) (see below).
    - **load_balancer** (Block List, Max: 1) (see below).

    <a id="nestedblock--lightstep_tracing"></a>

    ### `lightstep_tracing`

    - **sampling** (Int) Sampling percentage.
    - **endpoint** (String) Tracing Endpoint Workload. Either the canonical endpoint or the internal endpoint.
    - **credentials** (String) Full link to referenced Opaque Secret.

    <a id="nestedblock--otel_tracing"></a>

    ### `otel_tracing`

    - **sampling** (Int) Determines what percentage of requests should be traced.
    - **endpoint** (String) Tracing Endpoint Workload. Either the canonical endpoint or internal endpoint.
    - **custom_tags** (Map of String) Key-value map of custom tags.

    <a id="nestedblock--controlplane_tracing"></a>

    ### `controlplane_tracing`

    - **sampling** (Int) Determines what percentage of requests should be traced.
    - **custom_tags** (Map of String) Key-value map of custom tags.

    <a id="nestedblock--load_balancer"></a>

    ### `load_balancer`

    - **dedicated** (Boolean) Creates a dedicated load balancer in each location and enables additional Domain features: custom ports, protocols and wildcard hostnames. Charges apply for each location.

    - **trusted_proxies** (Int) Controls the address used for request logging and for setting the X-Envoy-External-Address header. If set to 1, then the last address in an existing X-Forwarded-For header will be used in place of the source client IP address. If set to 2, then the second to last address in an existing X-Forwarded-For header will be used in place of the source client IP address. If the XFF header does not have at least two addresses or does not exist then the source client IP address will be used instead.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cpln as cpln

    gvc = cpln.get_gvc(name="gvc-example")
    pulumi.export("gvcId", gvc.id)
    pulumi.export("gvcLocations", gvc.locations)
    ```
    """
    __args__ = dict()
    __args__['controlplaneTracing'] = controlplane_tracing
    __args__['domain'] = domain
    __args__['endpointNamingFormat'] = endpoint_naming_format
    __args__['env'] = env
    __args__['lightstepTracing'] = lightstep_tracing
    __args__['loadBalancer'] = load_balancer
    __args__['locations'] = locations
    __args__['name'] = name
    __args__['otelTracing'] = otel_tracing
    __args__['pullSecrets'] = pull_secrets
    __args__['sidecar'] = sidecar
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cpln:index/getGvc:getGvc', __args__, opts=opts, typ=GetGvcResult).value

    return AwaitableGetGvcResult(
        alias=pulumi.get(__ret__, 'alias'),
        controlplane_tracing=pulumi.get(__ret__, 'controlplane_tracing'),
        cpln_id=pulumi.get(__ret__, 'cpln_id'),
        description=pulumi.get(__ret__, 'description'),
        domain=pulumi.get(__ret__, 'domain'),
        endpoint_naming_format=pulumi.get(__ret__, 'endpoint_naming_format'),
        env=pulumi.get(__ret__, 'env'),
        id=pulumi.get(__ret__, 'id'),
        lightstep_tracing=pulumi.get(__ret__, 'lightstep_tracing'),
        load_balancer=pulumi.get(__ret__, 'load_balancer'),
        locations=pulumi.get(__ret__, 'locations'),
        name=pulumi.get(__ret__, 'name'),
        otel_tracing=pulumi.get(__ret__, 'otel_tracing'),
        pull_secrets=pulumi.get(__ret__, 'pull_secrets'),
        self_link=pulumi.get(__ret__, 'self_link'),
        sidecar=pulumi.get(__ret__, 'sidecar'),
        tags=pulumi.get(__ret__, 'tags'))
def get_gvc_output(controlplane_tracing: Optional[pulumi.Input[Optional[Union['GetGvcControlplaneTracingArgs', 'GetGvcControlplaneTracingArgsDict']]]] = None,
                   domain: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                   endpoint_naming_format: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                   env: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                   lightstep_tracing: Optional[pulumi.Input[Optional[Union['GetGvcLightstepTracingArgs', 'GetGvcLightstepTracingArgsDict']]]] = None,
                   load_balancer: Optional[pulumi.Input[Optional[Union['GetGvcLoadBalancerArgs', 'GetGvcLoadBalancerArgsDict']]]] = None,
                   locations: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                   name: Optional[pulumi.Input[builtins.str]] = None,
                   otel_tracing: Optional[pulumi.Input[Optional[Union['GetGvcOtelTracingArgs', 'GetGvcOtelTracingArgsDict']]]] = None,
                   pull_secrets: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                   sidecar: Optional[pulumi.Input[Optional[Union['GetGvcSidecarArgs', 'GetGvcSidecarArgsDict']]]] = None,
                   tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGvcResult]:
    """
    Use this data source to access information about an existing [Global Virtual Cloud (GVC)](https://docs.controlplane.com/reference/gvc) within Control Plane.

    ## Required

    - **name** (String) Name of the GVC.

    ## Outputs

    The following attributes are exported:

    - **cpln_id** (String) The ID, in GUID format, of the GVC.
    - **name** (String) Name of the GVC.
    - **alias** (String) The alias name of the GVC.
    - **description** (String) Description of the GVC.
    - **tags** (Map of String) Key-value map of resource tags.
    - **self_link** (String) Full link to this resource. Can be referenced by other resources.
    - **domain** (String) Custom domain name used by associated workloads.
    - **locations** (List of String) A list of [locations](https://docs.controlplane.com/reference/location#current) making up the Global Virtual Cloud.
    - **pull_secrets** (List of String) A list of [pull secret](https://docs.controlplane.com/reference/gvc#pull-secrets) names used to authenticate to any private image repository referenced by Workloads within the GVC.
    - **lightstep_tracing** (Block List, Max: 1) (see below).
    - **otel_tracing** (Block List, Max: 1) (see below).
    - **controlplane_tracing** (Block List, Max: 1) (see below).
    - **load_balancer** (Block List, Max: 1) (see below).

    <a id="nestedblock--lightstep_tracing"></a>

    ### `lightstep_tracing`

    - **sampling** (Int) Sampling percentage.
    - **endpoint** (String) Tracing Endpoint Workload. Either the canonical endpoint or the internal endpoint.
    - **credentials** (String) Full link to referenced Opaque Secret.

    <a id="nestedblock--otel_tracing"></a>

    ### `otel_tracing`

    - **sampling** (Int) Determines what percentage of requests should be traced.
    - **endpoint** (String) Tracing Endpoint Workload. Either the canonical endpoint or internal endpoint.
    - **custom_tags** (Map of String) Key-value map of custom tags.

    <a id="nestedblock--controlplane_tracing"></a>

    ### `controlplane_tracing`

    - **sampling** (Int) Determines what percentage of requests should be traced.
    - **custom_tags** (Map of String) Key-value map of custom tags.

    <a id="nestedblock--load_balancer"></a>

    ### `load_balancer`

    - **dedicated** (Boolean) Creates a dedicated load balancer in each location and enables additional Domain features: custom ports, protocols and wildcard hostnames. Charges apply for each location.

    - **trusted_proxies** (Int) Controls the address used for request logging and for setting the X-Envoy-External-Address header. If set to 1, then the last address in an existing X-Forwarded-For header will be used in place of the source client IP address. If set to 2, then the second to last address in an existing X-Forwarded-For header will be used in place of the source client IP address. If the XFF header does not have at least two addresses or does not exist then the source client IP address will be used instead.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cpln as cpln

    gvc = cpln.get_gvc(name="gvc-example")
    pulumi.export("gvcId", gvc.id)
    pulumi.export("gvcLocations", gvc.locations)
    ```
    """
    __args__ = dict()
    __args__['controlplaneTracing'] = controlplane_tracing
    __args__['domain'] = domain
    __args__['endpointNamingFormat'] = endpoint_naming_format
    __args__['env'] = env
    __args__['lightstepTracing'] = lightstep_tracing
    __args__['loadBalancer'] = load_balancer
    __args__['locations'] = locations
    __args__['name'] = name
    __args__['otelTracing'] = otel_tracing
    __args__['pullSecrets'] = pull_secrets
    __args__['sidecar'] = sidecar
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cpln:index/getGvc:getGvc', __args__, opts=opts, typ=GetGvcResult)
    return __ret__.apply(lambda __response__: GetGvcResult(
        alias=pulumi.get(__response__, 'alias'),
        controlplane_tracing=pulumi.get(__response__, 'controlplane_tracing'),
        cpln_id=pulumi.get(__response__, 'cpln_id'),
        description=pulumi.get(__response__, 'description'),
        domain=pulumi.get(__response__, 'domain'),
        endpoint_naming_format=pulumi.get(__response__, 'endpoint_naming_format'),
        env=pulumi.get(__response__, 'env'),
        id=pulumi.get(__response__, 'id'),
        lightstep_tracing=pulumi.get(__response__, 'lightstep_tracing'),
        load_balancer=pulumi.get(__response__, 'load_balancer'),
        locations=pulumi.get(__response__, 'locations'),
        name=pulumi.get(__response__, 'name'),
        otel_tracing=pulumi.get(__response__, 'otel_tracing'),
        pull_secrets=pulumi.get(__response__, 'pull_secrets'),
        self_link=pulumi.get(__response__, 'self_link'),
        sidecar=pulumi.get(__response__, 'sidecar'),
        tags=pulumi.get(__response__, 'tags')))
