# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOrgResult',
    'AwaitableGetOrgResult',
    'get_org',
    'get_org_output',
]

@pulumi.output_type
class GetOrgResult:
    """
    A collection of values returned by getOrg.
    """
    def __init__(__self__, account_id=None, auth_config=None, cpln_id=None, description=None, id=None, invitees=None, name=None, observability=None, security=None, self_link=None, session_timeout_seconds=None, statuses=None, tags=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if auth_config and not isinstance(auth_config, dict):
            raise TypeError("Expected argument 'auth_config' to be a dict")
        pulumi.set(__self__, "auth_config", auth_config)
        if cpln_id and not isinstance(cpln_id, str):
            raise TypeError("Expected argument 'cpln_id' to be a str")
        pulumi.set(__self__, "cpln_id", cpln_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if invitees and not isinstance(invitees, list):
            raise TypeError("Expected argument 'invitees' to be a list")
        pulumi.set(__self__, "invitees", invitees)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if observability and not isinstance(observability, dict):
            raise TypeError("Expected argument 'observability' to be a dict")
        pulumi.set(__self__, "observability", observability)
        if security and not isinstance(security, dict):
            raise TypeError("Expected argument 'security' to be a dict")
        pulumi.set(__self__, "security", security)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if session_timeout_seconds and not isinstance(session_timeout_seconds, int):
            raise TypeError("Expected argument 'session_timeout_seconds' to be a int")
        pulumi.set(__self__, "session_timeout_seconds", session_timeout_seconds)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> Optional['outputs.GetOrgAuthConfigResult']:
        return pulumi.get(self, "auth_config")

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> builtins.str:
        return pulumi.get(self, "cpln_id")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def invitees(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "invitees")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def observability(self) -> Optional['outputs.GetOrgObservabilityResult']:
        return pulumi.get(self, "observability")

    @property
    @pulumi.getter
    def security(self) -> Optional['outputs.GetOrgSecurityResult']:
        return pulumi.get(self, "security")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> builtins.str:
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="sessionTimeoutSeconds")
    def session_timeout_seconds(self) -> builtins.int:
        return pulumi.get(self, "session_timeout_seconds")

    @property
    @pulumi.getter
    def statuses(self) -> Sequence['outputs.GetOrgStatusResult']:
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "tags")


class AwaitableGetOrgResult(GetOrgResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrgResult(
            account_id=self.account_id,
            auth_config=self.auth_config,
            cpln_id=self.cpln_id,
            description=self.description,
            id=self.id,
            invitees=self.invitees,
            name=self.name,
            observability=self.observability,
            security=self.security,
            self_link=self.self_link,
            session_timeout_seconds=self.session_timeout_seconds,
            statuses=self.statuses,
            tags=self.tags)


def get_org(auth_config: Optional[Union['GetOrgAuthConfigArgs', 'GetOrgAuthConfigArgsDict']] = None,
            observability: Optional[Union['GetOrgObservabilityArgs', 'GetOrgObservabilityArgsDict']] = None,
            security: Optional[Union['GetOrgSecurityArgs', 'GetOrgSecurityArgsDict']] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrgResult:
    """
    Output the ID and name of the current [org](https://docs.controlplane.com/reference/org).

    ## Outputs

    The following attributes are exported:

    - **cpln_id** (String) The ID, in GUID format, of the org.
    - **name** (String) The name of org.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cpln as cpln

    org = cpln.get_org()
    pulumi.export("orgId", org.id)
    pulumi.export("orgName", org.name)
    ```
    """
    __args__ = dict()
    __args__['authConfig'] = auth_config
    __args__['observability'] = observability
    __args__['security'] = security
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cpln:index/getOrg:getOrg', __args__, opts=opts, typ=GetOrgResult).value

    return AwaitableGetOrgResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        auth_config=pulumi.get(__ret__, 'auth_config'),
        cpln_id=pulumi.get(__ret__, 'cpln_id'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        invitees=pulumi.get(__ret__, 'invitees'),
        name=pulumi.get(__ret__, 'name'),
        observability=pulumi.get(__ret__, 'observability'),
        security=pulumi.get(__ret__, 'security'),
        self_link=pulumi.get(__ret__, 'self_link'),
        session_timeout_seconds=pulumi.get(__ret__, 'session_timeout_seconds'),
        statuses=pulumi.get(__ret__, 'statuses'),
        tags=pulumi.get(__ret__, 'tags'))
def get_org_output(auth_config: Optional[pulumi.Input[Optional[Union['GetOrgAuthConfigArgs', 'GetOrgAuthConfigArgsDict']]]] = None,
                   observability: Optional[pulumi.Input[Optional[Union['GetOrgObservabilityArgs', 'GetOrgObservabilityArgsDict']]]] = None,
                   security: Optional[pulumi.Input[Optional[Union['GetOrgSecurityArgs', 'GetOrgSecurityArgsDict']]]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOrgResult]:
    """
    Output the ID and name of the current [org](https://docs.controlplane.com/reference/org).

    ## Outputs

    The following attributes are exported:

    - **cpln_id** (String) The ID, in GUID format, of the org.
    - **name** (String) The name of org.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cpln as cpln

    org = cpln.get_org()
    pulumi.export("orgId", org.id)
    pulumi.export("orgName", org.name)
    ```
    """
    __args__ = dict()
    __args__['authConfig'] = auth_config
    __args__['observability'] = observability
    __args__['security'] = security
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cpln:index/getOrg:getOrg', __args__, opts=opts, typ=GetOrgResult)
    return __ret__.apply(lambda __response__: GetOrgResult(
        account_id=pulumi.get(__response__, 'account_id'),
        auth_config=pulumi.get(__response__, 'auth_config'),
        cpln_id=pulumi.get(__response__, 'cpln_id'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        invitees=pulumi.get(__response__, 'invitees'),
        name=pulumi.get(__response__, 'name'),
        observability=pulumi.get(__response__, 'observability'),
        security=pulumi.get(__response__, 'security'),
        self_link=pulumi.get(__response__, 'self_link'),
        session_timeout_seconds=pulumi.get(__response__, 'session_timeout_seconds'),
        statuses=pulumi.get(__response__, 'statuses'),
        tags=pulumi.get(__response__, 'tags')))
