# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['Mk8sKubeconfigArgs', 'Mk8sKubeconfig']

@pulumi.input_type
class Mk8sKubeconfigArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 profile: Optional[pulumi.Input[builtins.str]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Mk8sKubeconfig resource.
        :param pulumi.Input[builtins.str] name: Name of the MK8s to create the Kubeconfig for.
        :param pulumi.Input[builtins.str] profile: Profile name to extract the token from.
        :param pulumi.Input[builtins.str] service_account: A service account to add a key to.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the MK8s to create the Kubeconfig for.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Profile name to extract the token from.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A service account to add a key to.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account", value)


@pulumi.input_type
class _Mk8sKubeconfigState:
    def __init__(__self__, *,
                 kubeconfig: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 profile: Optional[pulumi.Input[builtins.str]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Mk8sKubeconfig resources.
        :param pulumi.Input[builtins.str] kubeconfig: The Kubeconfig of your MK8s cluster in YAML format.
        :param pulumi.Input[builtins.str] name: Name of the MK8s to create the Kubeconfig for.
        :param pulumi.Input[builtins.str] profile: Profile name to extract the token from.
        :param pulumi.Input[builtins.str] service_account: A service account to add a key to.
        """
        if kubeconfig is not None:
            pulumi.set(__self__, "kubeconfig", kubeconfig)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter
    def kubeconfig(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Kubeconfig of your MK8s cluster in YAML format.
        """
        return pulumi.get(self, "kubeconfig")

    @kubeconfig.setter
    def kubeconfig(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kubeconfig", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the MK8s to create the Kubeconfig for.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Profile name to extract the token from.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A service account to add a key to.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account", value)


@pulumi.type_token("cpln:index/mk8sKubeconfig:Mk8sKubeconfig")
class Mk8sKubeconfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 profile: Optional[pulumi.Input[builtins.str]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Obtain the Cluster’s Kubeconfig.

        ## Declaration

        ### Required

        - **name** (String) Name of the Mk8s.

        > **Note** Only one of the below can be included in the resource.

        - **profile** (String) The name of the cpln profile used to generate the kubeconfig file for authenticating with your Kubernetes cluster.
        - **service_account** (String) The name of an existing service account for which a key will be generated, enabling kubeconfig-based authentication with your Kubernetes cluster.

        ## Outputs

        The following attributes are exported:

        - **kubeconfig** (String) The Kubeconfig in YAML format.

        ## Example Usage

        ### Profile

        ```python
        import pulumi
        import pulumiverse_cpln as cpln

        new = cpln.Mk8sKubeconfig("new", profile="default")
        pulumi.export("generic-cluster-kubeconfig", new.kubeconfig)
        ```

        ### Service Account

        ```python
        import pulumi
        import pulumiverse_cpln as cpln

        new = cpln.Mk8sKubeconfig("new", service_account="devops-sa")
        pulumi.export("generic-cluster-kubeconfig", new.kubeconfig)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: Name of the MK8s to create the Kubeconfig for.
        :param pulumi.Input[builtins.str] profile: Profile name to extract the token from.
        :param pulumi.Input[builtins.str] service_account: A service account to add a key to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[Mk8sKubeconfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Obtain the Cluster’s Kubeconfig.

        ## Declaration

        ### Required

        - **name** (String) Name of the Mk8s.

        > **Note** Only one of the below can be included in the resource.

        - **profile** (String) The name of the cpln profile used to generate the kubeconfig file for authenticating with your Kubernetes cluster.
        - **service_account** (String) The name of an existing service account for which a key will be generated, enabling kubeconfig-based authentication with your Kubernetes cluster.

        ## Outputs

        The following attributes are exported:

        - **kubeconfig** (String) The Kubeconfig in YAML format.

        ## Example Usage

        ### Profile

        ```python
        import pulumi
        import pulumiverse_cpln as cpln

        new = cpln.Mk8sKubeconfig("new", profile="default")
        pulumi.export("generic-cluster-kubeconfig", new.kubeconfig)
        ```

        ### Service Account

        ```python
        import pulumi
        import pulumiverse_cpln as cpln

        new = cpln.Mk8sKubeconfig("new", service_account="devops-sa")
        pulumi.export("generic-cluster-kubeconfig", new.kubeconfig)
        ```

        :param str resource_name: The name of the resource.
        :param Mk8sKubeconfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Mk8sKubeconfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 profile: Optional[pulumi.Input[builtins.str]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Mk8sKubeconfigArgs.__new__(Mk8sKubeconfigArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["profile"] = profile
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["kubeconfig"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["kubeconfig"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Mk8sKubeconfig, __self__).__init__(
            'cpln:index/mk8sKubeconfig:Mk8sKubeconfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            kubeconfig: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            profile: Optional[pulumi.Input[builtins.str]] = None,
            service_account: Optional[pulumi.Input[builtins.str]] = None) -> 'Mk8sKubeconfig':
        """
        Get an existing Mk8sKubeconfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] kubeconfig: The Kubeconfig of your MK8s cluster in YAML format.
        :param pulumi.Input[builtins.str] name: Name of the MK8s to create the Kubeconfig for.
        :param pulumi.Input[builtins.str] profile: Profile name to extract the token from.
        :param pulumi.Input[builtins.str] service_account: A service account to add a key to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Mk8sKubeconfigState.__new__(_Mk8sKubeconfigState)

        __props__.__dict__["kubeconfig"] = kubeconfig
        __props__.__dict__["name"] = name
        __props__.__dict__["profile"] = profile
        __props__.__dict__["service_account"] = service_account
        return Mk8sKubeconfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def kubeconfig(self) -> pulumi.Output[builtins.str]:
        """
        The Kubeconfig of your MK8s cluster in YAML format.
        """
        return pulumi.get(self, "kubeconfig")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the MK8s to create the Kubeconfig for.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def profile(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Profile name to extract the token from.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A service account to add a key to.
        """
        return pulumi.get(self, "service_account")

