# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetExternalExadataInfrastructureResult',
    'AwaitableGetExternalExadataInfrastructureResult',
    'get_external_exadata_infrastructure',
    'get_external_exadata_infrastructure_output',
]

@pulumi.output_type
class GetExternalExadataInfrastructureResult:
    """
    A collection of values returned by getExternalExadataInfrastructure.
    """
    def __init__(__self__, additional_details=None, compartment_id=None, database_compartments=None, database_systems=None, db_system_ids=None, discovery_key=None, display_name=None, external_exadata_infrastructure_id=None, id=None, internal_id=None, license_model=None, lifecycle_details=None, rack_size=None, state=None, status=None, storage_grids=None, storage_server_names=None, time_created=None, time_updated=None, version=None):
        if additional_details and not isinstance(additional_details, dict):
            raise TypeError("Expected argument 'additional_details' to be a dict")
        pulumi.set(__self__, "additional_details", additional_details)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_compartments and not isinstance(database_compartments, list):
            raise TypeError("Expected argument 'database_compartments' to be a list")
        pulumi.set(__self__, "database_compartments", database_compartments)
        if database_systems and not isinstance(database_systems, list):
            raise TypeError("Expected argument 'database_systems' to be a list")
        pulumi.set(__self__, "database_systems", database_systems)
        if db_system_ids and not isinstance(db_system_ids, list):
            raise TypeError("Expected argument 'db_system_ids' to be a list")
        pulumi.set(__self__, "db_system_ids", db_system_ids)
        if discovery_key and not isinstance(discovery_key, str):
            raise TypeError("Expected argument 'discovery_key' to be a str")
        pulumi.set(__self__, "discovery_key", discovery_key)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if external_exadata_infrastructure_id and not isinstance(external_exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'external_exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "external_exadata_infrastructure_id", external_exadata_infrastructure_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internal_id and not isinstance(internal_id, str):
            raise TypeError("Expected argument 'internal_id' to be a str")
        pulumi.set(__self__, "internal_id", internal_id)
        if license_model and not isinstance(license_model, str):
            raise TypeError("Expected argument 'license_model' to be a str")
        pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if rack_size and not isinstance(rack_size, str):
            raise TypeError("Expected argument 'rack_size' to be a str")
        pulumi.set(__self__, "rack_size", rack_size)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if storage_grids and not isinstance(storage_grids, list):
            raise TypeError("Expected argument 'storage_grids' to be a list")
        pulumi.set(__self__, "storage_grids", storage_grids)
        if storage_server_names and not isinstance(storage_server_names, list):
            raise TypeError("Expected argument 'storage_server_names' to be a list")
        pulumi.set(__self__, "storage_server_names", storage_server_names)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Mapping[str, Any]:
        """
        The additional details of the resource defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseCompartments")
    def database_compartments(self) -> Sequence[str]:
        """
        The list of [OCIDs] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartments.
        """
        return pulumi.get(self, "database_compartments")

    @property
    @pulumi.getter(name="databaseSystems")
    def database_systems(self) -> Sequence['outputs.GetExternalExadataInfrastructureDatabaseSystemResult']:
        """
        A list of DB systems.
        """
        return pulumi.get(self, "database_systems")

    @property
    @pulumi.getter(name="dbSystemIds")
    def db_system_ids(self) -> Sequence[str]:
        return pulumi.get(self, "db_system_ids")

    @property
    @pulumi.getter(name="discoveryKey")
    def discovery_key(self) -> str:
        return pulumi.get(self, "discovery_key")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The name of the Exadata resource. English letters, numbers, "-", "_" and "." only.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalExadataInfrastructureId")
    def external_exadata_infrastructure_id(self) -> str:
        return pulumi.get(self, "external_exadata_infrastructure_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internalId")
    def internal_id(self) -> str:
        """
        The internal ID of the Exadata resource.
        """
        return pulumi.get(self, "internal_id")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> str:
        """
        The Oracle license model that applies to the database management resources.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        The details of the lifecycle state of the Exadata resource.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="rackSize")
    def rack_size(self) -> str:
        """
        The rack size of the Exadata infrastructure.
        """
        return pulumi.get(self, "rack_size")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the database resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the Exadata resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageGrids")
    def storage_grids(self) -> Sequence['outputs.GetExternalExadataInfrastructureStorageGridResult']:
        """
        The Exadata storage server grid of the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_grids")

    @property
    @pulumi.getter(name="storageServerNames")
    def storage_server_names(self) -> Sequence[str]:
        return pulumi.get(self, "storage_server_names")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The timestamp of the creation of the Exadata resource.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The timestamp of the last update of the Exadata resource.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the Exadata resource.
        """
        return pulumi.get(self, "version")


class AwaitableGetExternalExadataInfrastructureResult(GetExternalExadataInfrastructureResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalExadataInfrastructureResult(
            additional_details=self.additional_details,
            compartment_id=self.compartment_id,
            database_compartments=self.database_compartments,
            database_systems=self.database_systems,
            db_system_ids=self.db_system_ids,
            discovery_key=self.discovery_key,
            display_name=self.display_name,
            external_exadata_infrastructure_id=self.external_exadata_infrastructure_id,
            id=self.id,
            internal_id=self.internal_id,
            license_model=self.license_model,
            lifecycle_details=self.lifecycle_details,
            rack_size=self.rack_size,
            state=self.state,
            status=self.status,
            storage_grids=self.storage_grids,
            storage_server_names=self.storage_server_names,
            time_created=self.time_created,
            time_updated=self.time_updated,
            version=self.version)


def get_external_exadata_infrastructure(external_exadata_infrastructure_id: Optional[str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalExadataInfrastructureResult:
    """
    This data source provides details about a specific External Exadata Infrastructure resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the Exadata infrastructure specified by externalExadataInfrastructureId. It includes the DB systems and storage grid within the
    Exadata infrastructure.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_exadata_infrastructure = oci.DatabaseManagement.get_external_exadata_infrastructure(external_exadata_infrastructure_id=oci_database_management_external_exadata_infrastructure["test_external_exadata_infrastructure"]["id"])
    ```


    :param str external_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
    """
    __args__ = dict()
    __args__['externalExadataInfrastructureId'] = external_exadata_infrastructure_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalExadataInfrastructure:getExternalExadataInfrastructure', __args__, opts=opts, typ=GetExternalExadataInfrastructureResult).value

    return AwaitableGetExternalExadataInfrastructureResult(
        additional_details=pulumi.get(__ret__, 'additional_details'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_compartments=pulumi.get(__ret__, 'database_compartments'),
        database_systems=pulumi.get(__ret__, 'database_systems'),
        db_system_ids=pulumi.get(__ret__, 'db_system_ids'),
        discovery_key=pulumi.get(__ret__, 'discovery_key'),
        display_name=pulumi.get(__ret__, 'display_name'),
        external_exadata_infrastructure_id=pulumi.get(__ret__, 'external_exadata_infrastructure_id'),
        id=pulumi.get(__ret__, 'id'),
        internal_id=pulumi.get(__ret__, 'internal_id'),
        license_model=pulumi.get(__ret__, 'license_model'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        rack_size=pulumi.get(__ret__, 'rack_size'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        storage_grids=pulumi.get(__ret__, 'storage_grids'),
        storage_server_names=pulumi.get(__ret__, 'storage_server_names'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_external_exadata_infrastructure)
def get_external_exadata_infrastructure_output(external_exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExternalExadataInfrastructureResult]:
    """
    This data source provides details about a specific External Exadata Infrastructure resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the Exadata infrastructure specified by externalExadataInfrastructureId. It includes the DB systems and storage grid within the
    Exadata infrastructure.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_exadata_infrastructure = oci.DatabaseManagement.get_external_exadata_infrastructure(external_exadata_infrastructure_id=oci_database_management_external_exadata_infrastructure["test_external_exadata_infrastructure"]["id"])
    ```


    :param str external_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
    """
    ...
