# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedDatabaseSqlPlanBaselineJobsResult',
    'AwaitableGetManagedDatabaseSqlPlanBaselineJobsResult',
    'get_managed_database_sql_plan_baseline_jobs',
    'get_managed_database_sql_plan_baseline_jobs_output',
]

@pulumi.output_type
class GetManagedDatabaseSqlPlanBaselineJobsResult:
    """
    A collection of values returned by getManagedDatabaseSqlPlanBaselineJobs.
    """
    def __init__(__self__, filters=None, id=None, managed_database_id=None, name=None, opc_named_credential_id=None, sql_plan_baseline_job_collections=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if opc_named_credential_id and not isinstance(opc_named_credential_id, str):
            raise TypeError("Expected argument 'opc_named_credential_id' to be a str")
        pulumi.set(__self__, "opc_named_credential_id", opc_named_credential_id)
        if sql_plan_baseline_job_collections and not isinstance(sql_plan_baseline_job_collections, list):
            raise TypeError("Expected argument 'sql_plan_baseline_job_collections' to be a list")
        pulumi.set(__self__, "sql_plan_baseline_job_collections", sql_plan_baseline_job_collections)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedDatabaseSqlPlanBaselineJobsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the job.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="opcNamedCredentialId")
    def opc_named_credential_id(self) -> Optional[str]:
        return pulumi.get(self, "opc_named_credential_id")

    @property
    @pulumi.getter(name="sqlPlanBaselineJobCollections")
    def sql_plan_baseline_job_collections(self) -> Sequence['outputs.GetManagedDatabaseSqlPlanBaselineJobsSqlPlanBaselineJobCollectionResult']:
        """
        The list of sql_plan_baseline_job_collection.
        """
        return pulumi.get(self, "sql_plan_baseline_job_collections")


class AwaitableGetManagedDatabaseSqlPlanBaselineJobsResult(GetManagedDatabaseSqlPlanBaselineJobsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseSqlPlanBaselineJobsResult(
            filters=self.filters,
            id=self.id,
            managed_database_id=self.managed_database_id,
            name=self.name,
            opc_named_credential_id=self.opc_named_credential_id,
            sql_plan_baseline_job_collections=self.sql_plan_baseline_job_collections)


def get_managed_database_sql_plan_baseline_jobs(filters: Optional[Sequence[pulumi.InputType['GetManagedDatabaseSqlPlanBaselineJobsFilterArgs']]] = None,
                                                managed_database_id: Optional[str] = None,
                                                name: Optional[str] = None,
                                                opc_named_credential_id: Optional[str] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseSqlPlanBaselineJobsResult:
    """
    This data source provides the list of Managed Database Sql Plan Baseline Jobs in Oracle Cloud Infrastructure Database Management service.

    Lists the database jobs used for loading SQL plan baselines in the specified Managed Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_sql_plan_baseline_jobs = oci.DatabaseManagement.get_managed_database_sql_plan_baseline_jobs(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        name=var["managed_database_sql_plan_baseline_job_name"],
        opc_named_credential_id=var["managed_database_sql_plan_baseline_job_opc_named_credential_id"])
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str name: A filter to return the SQL plan baseline jobs that match the name.
    :param str opc_named_credential_id: The OCID of the Named Credential.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['managedDatabaseId'] = managed_database_id
    __args__['name'] = name
    __args__['opcNamedCredentialId'] = opc_named_credential_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabaseSqlPlanBaselineJobs:getManagedDatabaseSqlPlanBaselineJobs', __args__, opts=opts, typ=GetManagedDatabaseSqlPlanBaselineJobsResult).value

    return AwaitableGetManagedDatabaseSqlPlanBaselineJobsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        name=pulumi.get(__ret__, 'name'),
        opc_named_credential_id=pulumi.get(__ret__, 'opc_named_credential_id'),
        sql_plan_baseline_job_collections=pulumi.get(__ret__, 'sql_plan_baseline_job_collections'))


@_utilities.lift_output_func(get_managed_database_sql_plan_baseline_jobs)
def get_managed_database_sql_plan_baseline_jobs_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetManagedDatabaseSqlPlanBaselineJobsFilterArgs']]]]] = None,
                                                       managed_database_id: Optional[pulumi.Input[str]] = None,
                                                       name: Optional[pulumi.Input[Optional[str]]] = None,
                                                       opc_named_credential_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabaseSqlPlanBaselineJobsResult]:
    """
    This data source provides the list of Managed Database Sql Plan Baseline Jobs in Oracle Cloud Infrastructure Database Management service.

    Lists the database jobs used for loading SQL plan baselines in the specified Managed Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_sql_plan_baseline_jobs = oci.DatabaseManagement.get_managed_database_sql_plan_baseline_jobs(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        name=var["managed_database_sql_plan_baseline_job_name"],
        opc_named_credential_id=var["managed_database_sql_plan_baseline_job_opc_named_credential_id"])
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str name: A filter to return the SQL plan baseline jobs that match the name.
    :param str opc_named_credential_id: The OCID of the Named Credential.
    """
    ...
