# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ModelArgs', 'Model']

@pulumi.input_type
class ModelArgs:
    def __init__(__self__, *,
                 base_model_id: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 fine_tune_details: pulumi.Input['ModelFineTuneDetailsArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vendor: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Model resource.
        :param pulumi.Input[str] base_model_id: The OCID of the base model that's used for fine-tuning.
        :param pulumi.Input[str] compartment_id: (Updatable) The compartment OCID for fine-tuned models. For pretrained models, this value is null.
        :param pulumi.Input['ModelFineTuneDetailsArgs'] fine_tune_details: Details about fine-tuning a custom model.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) An optional description of the model.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] vendor: (Updatable) The provider of the model.
        :param pulumi.Input[str] version: (Updatable) The version of the model.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "base_model_id", base_model_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "fine_tune_details", fine_tune_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if vendor is not None:
            pulumi.set(__self__, "vendor", vendor)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="baseModelId")
    def base_model_id(self) -> pulumi.Input[str]:
        """
        The OCID of the base model that's used for fine-tuning.
        """
        return pulumi.get(self, "base_model_id")

    @base_model_id.setter
    def base_model_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "base_model_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The compartment OCID for fine-tuned models. For pretrained models, this value is null.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="fineTuneDetails")
    def fine_tune_details(self) -> pulumi.Input['ModelFineTuneDetailsArgs']:
        """
        Details about fine-tuning a custom model.
        """
        return pulumi.get(self, "fine_tune_details")

    @fine_tune_details.setter
    def fine_tune_details(self, value: pulumi.Input['ModelFineTuneDetailsArgs']):
        pulumi.set(self, "fine_tune_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An optional description of the model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def vendor(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The provider of the model.
        """
        return pulumi.get(self, "vendor")

    @vendor.setter
    def vendor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vendor", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The version of the model.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _ModelState:
    def __init__(__self__, *,
                 base_model_id: Optional[pulumi.Input[str]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fine_tune_details: Optional[pulumi.Input['ModelFineTuneDetailsArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_long_term_supported: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 model_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ModelModelMetricArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_deprecated: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vendor: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Model resources.
        :param pulumi.Input[str] base_model_id: The OCID of the base model that's used for fine-tuning.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] capabilities: Describes what this model can be used for.
        :param pulumi.Input[str] compartment_id: (Updatable) The compartment OCID for fine-tuned models. For pretrained models, this value is null.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) An optional description of the model.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name.
        :param pulumi.Input['ModelFineTuneDetailsArgs'] fine_tune_details: Details about fine-tuning a custom model.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_long_term_supported: Whether a model is supported long-term. Only applicable to base models.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state of the model in more detail that can provide actionable information.
        :param pulumi.Input[Sequence[pulumi.Input['ModelModelMetricArgs']]] model_metrics: Model metrics during the creation of a new model.
        :param pulumi.Input[str] state: The lifecycle state of the model.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time that the model was created in the format of an RFC3339 datetime string.
        :param pulumi.Input[str] time_deprecated: Corresponds to the time when the custom model and its associated foundation model will be deprecated.
        :param pulumi.Input[str] time_updated: The date and time that the model was updated in the format of an RFC3339 datetime string.
        :param pulumi.Input[str] type: The model type indicating whether this is a pretrained/base model or a custom/fine-tuned model.
        :param pulumi.Input[str] vendor: (Updatable) The provider of the model.
        :param pulumi.Input[str] version: (Updatable) The version of the model.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if base_model_id is not None:
            pulumi.set(__self__, "base_model_id", base_model_id)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fine_tune_details is not None:
            pulumi.set(__self__, "fine_tune_details", fine_tune_details)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_long_term_supported is not None:
            pulumi.set(__self__, "is_long_term_supported", is_long_term_supported)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if model_metrics is not None:
            pulumi.set(__self__, "model_metrics", model_metrics)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_deprecated is not None:
            pulumi.set(__self__, "time_deprecated", time_deprecated)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vendor is not None:
            pulumi.set(__self__, "vendor", vendor)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="baseModelId")
    def base_model_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the base model that's used for fine-tuning.
        """
        return pulumi.get(self, "base_model_id")

    @base_model_id.setter
    def base_model_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_model_id", value)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Describes what this model can be used for.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The compartment OCID for fine-tuned models. For pretrained models, this value is null.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An optional description of the model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="fineTuneDetails")
    def fine_tune_details(self) -> Optional[pulumi.Input['ModelFineTuneDetailsArgs']]:
        """
        Details about fine-tuning a custom model.
        """
        return pulumi.get(self, "fine_tune_details")

    @fine_tune_details.setter
    def fine_tune_details(self, value: Optional[pulumi.Input['ModelFineTuneDetailsArgs']]):
        pulumi.set(self, "fine_tune_details", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isLongTermSupported")
    def is_long_term_supported(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether a model is supported long-term. Only applicable to base models.
        """
        return pulumi.get(self, "is_long_term_supported")

    @is_long_term_supported.setter
    def is_long_term_supported(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_long_term_supported", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state of the model in more detail that can provide actionable information.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="modelMetrics")
    def model_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelModelMetricArgs']]]]:
        """
        Model metrics during the creation of a new model.
        """
        return pulumi.get(self, "model_metrics")

    @model_metrics.setter
    def model_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelModelMetricArgs']]]]):
        pulumi.set(self, "model_metrics", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The lifecycle state of the model.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time that the model was created in the format of an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeDeprecated")
    def time_deprecated(self) -> Optional[pulumi.Input[str]]:
        """
        Corresponds to the time when the custom model and its associated foundation model will be deprecated.
        """
        return pulumi.get(self, "time_deprecated")

    @time_deprecated.setter
    def time_deprecated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_deprecated", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time that the model was updated in the format of an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The model type indicating whether this is a pretrained/base model or a custom/fine-tuned model.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def vendor(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The provider of the model.
        """
        return pulumi.get(self, "vendor")

    @vendor.setter
    def vendor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vendor", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The version of the model.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class Model(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_model_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fine_tune_details: Optional[pulumi.Input[pulumi.InputType['ModelFineTuneDetailsArgs']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vendor: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Model resource in Oracle Cloud Infrastructure Generative Ai service.

        Creates a custom model by fine-tuning a base model with your own dataset. You can create a new custom models or create a new version of existing custom model..

        The header contains an opc-work-request-id, which is the id for the WorkRequest that tracks the model creation progress.

        ## Import

        Models can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:GenerativeAi/model:Model test_model "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] base_model_id: The OCID of the base model that's used for fine-tuning.
        :param pulumi.Input[str] compartment_id: (Updatable) The compartment OCID for fine-tuned models. For pretrained models, this value is null.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) An optional description of the model.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name.
        :param pulumi.Input[pulumi.InputType['ModelFineTuneDetailsArgs']] fine_tune_details: Details about fine-tuning a custom model.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] vendor: (Updatable) The provider of the model.
        :param pulumi.Input[str] version: (Updatable) The version of the model.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ModelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Model resource in Oracle Cloud Infrastructure Generative Ai service.

        Creates a custom model by fine-tuning a base model with your own dataset. You can create a new custom models or create a new version of existing custom model..

        The header contains an opc-work-request-id, which is the id for the WorkRequest that tracks the model creation progress.

        ## Import

        Models can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:GenerativeAi/model:Model test_model "id"
        ```

        :param str resource_name: The name of the resource.
        :param ModelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_model_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fine_tune_details: Optional[pulumi.Input[pulumi.InputType['ModelFineTuneDetailsArgs']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vendor: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModelArgs.__new__(ModelArgs)

            if base_model_id is None and not opts.urn:
                raise TypeError("Missing required property 'base_model_id'")
            __props__.__dict__["base_model_id"] = base_model_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            if fine_tune_details is None and not opts.urn:
                raise TypeError("Missing required property 'fine_tune_details'")
            __props__.__dict__["fine_tune_details"] = fine_tune_details
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["vendor"] = vendor
            __props__.__dict__["version"] = version
            __props__.__dict__["capabilities"] = None
            __props__.__dict__["is_long_term_supported"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["model_metrics"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_deprecated"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["type"] = None
        super(Model, __self__).__init__(
            'oci:GenerativeAi/model:Model',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            base_model_id: Optional[pulumi.Input[str]] = None,
            capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            fine_tune_details: Optional[pulumi.Input[pulumi.InputType['ModelFineTuneDetailsArgs']]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_long_term_supported: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            model_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ModelModelMetricArgs']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_deprecated: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            vendor: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'Model':
        """
        Get an existing Model resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] base_model_id: The OCID of the base model that's used for fine-tuning.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] capabilities: Describes what this model can be used for.
        :param pulumi.Input[str] compartment_id: (Updatable) The compartment OCID for fine-tuned models. For pretrained models, this value is null.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) An optional description of the model.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name.
        :param pulumi.Input[pulumi.InputType['ModelFineTuneDetailsArgs']] fine_tune_details: Details about fine-tuning a custom model.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_long_term_supported: Whether a model is supported long-term. Only applicable to base models.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state of the model in more detail that can provide actionable information.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ModelModelMetricArgs']]]] model_metrics: Model metrics during the creation of a new model.
        :param pulumi.Input[str] state: The lifecycle state of the model.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time that the model was created in the format of an RFC3339 datetime string.
        :param pulumi.Input[str] time_deprecated: Corresponds to the time when the custom model and its associated foundation model will be deprecated.
        :param pulumi.Input[str] time_updated: The date and time that the model was updated in the format of an RFC3339 datetime string.
        :param pulumi.Input[str] type: The model type indicating whether this is a pretrained/base model or a custom/fine-tuned model.
        :param pulumi.Input[str] vendor: (Updatable) The provider of the model.
        :param pulumi.Input[str] version: (Updatable) The version of the model.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ModelState.__new__(_ModelState)

        __props__.__dict__["base_model_id"] = base_model_id
        __props__.__dict__["capabilities"] = capabilities
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["fine_tune_details"] = fine_tune_details
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_long_term_supported"] = is_long_term_supported
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["model_metrics"] = model_metrics
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_deprecated"] = time_deprecated
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        __props__.__dict__["vendor"] = vendor
        __props__.__dict__["version"] = version
        return Model(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="baseModelId")
    def base_model_id(self) -> pulumi.Output[str]:
        """
        The OCID of the base model that's used for fine-tuning.
        """
        return pulumi.get(self, "base_model_id")

    @property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Sequence[str]]:
        """
        Describes what this model can be used for.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The compartment OCID for fine-tuned models. For pretrained models, this value is null.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) An optional description of the model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fineTuneDetails")
    def fine_tune_details(self) -> pulumi.Output['outputs.ModelFineTuneDetails']:
        """
        Details about fine-tuning a custom model.
        """
        return pulumi.get(self, "fine_tune_details")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isLongTermSupported")
    def is_long_term_supported(self) -> pulumi.Output[bool]:
        """
        Whether a model is supported long-term. Only applicable to base models.
        """
        return pulumi.get(self, "is_long_term_supported")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state of the model in more detail that can provide actionable information.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="modelMetrics")
    def model_metrics(self) -> pulumi.Output[Sequence['outputs.ModelModelMetric']]:
        """
        Model metrics during the creation of a new model.
        """
        return pulumi.get(self, "model_metrics")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The lifecycle state of the model.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time that the model was created in the format of an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeDeprecated")
    def time_deprecated(self) -> pulumi.Output[str]:
        """
        Corresponds to the time when the custom model and its associated foundation model will be deprecated.
        """
        return pulumi.get(self, "time_deprecated")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time that the model was updated in the format of an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The model type indicating whether this is a pretrained/base model or a custom/fine-tuned model.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def vendor(self) -> pulumi.Output[str]:
        """
        (Updatable) The provider of the model.
        """
        return pulumi.get(self, "vendor")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        (Updatable) The version of the model.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "version")

