# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDbSystemsResult',
    'AwaitableGetDbSystemsResult',
    'get_db_systems',
    'get_db_systems_output',
]

@pulumi.output_type
class GetDbSystemsResult:
    """
    A collection of values returned by getDbSystems.
    """
    def __init__(__self__, compartment_id=None, db_system_collections=None, display_name=None, filters=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_system_collections and not isinstance(db_system_collections, list):
            raise TypeError("Expected argument 'db_system_collections' to be a list")
        pulumi.set(__self__, "db_system_collections", db_system_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the database system.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbSystemCollections")
    def db_system_collections(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionResult']:
        """
        The list of db_system_collection.
        """
        return pulumi.get(self, "db_system_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly display name for the database instance node. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDbSystemsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        A unique identifier for the database instance node. Immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the database system.
        """
        return pulumi.get(self, "state")


class AwaitableGetDbSystemsResult(GetDbSystemsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbSystemsResult(
            compartment_id=self.compartment_id,
            db_system_collections=self.db_system_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_db_systems(compartment_id: Optional[str] = None,
                   display_name: Optional[str] = None,
                   filters: Optional[Sequence[pulumi.InputType['GetDbSystemsFilterArgs']]] = None,
                   id: Optional[str] = None,
                   state: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbSystemsResult:
    """
    This data source provides the list of Db Systems in Oracle Cloud Infrastructure Psql service.

    Returns a list of database systems.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_systems = oci.Psql.get_db_systems(compartment_id=var["compartment_id"],
        display_name=var["db_system_display_name"],
        id=var["db_system_id"],
        state=var["db_system_state"])
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: A unique identifier for the database system.
    :param str state: A filter to return only resources if their `lifecycleState` matches the given `lifecycleState`.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Psql/getDbSystems:getDbSystems', __args__, opts=opts, typ=GetDbSystemsResult).value

    return AwaitableGetDbSystemsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_system_collections=pulumi.get(__ret__, 'db_system_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_db_systems)
def get_db_systems_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                          display_name: Optional[pulumi.Input[Optional[str]]] = None,
                          filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDbSystemsFilterArgs']]]]] = None,
                          id: Optional[pulumi.Input[Optional[str]]] = None,
                          state: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbSystemsResult]:
    """
    This data source provides the list of Db Systems in Oracle Cloud Infrastructure Psql service.

    Returns a list of database systems.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_systems = oci.Psql.get_db_systems(compartment_id=var["compartment_id"],
        display_name=var["db_system_display_name"],
        id=var["db_system_id"],
        state=var["db_system_state"])
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: A unique identifier for the database system.
    :param str state: A filter to return only resources if their `lifecycleState` matches the given `lifecycleState`.
    """
    ...
