"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TarballImageAsset = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const ecr = require("@aws-cdk/aws-ecr");
const core_1 = require("@aws-cdk/core");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * An asset that represents a Docker image.
 *
 * The image will loaded from an existing tarball and uploaded to an ECR repository.
 */
class TarballImageAsset extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ecr_assets_TarballImageAssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, TarballImageAsset);
            }
            throw error;
        }
        if (!fs.existsSync(props.tarballFile)) {
            throw new Error(`Cannot find file at ${props.tarballFile}`);
        }
        const stagedTarball = new core_1.AssetStaging(this, 'Staging', { sourcePath: props.tarballFile });
        this.sourceHash = stagedTarball.assetHash;
        this.assetHash = stagedTarball.assetHash;
        const stage = core_1.Stage.of(this);
        const relativePathInOutDir = stage ? path.relative(stage.assetOutdir, stagedTarball.absoluteStagedPath) : stagedTarball.absoluteStagedPath;
        const stack = core_1.Stack.of(this);
        const location = stack.synthesizer.addDockerImageAsset({
            sourceHash: stagedTarball.assetHash,
            executable: [
                'sh',
                '-c',
                `docker load -i ${relativePathInOutDir} | sed "s/Loaded image: //g"`,
            ],
        });
        this.repository = ecr.Repository.fromRepositoryName(this, 'Repository', location.repositoryName);
        this.imageUri = location.imageUri;
    }
}
exports.TarballImageAsset = TarballImageAsset;
_a = JSII_RTTI_SYMBOL_1;
TarballImageAsset[_a] = { fqn: "@aws-cdk/aws-ecr-assets.TarballImageAsset", version: "1.164.0" };
//# sourceMappingURL=data:application/json;base64,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