/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.main.api.sax;

import com.siemens.ct.exi.core.EXIBodyEncoder;
import com.siemens.ct.exi.core.EXIFactory;
import com.siemens.ct.exi.core.EXIStreamEncoder;
import com.siemens.ct.exi.core.attributes.AttributeFactory;
import com.siemens.ct.exi.core.attributes.AttributeList;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.values.StringValue;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class SAXEncoder
extends DefaultHandler2 {
    protected EXIFactory factory;
    protected EXIStreamEncoder exiStream;
    protected EXIBodyEncoder encoder;
    protected AttributeList exiAttributes;

    public SAXEncoder(EXIFactory factory) throws EXIException {
        this.factory = factory;
        this.exiStream = factory.createEXIStreamEncoder();
        AttributeFactory attFactory = AttributeFactory.newInstance();
        this.exiAttributes = attFactory.createAttributeListInstance(factory);
    }

    public void setOutputStream(OutputStream os) throws EXIException, IOException {
        if (!(os instanceof BufferedOutputStream || os instanceof ByteArrayOutputStream || os instanceof DataOutputStream)) {
            os = new BufferedOutputStream(os);
        }
        this.encoder = this.exiStream.encodeHeader(os);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.exiAttributes.addNamespaceDeclaration(uri, prefix);
    }

    @Override
    public void startElement(String uri, String local, String raw, Attributes attributes) throws SAXException {
        try {
            this.startElementPfx(uri, local, null, attributes);
        }
        catch (Exception e) {
            throw new SAXException("startElement: " + raw, e);
        }
    }

    protected void startElementPfx(String uri, String local, String prefix, Attributes attributes) throws EXIException, IOException {
        this.encoder.encodeStartElement(uri, local, prefix);
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                this.exiAttributes.addAttribute(attributes.getURI(i), attributes.getLocalName(i), this.getPrefixOf(attributes, i), attributes.getValue(i));
                ++i;
            }
        }
        this.encoder.encodeAttributeList(this.exiAttributes);
        this.exiAttributes.clear();
    }

    private String getPrefixOf(Attributes atts, int index) {
        String qname = atts.getQName(index);
        String localName = atts.getLocalName(index);
        int lengthDifference = qname.length() - localName.length();
        return lengthDifference == 0 ? "" : qname.substring(0, lengthDifference - 1);
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.encoder.encodeStartDocument();
        }
        catch (Exception e) {
            throw new SAXException("startDocument", e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.encoder.encodeEndDocument();
            this.encoder.flush();
        }
        catch (Exception e) {
            throw new SAXException("endDocument", e);
        }
    }

    @Override
    public void endElement(String uri, String local, String raw) throws SAXException {
        try {
            this.encoder.encodeEndElement();
        }
        catch (Exception e) {
            throw new SAXException("endElement=" + raw, e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.encoder.encodeCharacters(new StringValue(new String(ch, start, length)));
        }
        catch (Exception e) {
            throw new SAXException("characters=" + new String(ch, start, length), e);
        }
    }
}

