/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.main.cmd;

import com.siemens.ct.exi.core.CodingMode;
import com.siemens.ct.exi.core.EXIFactory;
import com.siemens.ct.exi.core.FidelityOptions;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.grammars.Grammars;
import com.siemens.ct.exi.core.helpers.DefaultEXIFactory;
import com.siemens.ct.exi.grammars.GrammarFactory;
import com.siemens.ct.exi.main.api.sax.EXIResult;
import com.siemens.ct.exi.main.api.sax.SAXFactory;
import com.siemens.ct.exi.main.cmd.BuiltInSchema;
import com.siemens.ct.exi.main.cmd.CmdOption;
import com.siemens.ct.exi.main.cmd.EXICodec;
import com.siemens.ct.exi.main.cmd.SchemaOption;
import com.siemens.ct.exi.main.generatedgrammar.CommonAppProtocol;
import com.siemens.ct.exi.main.generatedgrammar.ISO15118_20_V2G_CI_AC;
import com.siemens.ct.exi.main.generatedgrammar.ISO15118_20_V2G_CI_ACDP;
import com.siemens.ct.exi.main.generatedgrammar.ISO15118_20_V2G_CI_CommonMessages;
import com.siemens.ct.exi.main.generatedgrammar.ISO15118_20_V2G_CI_DC;
import com.siemens.ct.exi.main.generatedgrammar.ISO15118_20_V2G_CI_WPT;
import com.siemens.ct.exi.main.generatedgrammar.ISO15118_2Grammar;
import com.siemens.ct.exi.main.generatedgrammar.W3NotebookGrammar;
import com.siemens.ct.exi.main.generatedgrammar.XMLDSIG_Core_Schema_Grammar;
import com.siemens.ct.exi.main.util.FragmentUtilities;
import com.siemens.ct.exi.main.util.NoEntityResolver;
import com.siemens.ct.exi.main.util.SkipRootElementXMLReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class EXIficientCMD {
    public static final PrintStream ps = System.out;
    public static final String HELP = "-h";
    public static final String ENCODE = "-" + (Object)((Object)CmdOption.encode);
    public static final String DECODE = "-" + (Object)((Object)CmdOption.decode);
    public static final String INPUT = "-i";
    public static final String OUTPUT = "-o";
    public static final String NO_SCHEMA = "-" + (Object)((Object)SchemaOption.noSchema);
    public static final String XSD_SCHEMA = "-" + (Object)((Object)SchemaOption.xsdSchema);
    public static final String SCHEMA = "-" + (Object)((Object)SchemaOption.schema);
    public static final String ExternalSchema = "-" + (Object)((Object)BuiltInSchema.External);
    public static final String AppProtocolSchema = "-" + (Object)((Object)BuiltInSchema.AppProtocol);
    public static final String NotebookSchema = "-" + (Object)((Object)BuiltInSchema.Notebook);
    public static final String XSDCoreSchema = "-" + (Object)((Object)BuiltInSchema.XSDCore);
    public static final String ISO15118_2Schema = "-" + (Object)((Object)BuiltInSchema.ISO15118_2);
    public static final String ISO15118_20Schema = "-" + (Object)((Object)BuiltInSchema.ISO15118_20_V2G_CI_CommonMessages);
    public static final String OPTION_STRICT = "-strict";
    public static final String PRESERVE_COMMENTS = "-preserveComments";
    public static final String PRESERVE_LEXICAL_VALUES = "-preserveLexicalValues";
    public static final String PRESERVE_PREFIXES = "-preservePrefixes";
    public static final String PRESERVE_PIS = "-preservePIs";
    public static final String PRESERVE_DTDS = "-preserveDTDs";
    public static final String INCLUDE_OPTIONS = "-includeOptions";
    public static final String INCLUDE_COOKIE = "-includeCookie";
    public static final String INCLUDE_SCHEMA_ID = "-includeSchemaId";
    public static final String INCLUDE_SCHEMA_LOCATION = "-includeSchemaLocation";
    public static final String INCLUDE_INSIGNIFICANT_XSI_NIL = "-includeInsignificantXsiNil";
    public static final String INCLUDE_PROFILE_VALUES = "-includeProfileValues";
    public static final String RETAIN_ENTITY_REFERENCE = "-retainEntityReference";
    public static final String FRAGMENT = "-fragment";
    public static final String SELF_CONTAINED = "-selfContained";
    public static final String DATATYPE_REPRESENTATION_MAP = "-datatypeRepresentationMap";
    public static final String CODING_BYTEPACKED = "-bytePacked";
    public static final String CODING_PRE_COMPRESSION = "-preCompression";
    public static final String CODING_COMPRESSION = "-compression";
    public static final String BLOCK_SIZE = "-blockSize";
    public static final String VALUE_MAX_LENGTH = "-valueMaxLength";
    public static final String VALUE_PARTITION_CAPACITY = "-valuePartitionCapacity";
    public static final String NO_LOCAL_VALUE_PARTITIONS = "-noLocalValuePartitions";
    public static final String MAXIMUM_NUMBER_OF_BUILT_IN_PRODUCTIONS = "-maximumNumberOfBuiltInProductions";
    public static final String MAXIMUM_NUMBER_OF_BUILT_IN_ELEMENT_GRAMMARS = "-maximumNumberOfBuiltInElementGrammars";
    public static String DEFAULT_EXI_FILE_EXTENSION = ".exi";
    public static String DEFAULT_XML_FILE_EXTENSION = ".xml";
    protected boolean inputParametersOK;
    protected CmdOption cmdOption;
    protected EXIFactory exiFactory;
    protected String input;
    protected String output;
    private EXICodec exiCodec = new EXICodec();

    private static void printHeader() {
        ps.println("#########################################################################");
        ps.println("###   EXIficient                                                     ###");
        ps.println("###   Command-Shell Options                                          ###");
        ps.println("#########################################################################");
    }

    private static void printHelp() {
        EXIficientCMD.printHeader();
        ps.println();
        ps.println(" -h                               /* shows help */");
        ps.println();
        ps.println(" " + ENCODE);
        ps.println(" " + DECODE);
        ps.println();
        ps.println(" -i <input-file>");
        ps.println(" -o <output-file>");
        ps.println();
        ps.println(" " + SCHEMA + " <schema-input-file>");
        ps.println(" " + XSD_SCHEMA + "                       /* XML schema datatypes only */");
        ps.println(" " + NO_SCHEMA + "                        /* default */");
        ps.println();
        ps.println(" -strict");
        ps.println(" -preservePrefixes");
        ps.println(" -preserveComments");
        ps.println(" -preserveLexicalValues");
        ps.println(" -preservePIs                     /* processing instructions */");
        ps.println(" -preserveDTDs                    /* DTDs & entity references */");
        ps.println();
        ps.println(" -bytePacked");
        ps.println(" -preCompression");
        ps.println(" -compression");
        ps.println();
        ps.println(" -blockSize <value>");
        ps.println(" -valueMaxLength <value>");
        ps.println(" -valuePartitionCapacity <value>");
        ps.println();
        ps.println(" -noLocalValuePartitions          /* EXI Profile parameters */");
        ps.println(" -maximumNumberOfBuiltInProductions <value>");
        ps.println(" -maximumNumberOfBuiltInElementGrammars <value>");
        ps.println();
        ps.println(" -includeOptions");
        ps.println(" -includeCookie");
        ps.println(" -includeSchemaId");
        ps.println(" -includeSchemaLocation");
        ps.println(" -includeInsignificantXsiNil");
        ps.println(" -includeProfileValues");
        ps.println(" -retainEntityReference");
        ps.println(" -fragment");
        ps.println(" -selfContained <{urn:foo}elWithNS,elDefNS>");
        ps.println(" -datatypeRepresentationMap <qnameType,qnameRepresentation,{http://www.w3.org/2001/XMLSchema}decimal,{http://www.w3.org/2009/exi}string>");
        ps.println();
        ps.println("# Examples");
        ps.println(" " + ENCODE + " " + SCHEMA + " notebook.xsd " + INPUT + " notebook.xml");
        ps.println(" " + DECODE + " " + SCHEMA + " notebook.xsd " + INPUT + " notebook.xml.exi " + OUTPUT + " notebookDec.xml");
    }

    protected static void printError(String msg) {
        ps.println("[ERROR] " + msg);
    }

    protected static void printWarning(String msg) {
        ps.println("[Warning] " + msg);
    }

    protected void parseArguments(String[] args) throws EXIException {
        this.cmdOption = null;
        SchemaOption schemaOption = SchemaOption.noSchema;
        String schemaLocation = null;
        BuiltInSchema builtInSchemaOption = BuiltInSchema.External;
        this.input = null;
        this.output = null;
        this.exiFactory = DefaultEXIFactory.newInstance();
        boolean wIncludeOptions = false;
        boolean wIncludeSchemaId = false;
        boolean wIncludeProfileValues = false;
        boolean wStrict = false;
        boolean wPreserveComments = false;
        boolean wPreservePIs = false;
        boolean wPreservePrefixes = false;
        boolean wPreserveDTD = false;
        int indexArgument = 0;
        while (indexArgument < args.length) {
            StringTokenizer st;
            FidelityOptions fo;
            String argument = args[indexArgument];
            if (HELP.equalsIgnoreCase(argument)) {
                EXIficientCMD.printHelp();
                break;
            }
            if (ENCODE.equalsIgnoreCase(argument)) {
                this.cmdOption = CmdOption.encode;
            } else if (DECODE.equalsIgnoreCase(argument)) {
                this.cmdOption = CmdOption.decode;
            } else if (INPUT.equalsIgnoreCase(argument)) {
                assert (indexArgument + 1 < args.length);
                this.input = args[++indexArgument];
            } else if (OUTPUT.equalsIgnoreCase(argument)) {
                assert (indexArgument + 1 < args.length);
                this.output = args[++indexArgument];
            } else if (NO_SCHEMA.equalsIgnoreCase(argument)) {
                schemaOption = SchemaOption.noSchema;
            } else if (XSD_SCHEMA.equalsIgnoreCase(argument)) {
                schemaOption = SchemaOption.xsdSchema;
            } else if (SCHEMA.equalsIgnoreCase(argument)) {
                schemaOption = SchemaOption.schema;
                assert (indexArgument + 1 < args.length);
                schemaLocation = args[++indexArgument];
            } else if (ExternalSchema.equalsIgnoreCase(argument)) {
                builtInSchemaOption = BuiltInSchema.External;
            } else if (AppProtocolSchema.equalsIgnoreCase(argument)) {
                builtInSchemaOption = BuiltInSchema.AppProtocol;
            } else if (ISO15118_2Schema.equalsIgnoreCase(argument)) {
                builtInSchemaOption = BuiltInSchema.ISO15118_2;
            } else if (ISO15118_20Schema.equalsIgnoreCase(argument)) {
                builtInSchemaOption = BuiltInSchema.ISO15118_20_V2G_CI_CommonMessages;
            } else if (NotebookSchema.equalsIgnoreCase(argument)) {
                builtInSchemaOption = BuiltInSchema.Notebook;
            } else if (OPTION_STRICT.equalsIgnoreCase(argument)) {
                wStrict = true;
                fo = FidelityOptions.createStrict();
                this.exiFactory.setFidelityOptions(fo);
            } else if (BLOCK_SIZE.equalsIgnoreCase(argument)) {
                assert (indexArgument + 1 < args.length);
                int blockSize = Integer.parseInt(args[++indexArgument]);
                this.exiFactory.setBlockSize(blockSize);
            } else if (VALUE_MAX_LENGTH.equalsIgnoreCase(argument)) {
                assert (indexArgument + 1 < args.length);
                int valueMaxLength = Integer.parseInt(args[++indexArgument]);
                this.exiFactory.setValueMaxLength(valueMaxLength);
            } else if (VALUE_PARTITION_CAPACITY.equalsIgnoreCase(argument)) {
                assert (indexArgument + 1 < args.length);
                int valuePartitionCapacity = Integer.parseInt(args[++indexArgument]);
                this.exiFactory.setValuePartitionCapacity(valuePartitionCapacity);
            } else if (MAXIMUM_NUMBER_OF_BUILT_IN_ELEMENT_GRAMMARS.equalsIgnoreCase(argument)) {
                assert (indexArgument + 1 < args.length);
                int maximumNumberOfEvolvingBuiltInElementGrammars = Integer.parseInt(args[++indexArgument]);
                this.exiFactory.setMaximumNumberOfBuiltInElementGrammars(maximumNumberOfEvolvingBuiltInElementGrammars);
            } else if (MAXIMUM_NUMBER_OF_BUILT_IN_PRODUCTIONS.equalsIgnoreCase(argument)) {
                assert (indexArgument + 1 < args.length);
                int maximumNumberOfBuiltInProductions = Integer.parseInt(args[++indexArgument]);
                this.exiFactory.setMaximumNumberOfBuiltInProductions(maximumNumberOfBuiltInProductions);
            } else if (PRESERVE_COMMENTS.equalsIgnoreCase(argument)) {
                fo = this.exiFactory.getFidelityOptions();
                wPreserveComments = true;
                fo.setFidelity("PRESERVE_COMMENTS", true);
            } else if (PRESERVE_LEXICAL_VALUES.equalsIgnoreCase(argument)) {
                fo = this.exiFactory.getFidelityOptions();
                fo.setFidelity("PRESERVE_LEXICAL_VALUES", true);
            } else if (PRESERVE_PREFIXES.equalsIgnoreCase(argument)) {
                fo = this.exiFactory.getFidelityOptions();
                wPreservePrefixes = true;
                fo.setFidelity("PRESERVE_PREFIXES", true);
            } else if (PRESERVE_PIS.equalsIgnoreCase(argument)) {
                fo = this.exiFactory.getFidelityOptions();
                wPreservePIs = true;
                fo.setFidelity("PRESERVE_PIS", true);
            } else if (PRESERVE_DTDS.equalsIgnoreCase(argument)) {
                fo = this.exiFactory.getFidelityOptions();
                wPreserveDTD = true;
                fo.setFidelity("PRESERVE_DTDS", true);
            } else if (CODING_BYTEPACKED.equalsIgnoreCase(argument)) {
                this.exiFactory.setCodingMode(CodingMode.BYTE_PACKED);
            } else if (CODING_PRE_COMPRESSION.equalsIgnoreCase(argument)) {
                this.exiFactory.setCodingMode(CodingMode.PRE_COMPRESSION);
            } else if (CODING_COMPRESSION.equalsIgnoreCase(argument)) {
                this.exiFactory.setCodingMode(CodingMode.COMPRESSION);
            } else if (NO_LOCAL_VALUE_PARTITIONS.equalsIgnoreCase(argument)) {
                this.exiFactory.setLocalValuePartitions(false);
            } else if (INCLUDE_OPTIONS.equalsIgnoreCase(argument)) {
                wIncludeOptions = true;
                this.exiFactory.getEncodingOptions().setOption("INCLUDE_OPTIONS");
            } else if (INCLUDE_COOKIE.equalsIgnoreCase(argument)) {
                this.exiFactory.getEncodingOptions().setOption("INCLUDE_COOKIE");
            } else if (INCLUDE_SCHEMA_ID.equalsIgnoreCase(argument)) {
                wIncludeSchemaId = true;
                this.exiFactory.getEncodingOptions().setOption("INCLUDE_SCHEMA_ID");
            } else if (INCLUDE_SCHEMA_LOCATION.equalsIgnoreCase(argument)) {
                this.exiFactory.getEncodingOptions().setOption("INCLUDE_XSI_SCHEMALOCATION");
            } else if (INCLUDE_INSIGNIFICANT_XSI_NIL.equalsIgnoreCase(argument)) {
                this.exiFactory.getEncodingOptions().setOption("INCLUDE_INSIGNIFICANT_XSI_NIL");
            } else if (INCLUDE_PROFILE_VALUES.equalsIgnoreCase(argument)) {
                wIncludeProfileValues = true;
                this.exiFactory.getEncodingOptions().setOption("INCLUDE_PROFILE_VALUES");
            } else if (RETAIN_ENTITY_REFERENCE.equalsIgnoreCase(argument)) {
                this.exiFactory.getEncodingOptions().setOption("KEEP_ENTITY_REFERENCES_UNRESOLVED");
            } else if (FRAGMENT.equalsIgnoreCase(argument)) {
                this.exiFactory.setFragment(true);
            } else if (SELF_CONTAINED.equalsIgnoreCase(argument)) {
                assert (indexArgument + 1 < args.length);
                String qnames = args[++indexArgument];
                st = new StringTokenizer(qnames, ",");
                QName[] scElements = new QName[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    scElements[i++] = QName.valueOf(st.nextToken());
                }
                this.exiFactory.setSelfContainedElements(scElements);
                this.exiFactory.getFidelityOptions().setFidelity("SELF_CONTAINED", true);
            } else if (DATATYPE_REPRESENTATION_MAP.equalsIgnoreCase(argument)) {
                assert (indexArgument + 1 < args.length);
                String dtrs = args[++indexArgument];
                st = new StringTokenizer(dtrs, ",");
                assert (st.countTokens() % 2 == 0);
                QName[] dtrMapTypes = new QName[st.countTokens() / 2];
                QName[] dtrMapRepresentations = new QName[st.countTokens() / 2];
                int i = 0;
                while (st.hasMoreTokens()) {
                    dtrMapTypes[i] = QName.valueOf(st.nextToken());
                    dtrMapRepresentations[i] = QName.valueOf(st.nextToken());
                    ++i;
                }
                this.exiFactory.setDatatypeRepresentationMap(dtrMapTypes, dtrMapRepresentations);
            } else {
                System.out.println("Unknown option '" + argument + "'");
            }
            ++indexArgument;
        }
        if (wIncludeSchemaId && !wIncludeOptions) {
            EXIficientCMD.printWarning("-includeSchemaId ignored because -includeOptions not set");
        }
        if (wIncludeProfileValues && !wIncludeOptions) {
            EXIficientCMD.printWarning("-includeProfileValues ignored because -includeOptions not set");
        }
        if (this.exiFactory.getFidelityOptions().isStrict()) {
            if (wPreserveComments) {
                EXIficientCMD.printWarning("-preserveComments ignored because -strict is set");
            }
            if (wPreservePIs) {
                EXIficientCMD.printWarning("-preservePIs ignored because -strict is set");
            }
            if (wPreserveDTD) {
                EXIficientCMD.printWarning("-preserveDTDs ignored because -strict is set");
            }
            if (wPreservePrefixes) {
                EXIficientCMD.printWarning("-preservePrefixes ignored because -strict is set");
            }
        } else if (wStrict) {
            EXIficientCMD.printWarning("-strict ignored because a preserveOption is set");
        }
        this.inputParametersOK = true;
        if (this.cmdOption == null) {
            this.inputParametersOK = false;
            EXIficientCMD.printError("Missing coding option such as " + ENCODE + " and " + DECODE);
        }
        if (this.input == null) {
            this.inputParametersOK = false;
            EXIficientCMD.printError("Missing option -i");
        } else if (!new File(this.input).exists()) {
            this.inputParametersOK = false;
            EXIficientCMD.printError("Not existing input parameter -i, \"" + this.input + "\"");
        }
        if (this.input != null && this.output == null) {
            this.output = CmdOption.encode == this.cmdOption ? String.valueOf(this.input) + DEFAULT_EXI_FILE_EXTENSION : String.valueOf(this.input) + DEFAULT_XML_FILE_EXTENSION;
        }
        File fOutput = null;
        if (this.output == null) {
            this.inputParametersOK = false;
            EXIficientCMD.printError("Missing output specification!");
        } else {
            fOutput = new File(this.output);
            if (fOutput.isDirectory()) {
                this.inputParametersOK = false;
                EXIficientCMD.printError("Outputfile '" + this.output + "' is unexpectedly a directory");
            } else if (fOutput.exists()) {
                if (!fOutput.delete()) {
                    this.inputParametersOK = false;
                    EXIficientCMD.printError("Existing outputfile '" + this.output + "' could not be deleted.");
                }
            } else {
                assert (!fOutput.exists());
                File parentDir = fOutput.getParentFile();
                if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
                    this.inputParametersOK = false;
                    EXIficientCMD.printError("Output directories for file '" + this.output + "' could not be created.");
                }
            }
        }
        if (this.inputParametersOK && SchemaOption.noSchema != schemaOption) {
            if (SchemaOption.xsdSchema == schemaOption) {
                Grammars selectedGrammar = null;
                switch (builtInSchemaOption) {
                    case External: {
                        GrammarFactory gf = GrammarFactory.newInstance();
                        selectedGrammar = gf.createXSDTypesOnlyGrammars();
                        break;
                    }
                    case AppProtocol: {
                        selectedGrammar = new CommonAppProtocol();
                        break;
                    }
                    case ISO15118_2: {
                        selectedGrammar = new ISO15118_2Grammar();
                        break;
                    }
                    case ISO15118_20_V2G_CI_CommonMessages: {
                        selectedGrammar = new ISO15118_20_V2G_CI_CommonMessages();
                        break;
                    }
                    case XSDCore: {
                        selectedGrammar = new XMLDSIG_Core_Schema_Grammar();
                        break;
                    }
                    case Notebook: {
                        selectedGrammar = new W3NotebookGrammar();
                        break;
                    }
                    case ISO15118_20_V2G_CI_AC: {
                        selectedGrammar = new ISO15118_20_V2G_CI_AC();
                        break;
                    }
                    case ISO15118_20_V2G_CI_ACDP: {
                        selectedGrammar = new ISO15118_20_V2G_CI_ACDP();
                        break;
                    }
                    case ISO15118_20_V2G_CI_DC: {
                        selectedGrammar = new ISO15118_20_V2G_CI_DC();
                        break;
                    }
                    case ISO15118_20_V2G_CI_WPT: {
                        selectedGrammar = new ISO15118_20_V2G_CI_WPT();
                        break;
                    }
                }
                this.exiFactory.setGrammars(selectedGrammar);
                this.exiFactory.setValuePartitionCapacity(0);
                this.exiFactory.setMaximumNumberOfBuiltInElementGrammars(0);
                this.exiFactory.setMaximumNumberOfBuiltInProductions(0);
            } else {
                GrammarFactory gf = GrammarFactory.newInstance();
                this.exiFactory.setGrammars(gf.createGrammars(schemaLocation));
            }
        }
    }

    protected void process() throws EXIException, TransformerException, IOException, SAXException {
        if (this.inputParametersOK) {
            switch (this.cmdOption) {
                case decode: {
                    this.decode(this.input, this.exiFactory, this.output);
                    break;
                }
                case encode: {
                    this.encode(this.input, this.exiFactory, this.output);
                    break;
                }
                default: {
                    EXIficientCMD.printError("Unexptected command option " + (Object)((Object)this.cmdOption));
                    break;
                }
            }
        } else {
            EXIficientCMD.printError("Input parameters were incorrect");
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            EXIficientCMD.printHelp();
        } else {
            EXIficientCMD cmd = new EXIficientCMD();
            try {
                cmd.parseArguments(args);
                cmd.process();
                System.out.println("Done.");
            }
            catch (Exception e) {
                EXIficientCMD.printError(String.valueOf(e.getLocalizedMessage()) + e.getClass());
            }
        }
    }

    protected void decode(String input, EXIFactory exiFactory, String output) throws EXIException, TransformerException, IOException {
        FileOutputStream xmlOutput = new FileOutputStream(output);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        SAXSource exiSource = new SAXSource(new InputSource(new FileInputStream(input)));
        exiSource.setXMLReader(new SAXFactory(exiFactory).createEXIReader());
        if (exiFactory.isFragment()) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.transform(exiSource, new StreamResult(xmlOutput));
        xmlOutput.flush();
        ((OutputStream)xmlOutput).close();
    }

    protected XMLReader getXMLReader() throws SAXException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        xmlReader.setFeature("http://xml.org/sax/features/validation", false);
        xmlReader.setFeature("http://xml.org/sax/features/resolve-dtd-uris", false);
        xmlReader.setEntityResolver(new NoEntityResolver());
        return xmlReader;
    }

    protected void encode(String input, EXIFactory exiFactory, String output) throws SAXException, EXIException, IOException {
        InputSource is;
        FileOutputStream os = new FileOutputStream(output);
        XMLReader xmlReader = this.getXMLReader();
        EXIResult exiResult = new EXIResult(exiFactory);
        exiResult.setOutputStream(os);
        xmlReader.setContentHandler(exiResult.getHandler());
        xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", exiResult.getLexicalHandler());
        xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", exiResult.getLexicalHandler());
        xmlReader.setDTDHandler((DTDHandler)((Object)exiResult.getHandler()));
        if (exiFactory.isFragment()) {
            is = new InputSource(FragmentUtilities.getSurroundingRootInputStream(new FileInputStream(input)));
            xmlReader = new SkipRootElementXMLReader(xmlReader);
        } else {
            is = new InputSource(input);
        }
        xmlReader.parse(is);
        os.flush();
        ((OutputStream)os).close();
    }
}

