import { Construct, Duration } from '@aws-cdk/core';
export interface TimeToLiveProps {
    /**
     * Specifies the Time to Live (TTL) settings for the stack.
     */
    readonly ttl: Duration;
}
export declare class TimeToLive extends Construct {
    constructor(scope: Construct, id: string, props: TimeToLiveProps);
    /**
     * Perform final modifications before synthesis.
     *
     * This method can be implemented by derived constructs in order to perform
     * final changes before synthesis. prepare() will be called after child
     * constructs have been prepared.
     *
     * This is an advanced framework feature. Only use this if you
     * understand the implications.
     */
    protected onPrepare(): void;
    /**
     * Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    protected validate(): string[];
}
