# -*- coding: utf-8 -*-
"""
Interpies - a libray for the interpretation of gravity and magnetic data.

colors.py:
    Definition of colormaps: 
    ## clra_128 and clrb_128 from Geosoft
        See http://www.geosoft.com/media/uploads/resources/technical-notes/colourtables.pdf
    ## parula from Matlab.
    ## win256: Windows color palette for the quantization of RGB pictures
        Originally recovered from: https://eisbox.net/blog/2011/12/16/windows-8-bit-256-color-palette/

@author: Joseph Barraud
Geophysics Labs, 2017
"""

from matplotlib.colors import LinearSegmentedColormap

parula_data = [[0.2081, 0.1663, 0.5292], [0.2116238095, 0.1897809524, 0.5776761905], 
 [0.212252381, 0.2137714286, 0.6269714286], [0.2081, 0.2386, 0.6770857143], 
 [0.1959047619, 0.2644571429, 0.7279], [0.1707285714, 0.2919380952, 
  0.779247619], [0.1252714286, 0.3242428571, 0.8302714286], 
 [0.0591333333, 0.3598333333, 0.8683333333], [0.0116952381, 0.3875095238, 
  0.8819571429], [0.0059571429, 0.4086142857, 0.8828428571], 
 [0.0165142857, 0.4266, 0.8786333333], [0.032852381, 0.4430428571, 
  0.8719571429], [0.0498142857, 0.4585714286, 0.8640571429], 
 [0.0629333333, 0.4736904762, 0.8554380952], [0.0722666667, 0.4886666667, 
  0.8467], [0.0779428571, 0.5039857143, 0.8383714286], 
 [0.079347619, 0.5200238095, 0.8311809524], [0.0749428571, 0.5375428571, 
  0.8262714286], [0.0640571429, 0.5569857143, 0.8239571429], 
 [0.0487714286, 0.5772238095, 0.8228285714], [0.0343428571, 0.5965809524, 
  0.819852381], [0.0265, 0.6137, 0.8135], [0.0238904762, 0.6286619048, 
  0.8037619048], [0.0230904762, 0.6417857143, 0.7912666667], 
 [0.0227714286, 0.6534857143, 0.7767571429], [0.0266619048, 0.6641952381, 
  0.7607190476], [0.0383714286, 0.6742714286, 0.743552381], 
 [0.0589714286, 0.6837571429, 0.7253857143], 
 [0.0843, 0.6928333333, 0.7061666667], [0.1132952381, 0.7015, 0.6858571429], 
 [0.1452714286, 0.7097571429, 0.6646285714], [0.1801333333, 0.7176571429, 
  0.6424333333], [0.2178285714, 0.7250428571, 0.6192619048], 
 [0.2586428571, 0.7317142857, 0.5954285714], [0.3021714286, 0.7376047619, 
  0.5711857143], [0.3481666667, 0.7424333333, 0.5472666667], 
 [0.3952571429, 0.7459, 0.5244428571], [0.4420095238, 0.7480809524, 
  0.5033142857], [0.4871238095, 0.7490619048, 0.4839761905], 
 [0.5300285714, 0.7491142857, 0.4661142857], [0.5708571429, 0.7485190476, 
  0.4493904762], [0.609852381, 0.7473142857, 0.4336857143], 
 [0.6473, 0.7456, 0.4188], [0.6834190476, 0.7434761905, 0.4044333333], 
 [0.7184095238, 0.7411333333, 0.3904761905], 
 [0.7524857143, 0.7384, 0.3768142857], [0.7858428571, 0.7355666667, 
  0.3632714286], [0.8185047619, 0.7327333333, 0.3497904762], 
 [0.8506571429, 0.7299, 0.3360285714], [0.8824333333, 0.7274333333, 0.3217], 
 [0.9139333333, 0.7257857143, 0.3062761905], [0.9449571429, 0.7261142857, 
  0.2886428571], [0.9738952381, 0.7313952381, 0.266647619], 
 [0.9937714286, 0.7454571429, 0.240347619], [0.9990428571, 0.7653142857, 
  0.2164142857], [0.9955333333, 0.7860571429, 0.196652381], 
 [0.988, 0.8066, 0.1793666667], [0.9788571429, 0.8271428571, 0.1633142857], 
 [0.9697, 0.8481380952, 0.147452381], [0.9625857143, 0.8705142857, 0.1309], 
 [0.9588714286, 0.8949, 0.1132428571], [0.9598238095, 0.9218333333, 
  0.0948380952], [0.9661, 0.9514428571, 0.0755333333], 
 [0.9763, 0.9831, 0.0538]]

# geosoft colormap A
clra32_data = [[ 0.        ,  0.        ,  1.        ],
               [ 0.        ,  0.33333333,  1.        ],
               [ 0.        ,  0.55294118,  1.        ],
               [ 0.        ,  0.78039216,  1.        ],
               [ 0.        ,  0.91372549,  1.        ],
               [ 0.        ,  1.        ,  1.        ],
               [ 0.        ,  1.        ,  0.63921569],
               [ 0.        ,  1.        ,  0.24705882],
               [ 0.        ,  1.        ,  0.17647059],
               [ 0.        ,  1.        ,  0.04705882],
               [ 0.28235294,  1.        ,  0.        ],
               [ 0.4       ,  1.        ,  0.        ],
               [ 0.52941176,  1.        ,  0.        ],
               [ 0.71372549,  1.        ,  0.        ],
               [ 0.90588235,  1.        ,  0.        ],
               [ 1.        ,  0.95686275,  0.        ],
               [ 1.        ,  0.82745098,  0.        ],
               [ 1.        ,  0.7372549 ,  0.        ],
               [ 1.        ,  0.68235294,  0.        ],
               [ 1.        ,  0.57647059,  0.        ],
               [ 1.        ,  0.5254902 ,  0.        ],
               [ 1.        ,  0.44313725,  0.        ],
               [ 1.        ,  0.33333333,  0.        ],
               [ 1.        ,  0.16470588,  0.        ],
               [ 1.        ,  0.02745098,  0.        ],
               [ 1.        ,  0.        ,  0.06666667],
               [ 1.        ,  0.        ,  0.20392157],
               [ 1.        ,  0.03529412,  0.45490196],
               [ 1.        ,  0.18823529,  0.70588235],
               [ 1.        ,  0.34901961,  0.94509804],
               [ 1.        ,  0.50588235,  1.        ],
               [ 1.        ,  0.6627451 ,  1.        ]]
       
clra128_data= [[ 0.        ,  0.        ,  1.        ],
               [ 0.        ,  0.05882353,  1.        ],
               [ 0.        ,  0.10980392,  1.        ],
               [ 0.        ,  0.21960784,  1.        ],
               [ 0.        ,  0.33333333,  1.        ],
               [ 0.        ,  0.39215686,  1.        ],
               [ 0.        ,  0.44705882,  1.        ],
               [ 0.        ,  0.49803922,  1.        ],
               [ 0.        ,  0.55294118,  1.        ],
               [ 0.        ,  0.60784314,  1.        ],
               [ 0.        ,  0.66666667,  1.        ],
               [ 0.        ,  0.7254902 ,  1.        ],
               [ 0.        ,  0.78039216,  1.        ],
               [ 0.        ,  0.82745098,  1.        ],
               [ 0.        ,  0.85882353,  1.        ],
               [ 0.        ,  0.88627451,  1.        ],
               [ 0.        ,  0.91372549,  1.        ],
               [ 0.        ,  0.94509804,  1.        ],
               [ 0.        ,  0.97254902,  1.        ],
               [ 0.        ,  0.98823529,  1.        ],
               [ 0.        ,  1.        ,  1.        ],
               [ 0.        ,  1.        ,  0.8627451 ],
               [ 0.        ,  1.        ,  0.78431373],
               [ 0.        ,  1.        ,  0.71372549],
               [ 0.        ,  1.        ,  0.63921569],
               [ 0.        ,  1.        ,  0.56862745],
               [ 0.        ,  1.        ,  0.4627451 ],
               [ 0.        ,  1.        ,  0.34901961],
               [ 0.        ,  1.        ,  0.24705882],
               [ 0.        ,  1.        ,  0.22745098],
               [ 0.        ,  1.        ,  0.21176471],
               [ 0.        ,  1.        ,  0.18823529],
               [ 0.        ,  1.        ,  0.17647059],
               [ 0.        ,  1.        ,  0.15686275],
               [ 0.        ,  1.        ,  0.14117647],
               [ 0.        ,  1.        ,  0.09411765],
               [ 0.        ,  1.        ,  0.04705882],
               [ 0.        ,  1.        ,  0.        ],
               [ 0.09411765,  1.        ,  0.        ],
               [ 0.18823529,  1.        ,  0.        ],
               [ 0.28235294,  1.        ,  0.        ],
               [ 0.31764706,  1.        ,  0.        ],
               [ 0.34901961,  1.        ,  0.        ],
               [ 0.38431373,  1.        ,  0.        ],
               [ 0.4       ,  1.        ,  0.        ],
               [ 0.41176471,  1.        ,  0.        ],
               [ 0.44705882,  1.        ,  0.        ],
               [ 0.49019608,  1.        ,  0.        ],
               [ 0.52941176,  1.        ,  0.        ],
               [ 0.56862745,  1.        ,  0.        ],
               [ 0.61568627,  1.        ,  0.        ],
               [ 0.6627451 ,  1.        ,  0.        ],
               [ 0.71372549,  1.        ,  0.        ],
               [ 0.76078431,  1.        ,  0.        ],
               [ 0.80784314,  1.        ,  0.        ],
               [ 0.85490196,  1.        ,  0.        ],
               [ 0.90588235,  1.        ,  0.        ],
               [ 0.95294118,  1.        ,  0.        ],
               [ 0.97647059,  1.        ,  0.        ],
               [ 1.        ,  1.        ,  0.        ],
               [ 1.        ,  0.95686275,  0.        ],
               [ 1.        ,  0.91372549,  0.        ],
               [ 1.        ,  0.88627451,  0.        ],
               [ 1.        ,  0.85882353,  0.        ],
               [ 1.        ,  0.82745098,  0.        ],
               [ 1.        ,  0.80392157,  0.        ],
               [ 1.        ,  0.77647059,  0.        ],
               [ 1.        ,  0.75294118,  0.        ],
               [ 1.        ,  0.7372549 ,  0.        ],
               [ 1.        ,  0.72156863,  0.        ],
               [ 1.        ,  0.70196078,  0.        ],
               [ 1.        ,  0.69411765,  0.        ],
               [ 1.        ,  0.68235294,  0.        ],
               [ 1.        ,  0.66666667,  0.        ],
               [ 1.        ,  0.63921569,  0.        ],
               [ 1.        ,  0.61176471,  0.        ],
               [ 1.        ,  0.57647059,  0.        ],
               [ 1.        ,  0.56862745,  0.        ],
               [ 1.        ,  0.55294118,  0.        ],
               [ 1.        ,  0.5372549 ,  0.        ],
               [ 1.        ,  0.5254902 ,  0.        ],
               [ 1.        ,  0.51372549,  0.        ],
               [ 1.        ,  0.49803922,  0.        ],
               [ 1.        ,  0.47058824,  0.        ],
               [ 1.        ,  0.44313725,  0.        ],
               [ 1.        ,  0.41176471,  0.        ],
               [ 1.        ,  0.38431373,  0.        ],
               [ 1.        ,  0.36078431,  0.        ],
               [ 1.        ,  0.33333333,  0.        ],
               [ 1.        ,  0.29019608,  0.        ],
               [ 1.        ,  0.25098039,  0.        ],
               [ 1.        ,  0.20784314,  0.        ],
               [ 1.        ,  0.16470588,  0.        ],
               [ 1.        ,  0.1254902 ,  0.        ],
               [ 1.        ,  0.08235294,  0.        ],
               [ 1.        ,  0.05490196,  0.        ],
               [ 1.        ,  0.02745098,  0.        ],
               [ 1.        ,  0.        ,  0.        ],
               [ 1.        ,  0.        ,  0.02352941],
               [ 1.        ,  0.        ,  0.05098039],
               [ 1.        ,  0.        ,  0.06666667],
               [ 1.        ,  0.        ,  0.09411765],
               [ 1.        ,  0.        ,  0.11764706],
               [ 1.        ,  0.        ,  0.14117647],
               [ 1.        ,  0.        ,  0.20392157],
               [ 1.        ,  0.        ,  0.26666667],
               [ 1.        ,  0.        ,  0.32941176],
               [ 1.        ,  0.        ,  0.39215686],
               [ 1.        ,  0.03529412,  0.45490196],
               [ 1.        ,  0.07058824,  0.51372549],
               [ 1.        ,  0.11372549,  0.58039216],
               [ 1.        ,  0.15294118,  0.64313725],
               [ 1.        ,  0.18823529,  0.70588235],
               [ 1.        ,  0.22745098,  0.77254902],
               [ 1.        ,  0.27058824,  0.83529412],
               [ 1.        ,  0.30980392,  0.89019608],
               [ 1.        ,  0.34901961,  0.94509804],
               [ 1.        ,  0.38431373,  1.        ],
               [ 1.        ,  0.42745098,  1.        ],
               [ 1.        ,  0.46666667,  1.        ],
               [ 1.        ,  0.50588235,  1.        ],
               [ 1.        ,  0.54509804,  1.        ],
               [ 1.        ,  0.58039216,  1.        ],
               [ 1.        ,  0.62352941,  1.        ],
               [ 1.        ,  0.6627451 ,  1.        ],
               [ 1.        ,  0.70196078,  1.        ],
               [ 1.        ,  0.74117647,  1.        ],
               [ 1.        ,  0.76078431,  1.        ]]
  
# geosoft colormap B
clrb128_data= [[ 0.        ,  0.49803922,  1.        ],
               [ 0.        ,  0.51764706,  1.        ],
               [ 0.        ,  0.54509804,  1.        ],
               [ 0.        ,  0.56862745,  1.        ],
               [ 0.        ,  0.59215686,  1.        ],
               [ 0.        ,  0.61568627,  1.        ],
               [ 0.        ,  0.63921569,  1.        ],
               [ 0.        ,  0.6627451 ,  1.        ],
               [ 0.        ,  0.68627451,  1.        ],
               [ 0.        ,  0.70588235,  1.        ],
               [ 0.        ,  0.73333333,  1.        ],
               [ 0.        ,  0.75686275,  1.        ],
               [ 0.        ,  0.78039216,  1.        ],
               [ 0.        ,  0.80392157,  1.        ],
               [ 0.        ,  0.82745098,  1.        ],
               [ 0.        ,  0.85098039,  1.        ],
               [ 0.        ,  0.8745098 ,  1.        ],
               [ 0.        ,  0.90588235,  1.        ],
               [ 0.        ,  0.9372549 ,  1.        ],
               [ 0.        ,  0.96862745,  1.        ],
               [ 0.        ,  1.        ,  1.        ],
               [ 0.        ,  1.        ,  0.9372549 ],
               [ 0.        ,  1.        ,  0.8745098 ],
               [ 0.        ,  1.        ,  0.81176471],
               [ 0.        ,  1.        ,  0.74901961],
               [ 0.        ,  1.        ,  0.68627451],
               [ 0.        ,  1.        ,  0.62352941],
               [ 0.        ,  1.        ,  0.49803922],
               [ 0.        ,  1.        ,  0.37254902],
               [ 0.        ,  1.        ,  0.24705882],
               [ 0.        ,  1.        ,  0.12156863],
               [ 0.        ,  1.        ,  0.        ],
               [ 0.03529412,  1.        ,  0.        ],
               [ 0.07843137,  1.        ,  0.        ],
               [ 0.11764706,  1.        ,  0.        ],
               [ 0.15686275,  1.        ,  0.        ],
               [ 0.19215686,  1.        ,  0.        ],
               [ 0.23529412,  1.        ,  0.        ],
               [ 0.2745098 ,  1.        ,  0.        ],
               [ 0.31372549,  1.        ,  0.        ],
               [ 0.34901961,  1.        ,  0.        ],
               [ 0.39215686,  1.        ,  0.        ],
               [ 0.43137255,  1.        ,  0.        ],
               [ 0.47058824,  1.        ,  0.        ],
               [ 0.50980392,  1.        ,  0.        ],
               [ 0.54901961,  1.        ,  0.        ],
               [ 0.58823529,  1.        ,  0.        ],
               [ 0.62745098,  1.        ,  0.        ],
               [ 0.66666667,  1.        ,  0.        ],
               [ 0.70196078,  1.        ,  0.        ],
               [ 0.74509804,  1.        ,  0.        ],
               [ 0.78431373,  1.        ,  0.        ],
               [ 0.82352941,  1.        ,  0.        ],
               [ 0.8627451 ,  1.        ,  0.        ],
               [ 0.90196078,  1.        ,  0.        ],
               [ 0.94117647,  1.        ,  0.        ],
               [ 0.98039216,  1.        ,  0.        ],
               [ 1.        ,  1.        ,  0.        ],
               [ 1.        ,  0.96862745,  0.        ],
               [ 1.        ,  0.93333333,  0.        ],
               [ 1.        ,  0.90196078,  0.        ],
               [ 1.        ,  0.86666667,  0.        ],
               [ 1.        ,  0.82745098,  0.        ],
               [ 1.        ,  0.8       ,  0.        ],
               [ 1.        ,  0.76470588,  0.        ],
               [ 1.        ,  0.73333333,  0.        ],
               [ 1.        ,  0.69803922,  0.        ],
               [ 1.        ,  0.66666667,  0.        ],
               [ 1.        ,  0.63137255,  0.        ],
               [ 1.        ,  0.59215686,  0.        ],
               [ 1.        ,  0.55686275,  0.        ],
               [ 1.        ,  0.5254902 ,  0.        ],
               [ 1.        ,  0.49019608,  0.        ],
               [ 1.        ,  0.45882353,  0.        ],
               [ 1.        ,  0.42352941,  0.        ],
               [ 1.        ,  0.39215686,  0.        ],
               [ 1.        ,  0.35294118,  0.        ],
               [ 1.        ,  0.32156863,  0.        ],
               [ 1.        ,  0.28627451,  0.        ],
               [ 1.        ,  0.25490196,  0.        ],
               [ 1.        ,  0.21960784,  0.        ],
               [ 1.        ,  0.18823529,  0.        ],
               [ 1.        ,  0.15686275,  0.        ],
               [ 1.        ,  0.1254902 ,  0.        ],
               [ 1.        ,  0.09019608,  0.        ],
               [ 1.        ,  0.05882353,  0.        ],
               [ 1.        ,  0.02745098,  0.        ],
               [ 1.        ,  0.        ,  0.        ],
               [ 1.        ,  0.        ,  0.29019608],
               [ 1.        ,  0.        ,  0.50980392],
               [ 1.        ,  0.        ,  0.66666667],
               [ 1.        ,  0.        ,  0.76470588],
               [ 1.        ,  0.        ,  0.82745098],
               [ 1.        ,  0.        ,  0.88235294],
               [ 1.        ,  0.        ,  0.91372549],
               [ 1.        ,  0.        ,  0.94117647],
               [ 1.        ,  0.        ,  0.96078431],
               [ 1.        ,  0.        ,  0.97254902],
               [ 1.        ,  0.        ,  1.        ],
               [ 0.98039216,  0.        ,  1.        ],
               [ 0.96078431,  0.        ,  1.        ],
               [ 0.94117647,  0.        ,  1.        ],
               [ 0.92156863,  0.        ,  1.        ],
               [ 0.90196078,  0.        ,  1.        ],
               [ 0.88235294,  0.01960784,  1.        ],
               [ 0.8745098 ,  0.05882353,  1.        ],
               [ 0.8627451 ,  0.09411765,  1.        ],
               [ 0.85490196,  0.13333333,  1.        ],
               [ 0.84313725,  0.17647059,  1.        ],
               [ 0.83529412,  0.21568627,  1.        ],
               [ 0.82352941,  0.25490196,  1.        ],
               [ 0.83529412,  0.29019608,  1.        ],
               [ 0.84313725,  0.33333333,  1.        ],
               [ 0.85490196,  0.37254902,  1.        ],
               [ 0.8627451 ,  0.41176471,  1.        ],
               [ 0.8745098 ,  0.44705882,  1.        ],
               [ 0.88235294,  0.49019608,  1.        ],
               [ 0.89411765,  0.52941176,  1.        ],
               [ 0.90196078,  0.56862745,  1.        ],
               [ 0.91372549,  0.60784314,  1.        ],
               [ 0.92156863,  0.64313725,  1.        ],
               [ 0.93333333,  0.68627451,  1.        ],
               [ 0.94117647,  0.7254902 ,  1.        ],
               [ 0.95294118,  0.76470588,  1.        ],
               [ 0.96078431,  0.80392157,  1.        ],
               [ 0.97254902,  0.84313725,  1.        ],
               [ 0.98039216,  0.88235294,  1.        ],
               [ 0.99215686,  0.92156863,  1.        ]]

# win256
win256_data = [[ 0.        ,  0.        ,  0.        ],
               [ 0.50196078,  0.        ,  0.        ],
               [ 0.        ,  0.50196078,  0.        ],
               [ 0.50196078,  0.50196078,  0.        ],
               [ 0.        ,  0.        ,  0.50196078],
               [ 0.50196078,  0.        ,  0.50196078],
               [ 0.        ,  0.50196078,  0.50196078],
               [ 0.75294118,  0.75294118,  0.75294118],
               [ 0.75294118,  0.8627451 ,  0.75294118],
               [ 0.65098039,  0.79215686,  0.94117647],
               [ 0.16470588,  0.24705882,  0.66666667],
               [ 0.16470588,  0.24705882,  1.        ],
               [ 0.16470588,  0.37254902,  0.        ],
               [ 0.16470588,  0.37254902,  0.33333333],
               [ 0.16470588,  0.37254902,  0.66666667],
               [ 0.16470588,  0.37254902,  1.        ],
               [ 0.16470588,  0.49803922,  0.        ],
               [ 0.16470588,  0.49803922,  0.33333333],
               [ 0.16470588,  0.49803922,  0.66666667],
               [ 0.16470588,  0.49803922,  1.        ],
               [ 0.16470588,  0.62352941,  0.        ],
               [ 0.16470588,  0.62352941,  0.33333333],
               [ 0.16470588,  0.62352941,  0.66666667],
               [ 0.16470588,  0.62352941,  1.        ],
               [ 0.16470588,  0.74901961,  0.        ],
               [ 0.16470588,  0.74901961,  0.33333333],
               [ 0.16470588,  0.74901961,  0.66666667],
               [ 0.16470588,  0.74901961,  1.        ],
               [ 0.16470588,  0.8745098 ,  0.        ],
               [ 0.16470588,  0.8745098 ,  0.33333333],
               [ 0.16470588,  0.8745098 ,  0.66666667],
               [ 0.16470588,  0.8745098 ,  1.        ],
               [ 0.16470588,  1.        ,  0.        ],
               [ 0.16470588,  1.        ,  0.33333333],
               [ 0.16470588,  1.        ,  0.66666667],
               [ 0.16470588,  1.        ,  1.        ],
               [ 0.33333333,  0.        ,  0.        ],
               [ 0.33333333,  0.        ,  0.33333333],
               [ 0.33333333,  0.        ,  0.66666667],
               [ 0.33333333,  0.        ,  1.        ],
               [ 0.33333333,  0.12156863,  0.        ],
               [ 0.33333333,  0.12156863,  0.33333333],
               [ 0.33333333,  0.12156863,  0.66666667],
               [ 0.33333333,  0.12156863,  1.        ],
               [ 0.33333333,  0.24705882,  0.        ],
               [ 0.33333333,  0.24705882,  0.33333333],
               [ 0.33333333,  0.24705882,  0.66666667],
               [ 0.33333333,  0.24705882,  1.        ],
               [ 0.33333333,  0.37254902,  0.        ],
               [ 0.33333333,  0.37254902,  0.33333333],
               [ 0.33333333,  0.37254902,  0.66666667],
               [ 0.33333333,  0.37254902,  1.        ],
               [ 0.33333333,  0.49803922,  0.        ],
               [ 0.33333333,  0.49803922,  0.33333333],
               [ 0.33333333,  0.49803922,  0.66666667],
               [ 0.33333333,  0.49803922,  1.        ],
               [ 0.33333333,  0.62352941,  0.        ],
               [ 0.33333333,  0.62352941,  0.33333333],
               [ 0.33333333,  0.62352941,  0.66666667],
               [ 0.33333333,  0.62352941,  1.        ],
               [ 0.33333333,  0.74901961,  0.        ],
               [ 0.33333333,  0.74901961,  0.33333333],
               [ 0.33333333,  0.74901961,  0.66666667],
               [ 0.33333333,  0.74901961,  1.        ],
               [ 0.33333333,  0.8745098 ,  0.        ],
               [ 0.33333333,  0.8745098 ,  0.33333333],
               [ 0.33333333,  0.8745098 ,  0.66666667],
               [ 0.33333333,  0.8745098 ,  1.        ],
               [ 0.33333333,  1.        ,  0.        ],
               [ 0.33333333,  1.        ,  0.33333333],
               [ 0.33333333,  1.        ,  0.66666667],
               [ 0.33333333,  1.        ,  1.        ],
               [ 0.49803922,  0.        ,  0.        ],
               [ 0.49803922,  0.        ,  0.33333333],
               [ 0.49803922,  0.        ,  0.66666667],
               [ 0.49803922,  0.        ,  1.        ],
               [ 0.49803922,  0.12156863,  0.        ],
               [ 0.49803922,  0.12156863,  0.33333333],
               [ 0.49803922,  0.12156863,  0.66666667],
               [ 0.49803922,  0.12156863,  1.        ],
               [ 0.49803922,  0.24705882,  0.        ],
               [ 0.49803922,  0.24705882,  0.33333333],
               [ 0.49803922,  0.24705882,  0.66666667],
               [ 0.49803922,  0.24705882,  1.        ],
               [ 0.49803922,  0.37254902,  0.        ],
               [ 0.49803922,  0.37254902,  0.33333333],
               [ 0.49803922,  0.37254902,  0.66666667],
               [ 0.49803922,  0.37254902,  1.        ],
               [ 0.49803922,  0.49803922,  0.        ],
               [ 0.49803922,  0.49803922,  0.33333333],
               [ 0.49803922,  0.49803922,  0.66666667],
               [ 0.49803922,  0.49803922,  1.        ],
               [ 0.49803922,  0.62352941,  0.        ],
               [ 0.49803922,  0.62352941,  0.33333333],
               [ 0.49803922,  0.62352941,  0.66666667],
               [ 0.49803922,  0.62352941,  1.        ],
               [ 0.49803922,  0.74901961,  0.        ],
               [ 0.49803922,  0.74901961,  0.33333333],
               [ 0.49803922,  0.74901961,  0.66666667],
               [ 0.49803922,  0.74901961,  1.        ],
               [ 0.49803922,  0.8745098 ,  0.        ],
               [ 0.49803922,  0.8745098 ,  0.33333333],
               [ 0.49803922,  0.8745098 ,  0.66666667],
               [ 0.49803922,  0.8745098 ,  1.        ],
               [ 0.49803922,  1.        ,  0.        ],
               [ 0.49803922,  1.        ,  0.33333333],
               [ 0.49803922,  1.        ,  0.66666667],
               [ 0.49803922,  1.        ,  1.        ],
               [ 0.66666667,  0.        ,  0.        ],
               [ 0.66666667,  0.        ,  0.33333333],
               [ 0.66666667,  0.        ,  0.66666667],
               [ 0.66666667,  0.        ,  1.        ],
               [ 0.66666667,  0.12156863,  0.        ],
               [ 0.66666667,  0.12156863,  0.33333333],
               [ 0.66666667,  0.12156863,  0.66666667],
               [ 0.66666667,  0.12156863,  1.        ],
               [ 0.66666667,  0.24705882,  0.        ],
               [ 0.66666667,  0.24705882,  0.33333333],
               [ 0.66666667,  0.24705882,  0.66666667],
               [ 0.66666667,  0.24705882,  1.        ],
               [ 0.66666667,  0.37254902,  0.        ],
               [ 0.66666667,  0.37254902,  0.33333333],
               [ 0.66666667,  0.37254902,  0.66666667],
               [ 0.66666667,  0.37254902,  1.        ],
               [ 0.66666667,  0.49803922,  0.        ],
               [ 0.66666667,  0.49803922,  0.33333333],
               [ 0.66666667,  0.49803922,  0.66666667],
               [ 0.66666667,  0.49803922,  1.        ],
               [ 0.66666667,  0.62352941,  0.        ],
               [ 0.66666667,  0.62352941,  0.33333333],
               [ 0.66666667,  0.62352941,  0.66666667],
               [ 0.66666667,  0.62352941,  1.        ],
               [ 0.66666667,  0.74901961,  0.        ],
               [ 0.66666667,  0.74901961,  0.33333333],
               [ 0.66666667,  0.74901961,  0.66666667],
               [ 0.66666667,  0.74901961,  1.        ],
               [ 0.66666667,  0.8745098 ,  0.        ],
               [ 0.66666667,  0.8745098 ,  0.33333333],
               [ 0.66666667,  0.8745098 ,  0.66666667],
               [ 0.66666667,  0.8745098 ,  1.        ],
               [ 0.66666667,  1.        ,  0.        ],
               [ 0.66666667,  1.        ,  0.33333333],
               [ 0.66666667,  1.        ,  0.66666667],
               [ 0.66666667,  1.        ,  1.        ],
               [ 0.83137255,  0.        ,  0.        ],
               [ 0.83137255,  0.        ,  0.33333333],
               [ 0.83137255,  0.        ,  0.66666667],
               [ 0.83137255,  0.        ,  1.        ],
               [ 0.83137255,  0.12156863,  0.        ],
               [ 0.83137255,  0.12156863,  0.33333333],
               [ 0.83137255,  0.12156863,  0.66666667],
               [ 0.83137255,  0.12156863,  1.        ],
               [ 0.83137255,  0.24705882,  0.        ],
               [ 0.83137255,  0.24705882,  0.33333333],
               [ 0.83137255,  0.24705882,  0.66666667],
               [ 0.83137255,  0.24705882,  1.        ],
               [ 0.83137255,  0.37254902,  0.        ],
               [ 0.83137255,  0.37254902,  0.33333333],
               [ 0.83137255,  0.37254902,  0.66666667],
               [ 0.83137255,  0.37254902,  1.        ],
               [ 0.83137255,  0.49803922,  0.        ],
               [ 0.83137255,  0.49803922,  0.33333333],
               [ 0.83137255,  0.49803922,  0.66666667],
               [ 0.83137255,  0.49803922,  1.        ],
               [ 0.83137255,  0.62352941,  0.        ],
               [ 0.83137255,  0.62352941,  0.33333333],
               [ 0.83137255,  0.62352941,  0.66666667],
               [ 0.83137255,  0.62352941,  1.        ],
               [ 0.83137255,  0.74901961,  0.        ],
               [ 0.83137255,  0.74901961,  0.33333333],
               [ 0.83137255,  0.74901961,  0.66666667],
               [ 0.83137255,  0.74901961,  1.        ],
               [ 0.83137255,  0.8745098 ,  0.        ],
               [ 0.83137255,  0.8745098 ,  0.33333333],
               [ 0.83137255,  0.8745098 ,  0.66666667],
               [ 0.83137255,  0.8745098 ,  1.        ],
               [ 0.83137255,  1.        ,  0.        ],
               [ 0.83137255,  1.        ,  0.33333333],
               [ 0.83137255,  1.        ,  0.66666667],
               [ 0.83137255,  1.        ,  1.        ],
               [ 1.        ,  0.        ,  0.33333333],
               [ 1.        ,  0.        ,  0.66666667],
               [ 1.        ,  0.12156863,  0.        ],
               [ 1.        ,  0.12156863,  0.33333333],
               [ 1.        ,  0.12156863,  0.66666667],
               [ 1.        ,  0.12156863,  1.        ],
               [ 1.        ,  0.24705882,  0.        ],
               [ 1.        ,  0.24705882,  0.33333333],
               [ 1.        ,  0.24705882,  0.66666667],
               [ 1.        ,  0.24705882,  1.        ],
               [ 1.        ,  0.37254902,  0.        ],
               [ 1.        ,  0.37254902,  0.33333333],
               [ 1.        ,  0.37254902,  0.66666667],
               [ 1.        ,  0.37254902,  1.        ],
               [ 1.        ,  0.49803922,  0.        ],
               [ 1.        ,  0.49803922,  0.33333333],
               [ 1.        ,  0.49803922,  0.66666667],
               [ 1.        ,  0.49803922,  1.        ],
               [ 1.        ,  0.62352941,  0.        ],
               [ 1.        ,  0.62352941,  0.33333333],
               [ 1.        ,  0.62352941,  0.66666667],
               [ 1.        ,  0.62352941,  1.        ],
               [ 1.        ,  0.74901961,  0.        ],
               [ 1.        ,  0.74901961,  0.33333333],
               [ 1.        ,  0.74901961,  0.66666667],
               [ 1.        ,  0.74901961,  1.        ],
               [ 1.        ,  0.8745098 ,  0.        ],
               [ 1.        ,  0.8745098 ,  0.33333333],
               [ 1.        ,  0.8745098 ,  0.66666667],
               [ 1.        ,  0.8745098 ,  1.        ],
               [ 1.        ,  1.        ,  0.33333333],
               [ 1.        ,  1.        ,  0.66666667],
               [ 0.8       ,  0.8       ,  1.        ],
               [ 1.        ,  0.8       ,  1.        ],
               [ 0.2       ,  1.        ,  1.        ],
               [ 0.4       ,  1.        ,  1.        ],
               [ 0.6       ,  1.        ,  1.        ],
               [ 0.8       ,  1.        ,  1.        ],
               [ 0.        ,  0.49803922,  0.        ],
               [ 0.        ,  0.49803922,  0.33333333],
               [ 0.        ,  0.49803922,  0.66666667],
               [ 0.        ,  0.49803922,  1.        ],
               [ 0.        ,  0.62352941,  0.        ],
               [ 0.        ,  0.62352941,  0.33333333],
               [ 0.        ,  0.62352941,  0.66666667],
               [ 0.        ,  0.62352941,  1.        ],
               [ 0.        ,  0.74901961,  0.        ],
               [ 0.        ,  0.74901961,  0.33333333],
               [ 0.        ,  0.74901961,  0.66666667],
               [ 0.        ,  0.74901961,  1.        ],
               [ 0.        ,  0.8745098 ,  0.        ],
               [ 0.        ,  0.8745098 ,  0.33333333],
               [ 0.        ,  0.8745098 ,  0.66666667],
               [ 0.        ,  0.8745098 ,  1.        ],
               [ 0.        ,  1.        ,  0.33333333],
               [ 0.        ,  1.        ,  0.66666667],
               [ 0.16470588,  0.        ,  0.        ],
               [ 0.16470588,  0.        ,  0.33333333],
               [ 0.16470588,  0.        ,  0.66666667],
               [ 0.16470588,  0.        ,  1.        ],
               [ 0.16470588,  0.12156863,  0.        ],
               [ 0.16470588,  0.12156863,  0.33333333],
               [ 0.16470588,  0.12156863,  0.66666667],
               [ 0.16470588,  0.12156863,  1.        ],
               [ 0.16470588,  0.24705882,  0.        ],
               [ 0.16470588,  0.24705882,  0.33333333],
               [ 1.        ,  0.98431373,  0.94117647],
               [ 0.62745098,  0.62745098,  0.64313725],
               [ 0.50196078,  0.50196078,  0.50196078],
               [ 1.        ,  0.        ,  0.        ],
               [ 0.        ,  1.        ,  0.        ],
               [ 1.        ,  1.        ,  0.        ],
               [ 0.        ,  0.        ,  1.        ],
               [ 1.        ,  0.        ,  1.        ],
               [ 0.        ,  1.        ,  1.        ],
               [ 1.        ,  1.        ,  1.        ]]

# Win256 palette as a flat list of integers (used to color quantization with pillow)
win256_int = [0,0,0,128,0,0,0,128,0,128,128,0,0,0,128,128,
0,128,0,128,128,192,192,192,192,220,192,166,202,240,42,63,
170,42,63,255,42,95,0,42,95,85,42,95,170,42,95,255,
42,127,0,42,127,85,42,127,170,42,127,255,42,159,0,42,
159,85,42,159,170,42,159,255,42,191,0,42,191,85,42,191,
170,42,191,255,42,223,0,42,223,85,42,223,170,42,223,255,
42,255,0,42,255,85,42,255,170,42,255,255,85,0,0,85,
0,85,85,0,170,85,0,255,85,31,0,85,31,85,85,31,
170,85,31,255,85,63,0,85,63,85,85,63,170,85,63,255,
85,95,0,85,95,85,85,95,170,85,95,255,85,127,0,85,
127,85,85,127,170,85,127,255,85,159,0,85,159,85,85,159,
170,85,159,255,85,191,0,85,191,85,85,191,170,85,191,255,
85,223,0,85,223,85,85,223,170,85,223,255,85,255,0,85,
255,85,85,255,170,85,255,255,127,0,0,127,0,85,127,0,
170,127,0,255,127,31,0,127,31,85,127,31,170,127,31,255,
127,63,0,127,63,85,127,63,170,127,63,255,127,95,0,127,
95,85,127,95,170,127,95,255,127,127,0,127,127,85,127,127,
170,127,127,255,127,159,0,127,159,85,127,159,170,127,159,255,
127,191,0,127,191,85,127,191,170,127,191,255,127,223,0,127,
223,85,127,223,170,127,223,255,127,255,0,127,255,85,127,255,
170,127,255,255,170,0,0,170,0,85,170,0,170,170,0,255,
170,31,0,170,31,85,170,31,170,170,31,255,170,63,0,170,
63,85,170,63,170,170,63,255,170,95,0,170,95,85,170,95,
170,170,95,255,170,127,0,170,127,85,170,127,170,170,127,255,
170,159,0,170,159,85,170,159,170,170,159,255,170,191,0,170,
191,85,170,191,170,170,191,255,170,223,0,170,223,85,170,223,
170,170,223,255,170,255,0,170,255,85,170,255,170,170,255,255,
212,0,0,212,0,85,212,0,170,212,0,255,212,31,0,212,
31,85,212,31,170,212,31,255,212,63,0,212,63,85,212,63,
170,212,63,255,212,95,0,212,95,85,212,95,170,212,95,255,
212,127,0,212,127,85,212,127,170,212,127,255,212,159,0,212,
159,85,212,159,170,212,159,255,212,191,0,212,191,85,212,191,
170,212,191,255,212,223,0,212,223,85,212,223,170,212,223,255,
212,255,0,212,255,85,212,255,170,212,255,255,255,0,85,255,
0,170,255,31,0,255,31,85,255,31,170,255,31,255,255,63,
0,255,63,85,255,63,170,255,63,255,255,95,0,255,95,85,
255,95,170,255,95,255,255,127,0,255,127,85,255,127,170,255,
127,255,255,159,0,255,159,85,255,159,170,255,159,255,255,191,
0,255,191,85,255,191,170,255,191,255,255,223,0,255,223,85,
255,223,170,255,223,255,255,255,85,255,255,170,204,204,255,255,
204,255,51,255,255,102,255,255,153,255,255,204,255,255,0,127,
0,0,127,85,0,127,170,0,127,255,0,159,0,0,159,85,
0,159,170,0,159,255,0,191,0,0,191,85,0,191,170,0,
191,255,0,223,0,0,223,85,0,223,170,0,223,255,0,255,
85,0,255,170,42,0,0,42,0,85,42,0,170,42,0,255,
42,31,0,42,31,85,42,31,170,42,31,255,42,63,0,42,
63,85,255,251,240,160,160,164,128,128,128,255,0,0,0,255,
0,255,255,0,0,0,255,255,0,255,0,255,255,255,255,255]

# cet_rainbow
# This is the rainbow_bgyr_35_85_c73 colormap as listed in the colorcet module,
# which are Python versions of the 256-color colormaps provided in
# http://peterkovesi.com/projects/colourmaps/CETperceptual_csv_0_1.zip

rainbow_bgyr_35_85_c73 = [\
[0, 0.20755, 0.97632],
[0, 0.21857, 0.96476],
[0, 0.2291, 0.95322],
[0, 0.23923, 0.94169],
[0, 0.24899, 0.93018],
[0, 0.25842, 0.91868],
[0, 0.26756, 0.9072],
[0, 0.27649, 0.89573],
[0, 0.28513, 0.88428],
[0, 0.29358, 0.87284],
[0, 0.30184, 0.86141],
[0, 0.30994, 0.85],
[0, 0.31785, 0.83859],
[0, 0.3256, 0.82721],
[0, 0.33324, 0.81583],
[0, 0.34073, 0.80447],
[0, 0.3481, 0.79312],
[0, 0.35537, 0.78178],
[0, 0.3625, 0.77045],
[0, 0.36954, 0.75913],
[0, 0.37649, 0.74783],
[0, 0.38333, 0.73654],
[0, 0.39005, 0.72528],
[0, 0.39667, 0.71405],
[0, 0.40319, 0.70286],
[0, 0.40957, 0.69171],
[0, 0.4158, 0.68063],
[0, 0.42188, 0.66965],
[0, 0.4278, 0.65875],
[0, 0.43352, 0.64799],
[0, 0.43905, 0.63737],
[0, 0.44438, 0.62689],
[0, 0.4495, 0.61659],
[0, 0.45441, 0.60644],
[0, 0.45914, 0.59646],
[0.0019224, 0.46368, 0.58662],
[0.027932, 0.46808, 0.57693],
[0.054843, 0.47236, 0.56735],
[0.076598, 0.47653, 0.55785],
[0.095053, 0.48062, 0.54844],
[0.11106, 0.48465, 0.53907],
[0.12523, 0.48865, 0.52974],
[0.13795, 0.49262, 0.52042],
[0.14935, 0.49658, 0.5111],
[0.15962, 0.50055, 0.50179],
[0.169, 0.50452, 0.49245],
[0.17747, 0.50849, 0.48309],
[0.18517, 0.51246, 0.4737],
[0.19217, 0.51645, 0.46429],
[0.19856, 0.52046, 0.45483],
[0.20443, 0.52448, 0.44531],
[0.20974, 0.52851, 0.43577],
[0.21461, 0.53255, 0.42616],
[0.21905, 0.53661, 0.41651],
[0.22309, 0.54066, 0.40679],
[0.22674, 0.54474, 0.397],
[0.23002, 0.54883, 0.38713],
[0.233, 0.55292, 0.3772],
[0.23568, 0.55703, 0.36716],
[0.23802, 0.56114, 0.35704],
[0.24006, 0.56526, 0.34678],
[0.24185, 0.56939, 0.3364],
[0.24334, 0.57354, 0.32588],
[0.24458, 0.57769, 0.31523],
[0.24556, 0.58185, 0.30439],
[0.2463, 0.58603, 0.29336],
[0.2468, 0.59019, 0.28214],
[0.24707, 0.59438, 0.27067],
[0.24714, 0.59856, 0.25895],
[0.24704, 0.60275, 0.24696],
[0.24679, 0.60693, 0.23472],
[0.24648, 0.61109, 0.22215],
[0.24616, 0.61523, 0.20933],
[0.24597, 0.61936, 0.19628],
[0.24602, 0.62342, 0.18297],
[0.24648, 0.62742, 0.1696],
[0.24753, 0.63135, 0.15615],
[0.24931, 0.63518, 0.14276],
[0.25204, 0.63889, 0.12965],
[0.25579, 0.64249, 0.11693],
[0.2607, 0.64593, 0.10484],
[0.26674, 0.64925, 0.093668],
[0.2739, 0.65241, 0.083583],
[0.28205, 0.65544, 0.074764],
[0.29104, 0.65834, 0.067449],
[0.30071, 0.66112, 0.061598],
[0.31093, 0.66382, 0.057362],
[0.32147, 0.66641, 0.054542],
[0.33226, 0.66895, 0.052918],
[0.34314, 0.67142, 0.052293],
[0.35402, 0.67386, 0.052401],
[0.36487, 0.67627, 0.05303],
[0.37564, 0.67864, 0.054018],
[0.38629, 0.681, 0.055243],
[0.39683, 0.68335, 0.05664],
[0.40725, 0.68569, 0.057955],
[0.41755, 0.68801, 0.059542],
[0.42772, 0.69031, 0.060911],
[0.43777, 0.69262, 0.062454],
[0.4477, 0.69491, 0.063883],
[0.45755, 0.69719, 0.065334],
[0.46731, 0.69947, 0.066802],
[0.47698, 0.70173, 0.068291],
[0.48656, 0.70399, 0.069758],
[0.49607, 0.70625, 0.071211],
[0.50551, 0.70848, 0.072621],
[0.5149, 0.71071, 0.074107],
[0.52421, 0.71293, 0.07551],
[0.53346, 0.71514, 0.076938],
[0.54268, 0.71735, 0.078389],
[0.55183, 0.71954, 0.079862],
[0.56093, 0.72172, 0.08136],
[0.56998, 0.7239, 0.082779],
[0.57901, 0.72607, 0.084273],
[0.58797, 0.72822, 0.08563],
[0.59692, 0.73037, 0.08717],
[0.60581, 0.73251, 0.088583],
[0.61468, 0.73464, 0.09003],
[0.62353, 0.73676, 0.091506],
[0.63233, 0.73887, 0.092872],
[0.6411, 0.74097, 0.094388],
[0.64986, 0.74307, 0.095796],
[0.65858, 0.74515, 0.097234],
[0.66728, 0.74722, 0.098697],
[0.67595, 0.74928, 0.10013],
[0.6846, 0.75135, 0.10157],
[0.69324, 0.75339, 0.10305],
[0.70185, 0.75543, 0.10444],
[0.71045, 0.75746, 0.10594],
[0.71902, 0.75947, 0.10738],
[0.72758, 0.76149, 0.10881],
[0.73613, 0.76349, 0.1103],
[0.74466, 0.76548, 0.11173],
[0.75317, 0.76746, 0.1132],
[0.76167, 0.76943, 0.11457],
[0.77016, 0.7714, 0.11608],
[0.77864, 0.77335, 0.11749],
[0.78711, 0.7753, 0.11897],
[0.79556, 0.77724, 0.12038],
[0.80401, 0.77916, 0.12182],
[0.81244, 0.78108, 0.12327],
[0.82086, 0.78299, 0.12474],
[0.82929, 0.78489, 0.12623],
[0.83769, 0.78678, 0.12766],
[0.84609, 0.78866, 0.1291],
[0.8545, 0.79053, 0.1306],
[0.86289, 0.79238, 0.13203],
[0.87127, 0.7942, 0.13346],
[0.87964, 0.79598, 0.13491],
[0.88799, 0.79771, 0.13626],
[0.8963, 0.79937, 0.13769],
[0.90456, 0.80091, 0.13896],
[0.91273, 0.80229, 0.14021],
[0.92077, 0.80347, 0.14138],
[0.92863, 0.80438, 0.14238],
[0.93625, 0.80495, 0.14322],
[0.94355, 0.80511, 0.14385],
[0.95044, 0.80481, 0.14425],
[0.95686, 0.80399, 0.14437],
[0.96274, 0.80262, 0.14419],
[0.96803, 0.80067, 0.14372],
[0.9727, 0.79816, 0.14294],
[0.97674, 0.79512, 0.14188],
[0.9802, 0.79159, 0.14055],
[0.9831, 0.78764, 0.13895],
[0.98551, 0.78333, 0.13721],
[0.98751, 0.77872, 0.13526],
[0.98917, 0.77389, 0.13319],
[0.99056, 0.76889, 0.13103],
[0.99175, 0.76376, 0.12875],
[0.99279, 0.75855, 0.12647],
[0.99371, 0.75327, 0.1241],
[0.99455, 0.74796, 0.12173],
[0.99534, 0.74261, 0.11937],
[0.99608, 0.73724, 0.11697],
[0.99679, 0.73185, 0.11453],
[0.99748, 0.72646, 0.11217],
[0.99814, 0.72104, 0.10976],
[0.99879, 0.71563, 0.1073],
[0.99942, 0.71019, 0.1048],
[1, 0.70475, 0.10238],
[1, 0.69929, 0.099908],
[1, 0.69382, 0.09745],
[1, 0.68834, 0.095],
[1, 0.68284, 0.092452],
[1, 0.67734, 0.08996],
[1, 0.6718, 0.087465],
[1, 0.66626, 0.08489],
[1, 0.66071, 0.082364],
[1, 0.65514, 0.079729],
[1, 0.64955, 0.077118],
[1, 0.64394, 0.074554],
[1, 0.63832, 0.071927],
[1, 0.63268, 0.069347],
[1, 0.62702, 0.066593],
[1, 0.62135, 0.063895],
[1, 0.61565, 0.061104],
[1, 0.60993, 0.058355],
[1, 0.6042, 0.055584],
[1, 0.59843, 0.052708],
[1, 0.59265, 0.049893],
[1, 0.58684, 0.046988],
[1, 0.58101, 0.043966],
[1, 0.57515, 0.041014],
[1, 0.56926, 0.037943],
[1, 0.56336, 0.034887],
[1, 0.55742, 0.031822],
[1, 0.55145, 0.028972],
[1, 0.54546, 0.026194],
[1, 0.53942, 0.023487],
[1, 0.53336, 0.020851],
[1, 0.52727, 0.018287],
[1, 0.52114, 0.015792],
[1, 0.51497, 0.013362],
[1, 0.50878, 0.010828],
[1, 0.50252, 0.0085264],
[1, 0.49623, 0.0063082],
[1, 0.48991, 0.0041556],
[1, 0.48353, 0.0020694],
[1, 0.47711, 4.915e-05],
[1, 0.47065, 0],
[1, 0.46413, 0],
[1, 0.45754, 0],
[1, 0.45092, 0],
[1, 0.44423, 0],
[1, 0.43748, 0],
[1, 0.43065, 0],
[1, 0.42375, 0],
[1, 0.4168, 0],
[1, 0.40976, 0],
[1, 0.40263, 0],
[1, 0.39544, 0],
[1, 0.38813, 0],
[1, 0.38075, 0],
[1, 0.37324, 0],
[1, 0.36564, 0],
[1, 0.35792, 0],
[1, 0.35006, 0],
[1, 0.34208, 0],
[1, 0.33395, 0],
[1, 0.32564, 0],
[1, 0.31719, 0],
[1, 0.30856, 0],
[1, 0.29971, 0],
[1, 0.29063, 0],
[1, 0.28132, 0],
[1, 0.27173, 0],
[1, 0.26187, 0],
[1, 0.25167, 0],
[1, 0.24106, 0],
[1, 0.23001, 0],
[1, 0.21851, 0],
[1, 0.20642, 0],
[1, 0.19361, 0],
[1, 0.17996, 0],
[1, 0.16528, 0],
]

# dictionary making the correspondence between names and colormap data
datad = {
    'geosoft': clra128_data,
    'clra128': clra128_data,
    'clra32': clra32_data,
    'clrb128': clrb128_data,
    'parula': parula_data,
    'win256': win256_data,
    'cet_rainbow': rainbow_bgyr_35_85_c73
    }
    
### main 
if __name__ == "__main__":
    
    geosoft_cm = LinearSegmentedColormap.from_list('geosoft', clra128_data)
    
