from openfisca_uk.model_api import *


class in_original_frs(Variable):
    label = "In original FRS"
    entity = Household
    documentation = "Whether this household appeared in the original FRS, or whether it has been modified."
    definition_period = YEAR
    value_type = float
    unit = GBP


class uc_migrated(Variable):
    label = "UC migrated"
    documentation = "Whether this household was generated by migrating an original FRS household to Universal Credit."
    entity = Household
    definition_period = YEAR
    value_type = float
    unit = GBP


class spi_imputed(Variable):
    label = "SPI imputed"
    documentation = "Whether this household was generated by replacing income variables with SPI imputations."
    entity = Household
    definition_period = YEAR
    value_type = float
    unit = GBP
