from enum import Enum

VALID_RESOURCES_MAPPING = {
    2048: [1],
    3072: [1],
    4096: [1, 2],
    5120: [1, 2],
    6144: [1, 2],
    7168: [1, 2],
    8192: [1, 2, 4],
    9216: [2, 4],
    10240: [2, 4],
    11264: [2, 4],
    12288: [2, 4],
    13312: [2, 4],
    14336: [2, 4],
    15360: [2, 4],
    16384: [2, 4, 8],
    17408: [4],
    18432: [4],
    19456: [4],
    20480: [4, 8],
    21504: [4],
    22528: [4],
    23552: [4],
    24576: [4, 8],
    25600: [4],
    26624: [4],
    27648: [4],
    28672: [4, 8],
    29696: [4],
    30720: [4],
    32768: [8, 16],
    36864: [8],
    40960: [8, 16],
    45056: [8],
    49152: [8, 16],
    53248: [8],
    57344: [8, 16],
    61440: [8],
    65536: [16],
    73728: [16],
    81920: [16],
    90112: [16],
    98304: [16],
    106496: [16],
    114688: [16],
    122880: [16],
}


class BATCH_JOB_DEFINITION_TYPE(Enum):
    CONTAINER = "container"
    MULTINODE = "multinode"


class BATCH_JOB_PLATFORM_CAPABILITIES(Enum):
    FARGATE = "FARGATE"
    EC2 = "EC2"


class BATCH_JOB_RESOURCE_REQUIREMENT_TYPE(Enum):
    GPU = "GPU"
    VCPU = "VCPU"
    MEMORY = "MEMORY"
