"""
    Contabo API


    The version of the OpenAPI document: 1.0.0
    Contact: support@contabo.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pfruck_contabo.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from pfruck_contabo.exceptions import ApiAttributeError


def lazy_import():
    from pfruck_contabo.model.add_on_response import AddOnResponse
    from pfruck_contabo.model.additional_ip import AdditionalIp
    from pfruck_contabo.model.instance_status import InstanceStatus
    from pfruck_contabo.model.ip_config import IpConfig
    globals()['AddOnResponse'] = AddOnResponse
    globals()['AdditionalIp'] = AdditionalIp
    globals()['InstanceStatus'] = InstanceStatus
    globals()['IpConfig'] = IpConfig


class InstanceResponse(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('tenant_id',): {
            'DE': "DE",
            'INT': "INT",
        },
        ('product_type',): {
            'HDD': "hdd",
            'SSD': "ssd",
            'VDS': "vds",
            'NVME': "nvme",
        },
        ('default_user',): {
            'ROOT': "root",
            'ADMIN': "admin",
            'ADMINISTRATOR': "administrator",
        },
    }

    validations = {
        ('tenant_id',): {
            'min_length': 1,
        },
        ('customer_id',): {
            'min_length': 1,
        },
        ('cancel_date',): {
            'max_length': 10,
            'min_length': 0,
            'regex': {
                'pattern': r'yyyy-mm-dd',  # noqa: E501
            },
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'tenant_id': (str,),  # noqa: E501
            'customer_id': (str,),  # noqa: E501
            'additional_ips': ([AdditionalIp],),  # noqa: E501
            'name': (str,),  # noqa: E501
            'display_name': (str,),  # noqa: E501
            'instance_id': (int,),  # noqa: E501
            'data_center': (str,),  # noqa: E501
            'region': (str,),  # noqa: E501
            'region_name': (str,),  # noqa: E501
            'product_id': (str,),  # noqa: E501
            'image_id': (str,),  # noqa: E501
            'ip_config': (IpConfig,),  # noqa: E501
            'mac_address': (str,),  # noqa: E501
            'ram_mb': (float,),  # noqa: E501
            'cpu_cores': (int,),  # noqa: E501
            'os_type': (str,),  # noqa: E501
            'disk_mb': (float,),  # noqa: E501
            'ssh_keys': ([int],),  # noqa: E501
            'created_date': (datetime,),  # noqa: E501
            'cancel_date': (date,),  # noqa: E501
            'status': (InstanceStatus,),  # noqa: E501
            'v_host_id': (int,),  # noqa: E501
            'add_ons': ([AddOnResponse],),  # noqa: E501
            'product_type': (str,),  # noqa: E501
            'error_message': (str,),  # noqa: E501
            'default_user': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'tenant_id': 'tenantId',  # noqa: E501
        'customer_id': 'customerId',  # noqa: E501
        'additional_ips': 'additionalIps',  # noqa: E501
        'name': 'name',  # noqa: E501
        'display_name': 'displayName',  # noqa: E501
        'instance_id': 'instanceId',  # noqa: E501
        'data_center': 'dataCenter',  # noqa: E501
        'region': 'region',  # noqa: E501
        'region_name': 'regionName',  # noqa: E501
        'product_id': 'productId',  # noqa: E501
        'image_id': 'imageId',  # noqa: E501
        'ip_config': 'ipConfig',  # noqa: E501
        'mac_address': 'macAddress',  # noqa: E501
        'ram_mb': 'ramMb',  # noqa: E501
        'cpu_cores': 'cpuCores',  # noqa: E501
        'os_type': 'osType',  # noqa: E501
        'disk_mb': 'diskMb',  # noqa: E501
        'ssh_keys': 'sshKeys',  # noqa: E501
        'created_date': 'createdDate',  # noqa: E501
        'cancel_date': 'cancelDate',  # noqa: E501
        'status': 'status',  # noqa: E501
        'v_host_id': 'vHostId',  # noqa: E501
        'add_ons': 'addOns',  # noqa: E501
        'product_type': 'productType',  # noqa: E501
        'error_message': 'errorMessage',  # noqa: E501
        'default_user': 'defaultUser',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, tenant_id, customer_id, additional_ips, name, display_name, instance_id, data_center, region, region_name, product_id, image_id, ip_config, mac_address, ram_mb, cpu_cores, os_type, disk_mb, ssh_keys, created_date, cancel_date, status, v_host_id, add_ons, product_type, *args, **kwargs):  # noqa: E501
        """InstanceResponse - a model defined in OpenAPI

        Args:
            tenant_id (str): Your customer tenant id
            customer_id (str): Customer ID
            additional_ips ([AdditionalIp]):
            name (str): Instance Name
            display_name (str): Instance display name
            instance_id (int): Instance ID
            data_center (str): The data center where your Private Network is located
            region (str): Instance region where the compute instance should be located.
            region_name (str): The name of the region where the instance is located.
            product_id (str): Product ID
            image_id (str): Image's id
            ip_config (IpConfig):
            mac_address (str): MAC Address
            ram_mb (float): Image RAM size in MB
            cpu_cores (int): CPU core count
            os_type (str): Type of operating system (OS)
            disk_mb (float): Image Disk size in MB
            ssh_keys ([int]): Array of `secretId`s of public SSH keys for logging into as `defaultUser` with administrator/root privileges. Applies to Linux/BSD systems. Please refer to Secrets Management API.
            created_date (datetime): The creation date for the instance
            cancel_date (date): The date on which the instance will be cancelled
            status (InstanceStatus):
            v_host_id (int): ID of host system
            add_ons ([AddOnResponse]):
            product_type (str): Instance's category depending on Product Id

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            error_message (str): Message in case of an error.. [optional]  # noqa: E501
            default_user (str): Default user name created for login during (re-)installation with administrative privileges. Allowed values for Linux/BSD are `admin` (use sudo to apply administrative privileges like root) or `root`. Allowed values for Windows are `admin` (has administrative privileges like administrator) or `administrator`.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.tenant_id = tenant_id
        self.customer_id = customer_id
        self.additional_ips = additional_ips
        self.name = name
        self.display_name = display_name
        self.instance_id = instance_id
        self.data_center = data_center
        self.region = region
        self.region_name = region_name
        self.product_id = product_id
        self.image_id = image_id
        self.ip_config = ip_config
        self.mac_address = mac_address
        self.ram_mb = ram_mb
        self.cpu_cores = cpu_cores
        self.os_type = os_type
        self.disk_mb = disk_mb
        self.ssh_keys = ssh_keys
        self.created_date = created_date
        self.cancel_date = cancel_date
        self.status = status
        self.v_host_id = v_host_id
        self.add_ons = add_ons
        self.product_type = product_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, tenant_id, customer_id, additional_ips, name, display_name, instance_id, data_center, region, region_name, product_id, image_id, ip_config, mac_address, ram_mb, cpu_cores, os_type, disk_mb, ssh_keys, created_date, cancel_date, status, v_host_id, add_ons, product_type, *args, **kwargs):  # noqa: E501
        """InstanceResponse - a model defined in OpenAPI

        Args:
            tenant_id (str): Your customer tenant id
            customer_id (str): Customer ID
            additional_ips ([AdditionalIp]):
            name (str): Instance Name
            display_name (str): Instance display name
            instance_id (int): Instance ID
            data_center (str): The data center where your Private Network is located
            region (str): Instance region where the compute instance should be located.
            region_name (str): The name of the region where the instance is located.
            product_id (str): Product ID
            image_id (str): Image's id
            ip_config (IpConfig):
            mac_address (str): MAC Address
            ram_mb (float): Image RAM size in MB
            cpu_cores (int): CPU core count
            os_type (str): Type of operating system (OS)
            disk_mb (float): Image Disk size in MB
            ssh_keys ([int]): Array of `secretId`s of public SSH keys for logging into as `defaultUser` with administrator/root privileges. Applies to Linux/BSD systems. Please refer to Secrets Management API.
            created_date (datetime): The creation date for the instance
            cancel_date (date): The date on which the instance will be cancelled
            status (InstanceStatus):
            v_host_id (int): ID of host system
            add_ons ([AddOnResponse]):
            product_type (str): Instance's category depending on Product Id

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            error_message (str): Message in case of an error.. [optional]  # noqa: E501
            default_user (str): Default user name created for login during (re-)installation with administrative privileges. Allowed values for Linux/BSD are `admin` (use sudo to apply administrative privileges like root) or `root`. Allowed values for Windows are `admin` (has administrative privileges like administrator) or `administrator`.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.tenant_id = tenant_id
        self.customer_id = customer_id
        self.additional_ips = additional_ips
        self.name = name
        self.display_name = display_name
        self.instance_id = instance_id
        self.data_center = data_center
        self.region = region
        self.region_name = region_name
        self.product_id = product_id
        self.image_id = image_id
        self.ip_config = ip_config
        self.mac_address = mac_address
        self.ram_mb = ram_mb
        self.cpu_cores = cpu_cores
        self.os_type = os_type
        self.disk_mb = disk_mb
        self.ssh_keys = ssh_keys
        self.created_date = created_date
        self.cancel_date = cancel_date
        self.status = status
        self.v_host_id = v_host_id
        self.add_ons = add_ons
        self.product_type = product_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
