"use strict";
const fs = require("fs");
const os = require("os");
const path = require("path");
const runtime_info_1 = require("../lib/private/runtime-info");
module.exports = {
    'version reporting includes @aws-solutions-konstruk libraries'(test) {
        const pkgdir = fs.mkdtempSync(path.join(os.tmpdir(), 'runtime-info-konstruk-fixture'));
        const mockVersion = '1.2.3';
        fs.writeFileSync(path.join(pkgdir, 'index.js'), 'module.exports = \'this is foo\';');
        fs.writeFileSync(path.join(pkgdir, 'package.json'), JSON.stringify({
            name: '@aws-solutions-konstruk/foo',
            version: mockVersion,
        }));
        // eslint-disable-next-line @typescript-eslint/no-require-imports, import/no-extraneous-dependencies
        require(pkgdir);
        const runtimeInfo = runtime_info_1.collectRuntimeInformation();
        // eslint-disable-next-line @typescript-eslint/no-require-imports
        const version = require('../package.json').version;
        test.deepEqual(runtimeInfo.libraries, {
            '@aws-cdk/core': version,
            '@aws-cdk/cx-api': version,
            '@aws-cdk/cloud-assembly-schema': version,
            '@aws-solutions-konstruk/foo': mockVersion,
            'jsii-runtime': `node.js/${process.version}`,
        });
        test.done();
    },
    'version reporting finds aws-rfdk package'(test) {
        const pkgdir = fs.mkdtempSync(path.join(os.tmpdir(), 'runtime-info-rfdk'));
        const mockVersion = '1.2.3';
        fs.writeFileSync(path.join(pkgdir, 'index.js'), 'module.exports = \'this is foo\';');
        fs.writeFileSync(path.join(pkgdir, 'package.json'), JSON.stringify({
            name: 'aws-rfdk',
            version: mockVersion,
        }));
        // eslint-disable-next-line @typescript-eslint/no-require-imports, import/no-extraneous-dependencies
        require(pkgdir);
        const runtimeInfo = runtime_info_1.collectRuntimeInformation();
        // eslint-disable-next-line @typescript-eslint/no-require-imports
        const version = require('../package.json').version;
        test.deepEqual(runtimeInfo.libraries, {
            '@aws-cdk/core': version,
            '@aws-cdk/cx-api': version,
            '@aws-cdk/cloud-assembly-schema': version,
            '@aws-solutions-konstruk/foo': mockVersion,
            'aws-rfdk': mockVersion,
            'jsii-runtime': `node.js/${process.version}`,
        });
        test.done();
    },
    'version reporting finds no version with no associated package.json'(test) {
        const pkgdir = fs.mkdtempSync(path.join(os.tmpdir(), 'runtime-info-find-npm-package-fixture'));
        const mockVersion = '1.2.3';
        fs.writeFileSync(path.join(pkgdir, 'index.js'), 'module.exports = \'this is bar\';');
        fs.mkdirSync(path.join(pkgdir, 'bar'));
        fs.writeFileSync(path.join(pkgdir, 'bar', 'package.json'), JSON.stringify({
            name: '@aws-solutions-konstruk/bar',
            version: mockVersion,
        }));
        // eslint-disable-next-line @typescript-eslint/no-require-imports, import/no-extraneous-dependencies
        require(pkgdir);
        const cwd = process.cwd();
        // Switch to `bar` where the package.json is, then resolve version.  Fails when module.resolve
        // is passed an empty string in the paths array.
        process.chdir(path.join(pkgdir, 'bar'));
        const runtimeInfo = runtime_info_1.collectRuntimeInformation();
        process.chdir(cwd);
        test.equal(runtimeInfo.libraries['@aws-solutions-konstruk/bar'], undefined);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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