"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Runtime = exports.MetricsLevel = exports.LogLevel = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Available log levels for Flink applications.
 */
var LogLevel;
(function (LogLevel) {
    /** Debug level logging */
    LogLevel["DEBUG"] = "DEBUG";
    /** Info level logging */
    LogLevel["INFO"] = "INFO";
    /** Warn level logging */
    LogLevel["WARN"] = "WARN";
    /** Error level logging */
    LogLevel["ERROR"] = "ERROR";
})(LogLevel || (exports.LogLevel = LogLevel = {}));
/**
 * Granularity of metrics sent to CloudWatch.
 */
var MetricsLevel;
(function (MetricsLevel) {
    /** Application sends the least metrics to CloudWatch */
    MetricsLevel["APPLICATION"] = "APPLICATION";
    /** Task includes task-level metrics sent to CloudWatch */
    MetricsLevel["TASK"] = "TASK";
    /** Operator includes task-level and operator-level metrics sent to CloudWatch */
    MetricsLevel["OPERATOR"] = "OPERATOR";
    /** Send all metrics including metrics per task thread */
    MetricsLevel["PARALLELISM"] = "PARALLELISM";
})(MetricsLevel || (exports.MetricsLevel = MetricsLevel = {}));
/**
 * Available Flink runtimes for Kinesis Analytics.
 */
class Runtime {
    /** Create a new Runtime with with an arbitrary Flink version string */
    static of(value) {
        return new Runtime(value);
    }
    constructor(value) {
        this.value = value;
    }
}
exports.Runtime = Runtime;
_a = JSII_RTTI_SYMBOL_1;
Runtime[_a] = { fqn: "@aws-cdk/aws-kinesisanalytics-flink-alpha.Runtime", version: "2.213.0-alpha.0" };
/** Flink Version 1.6 */
Runtime.FLINK_1_6 = Runtime.of('FLINK-1_6');
/** Flink Version 1.8 */
Runtime.FLINK_1_8 = Runtime.of('FLINK-1_8');
/** Flink Version 1.11 */
Runtime.FLINK_1_11 = Runtime.of('FLINK-1_11');
/** Flink Version 1.13 */
Runtime.FLINK_1_13 = Runtime.of('FLINK-1_13');
/** Flink Version 1.15 */
Runtime.FLINK_1_15 = Runtime.of('FLINK-1_15');
/** Flink Version 1.18 */
Runtime.FLINK_1_18 = Runtime.of('FLINK-1_18');
/** Flink Version 1.19 */
Runtime.FLINK_1_19 = Runtime.of('FLINK-1_19');
/** Flink Version 1.20 */
Runtime.FLINK_1_20 = Runtime.of('FLINK-1_20');
/** Zeppelin Flink Version 3.0 */
Runtime.ZEPPELIN_FLINK_3_0 = Runtime.of('ZEPPELIN-FLINK-3_0');
/** Zeppelin Flink Version 2.0 */
Runtime.ZEPPELIN_FLINK_2_0 = Runtime.of('ZEPPELIN-FLINK-2_0');
/** Zeppelin Flink Version 1.0 */
Runtime.ZEPPELIN_FLINK_1_0 = Runtime.of('ZEPPELIN-FLINK-1_0');
/** SQL Version 1.0 */
Runtime.SQL_1_0 = Runtime.of('SQL-1_0');
//# sourceMappingURL=data:application/json;base64,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