# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomDashboardArgs', 'CustomDashboard']

@pulumi.input_type
class CustomDashboardArgs:
    def __init__(__self__, *,
                 dashboard_items: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDashboardDashboardItemArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CustomDashboard resource.
        :param pulumi.Input[Sequence[pulumi.Input['CustomDashboardDashboardItemArgs']]] dashboard_items: A list of dashboard items.
        :param pulumi.Input[builtins.str] description: A short description of the dashboard.
        :param pulumi.Input[builtins.str] name: A human-readable name.
        """
        if dashboard_items is not None:
            pulumi.set(__self__, "dashboard_items", dashboard_items)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dashboardItems")
    def dashboard_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDashboardDashboardItemArgs']]]]:
        """
        A list of dashboard items.
        """
        return pulumi.get(self, "dashboard_items")

    @dashboard_items.setter
    def dashboard_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDashboardDashboardItemArgs']]]]):
        pulumi.set(self, "dashboard_items", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A short description of the dashboard.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CustomDashboardState:
    def __init__(__self__, *,
                 dashboard_items: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDashboardDashboardItemArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CustomDashboard resources.
        :param pulumi.Input[Sequence[pulumi.Input['CustomDashboardDashboardItemArgs']]] dashboard_items: A list of dashboard items.
        :param pulumi.Input[builtins.str] description: A short description of the dashboard.
        :param pulumi.Input[builtins.str] name: A human-readable name.
        """
        if dashboard_items is not None:
            pulumi.set(__self__, "dashboard_items", dashboard_items)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dashboardItems")
    def dashboard_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDashboardDashboardItemArgs']]]]:
        """
        A list of dashboard items.
        """
        return pulumi.get(self, "dashboard_items")

    @dashboard_items.setter
    def dashboard_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDashboardDashboardItemArgs']]]]):
        pulumi.set(self, "dashboard_items", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A short description of the dashboard.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


class CustomDashboard(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dashboard_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDashboardDashboardItemArgs', 'CustomDashboardDashboardItemArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Custom Dashboard which can be viewed in the Fastly Control Panel.

        ## Import

        Fastly Custom Dashboards can be imported using their ID, e.g.

        ```sh
        $ pulumi import fastly:index/customDashboard:CustomDashboard example xxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomDashboardDashboardItemArgs', 'CustomDashboardDashboardItemArgsDict']]]] dashboard_items: A list of dashboard items.
        :param pulumi.Input[builtins.str] description: A short description of the dashboard.
        :param pulumi.Input[builtins.str] name: A human-readable name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CustomDashboardArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Custom Dashboard which can be viewed in the Fastly Control Panel.

        ## Import

        Fastly Custom Dashboards can be imported using their ID, e.g.

        ```sh
        $ pulumi import fastly:index/customDashboard:CustomDashboard example xxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param CustomDashboardArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomDashboardArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dashboard_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDashboardDashboardItemArgs', 'CustomDashboardDashboardItemArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomDashboardArgs.__new__(CustomDashboardArgs)

            __props__.__dict__["dashboard_items"] = dashboard_items
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
        super(CustomDashboard, __self__).__init__(
            'fastly:index/customDashboard:CustomDashboard',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dashboard_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDashboardDashboardItemArgs', 'CustomDashboardDashboardItemArgsDict']]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'CustomDashboard':
        """
        Get an existing CustomDashboard resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomDashboardDashboardItemArgs', 'CustomDashboardDashboardItemArgsDict']]]] dashboard_items: A list of dashboard items.
        :param pulumi.Input[builtins.str] description: A short description of the dashboard.
        :param pulumi.Input[builtins.str] name: A human-readable name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomDashboardState.__new__(_CustomDashboardState)

        __props__.__dict__["dashboard_items"] = dashboard_items
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        return CustomDashboard(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dashboardItems")
    def dashboard_items(self) -> pulumi.Output[Optional[Sequence['outputs.CustomDashboardDashboardItem']]]:
        """
        A list of dashboard items.
        """
        return pulumi.get(self, "dashboard_items")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A short description of the dashboard.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A human-readable name.
        """
        return pulumi.get(self, "name")

