import typing as t

Indices = t.Sequence[int]
Forms = t.Sequence[str]

class TaggedForm:
  form: str
  tag: str
TaggedForms = t.Sequence[TaggedForm]

class TaggedLemma:
  lemma: str
  tag: str
TaggedLemmas = t.Sequence[TaggedLemma]
Analyses = t.Sequence[TaggedLemmas]

class TaggedLemmaForms:
  lemma: str
  forms: TaggedForms
TaggedLemmasForms = t.Sequence[TaggedLemmaForms]

class TokenRange:
  start: int
  length: int
TokenRanges = t.Sequence[TokenRange]

class DerivatedLemma:
  lemma: str
DerivatedLemmas = t.Sequence[DerivatedLemma]

class Version:
  major: int
  minor: int
  patch: int
  prerelease: str
  @staticmethod
  def current() -> Version: ...

class Tokenizer:
  @staticmethod
  def newVerticalTokenizer() -> Tokenizer: ...
  @staticmethod
  def newCzechTokenizer() -> Tokenizer: ...
  @staticmethod
  def newEnglishTokenizer() -> Tokenizer: ...
  @staticmethod
  def newGenericTokenizer() -> Tokenizer: ...
  def setText(self, text: str): ...
  def nextSentence(self, forms: Forms, tokens: TokenRanges) -> bool: ...

class TagsetConverter:
  @staticmethod
  def newIdentityConverter() -> TagsetConverter: ...
  @staticmethod
  def newPdtToConll2009Converter() -> TagsetConverter: ...
  @staticmethod
  def newStripLemmaCommentConverter(morpho: Morpho) -> TagsetConverter: ...
  @staticmethod
  def newStripLemmaIdConverter(morpho: Morpho) -> TagsetConverter: ...
  def convert(self, lemma: TaggedLemma): ...
  def convertAnalyzed(self, lemmas: TaggedLemmas): ...
  def convertGenerated(self, forms: TaggedLemmasForms): ...

class Derivator:
  def parent(self, lemma: str, parent: DerivatedLemma) -> bool: ...
  def children(self, lemma: str, children: DerivatedLemmas) -> bool: ...

class DerivationFormatter:
  @staticmethod
  def newNoneDerivationFormatter() -> DerivationFormatter: ...
  @staticmethod
  def newRootDerivationFormatter(derivator: Derivator) -> DerivationFormatter: ...
  @staticmethod
  def newPathDerivationFormatter(derivator: Derivator) -> DerivationFormatter: ...
  @staticmethod
  def newTreeDerivationFormatter(derivator: Derivator) -> DerivationFormatter: ...
  @staticmethod
  def newDerivationFormatter(name: str, derivator: Derivator) -> DerivationFormatter: ...
  def formatDerivation(self, lemma: str) -> str: ...
  def formatTaggedLemma(self, tagged_lemma: TaggedLemma, converter: TagsetConverter = None): ...
  def formatTaggedLemmas(self, tagged_lemmas: TaggedLemmas, converter: TagsetConverter = None): ...

class Morpho:
  NO_GUESSER = 0
  GUESSER = 1
  GUESSER_UNSPECIFIED = -1
  @staticmethod
  def load(fname: str) -> Morpho: ...
  def analyze(self, form: str, guesser: int, lemmas: TaggedLemmas) -> int: ...
  def generate(self, lemma: str, tag_wildcard: str, guesser: int, forms: TaggedLemmasForms) -> int: ...
  def rawLemma(self, lemma: str) -> str: ...
  def lemmaId(self, lemma: str) -> str: ...
  def rawForm(self, form: str) -> str: ...
  def newTokenizer(self) -> Tokenizer: ...
  def getDerivator(self) -> Derivator: ...

class Tagger:
  @staticmethod
  def load(fname: str) -> Tagger: ...
  def getMorpho(self) -> Morpho: ...
  def tag(self, forms: Forms, tags: TaggedLemmas, guesser: int = Morpho.GUESSER_UNSPECIFIED): ...
  def tagAnalyzed(self, forms: Forms, analyses: Analyses, tags: Indices): ...
  def newTokenizer(self) -> Tokenizer: ...
