"""Implementations of 'EnumWithSelectedValue' in Python.

As Python does not have an implicit operator, this is the next
best solution for implementing these types properly.
"""

from __future__ import annotations

from enum import Enum
from typing import TYPE_CHECKING

from mastapy._private.gears.ltca import _852
from mastapy._private._internal import mixins
from mastapy._private._internal.python_net import python_net_import

_ARRAY = python_net_import("System", "Array")
_ENUM_WITH_SELECTED_VALUE = python_net_import(
    "SMT.MastaAPI.Utility.Property", "EnumWithSelectedValue"
)

if TYPE_CHECKING:
    from typing import List, Type, Any, TypeVar

    Self = TypeVar("Self", bound="EnumWithSelectedValue_ContactResultType")


__docformat__ = "restructuredtext en"
__all__ = ("EnumWithSelectedValue_ContactResultType",)


class EnumWithSelectedValue_ContactResultType(mixins.EnumWithSelectedValueMixin, Enum):
    """EnumWithSelectedValue_ContactResultType

    A specific implementation of 'EnumWithSelectedValue' for 'ContactResultType' types.
    """

    __qualname__ = "ContactResultType"

    @classmethod
    def wrapper_type(cls: "Type[EnumWithSelectedValue_ContactResultType]") -> "Any":
        """Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _ENUM_WITH_SELECTED_VALUE

    @classmethod
    def wrapped_type(
        cls: "Type[EnumWithSelectedValue_ContactResultType]",
    ) -> "_852.ContactResultType":
        """Wrapped Pythonnet type of this class.

        Note:
            This property is readonly

        Returns:
            _852.ContactResultType
        """
        return _852.ContactResultType

    @classmethod
    def implicit_type(cls: "Type[EnumWithSelectedValue_ContactResultType]") -> "Any":
        """Implicit Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _852.ContactResultType.type_()

    @property
    def selected_value(self: "Self") -> "_852.ContactResultType":
        """mastapy.gears.ltca.ContactResultType

        Note:
            This property is readonly.
        """
        return None

    @property
    def available_values(self: "Self") -> "List[_852.ContactResultType]":
        """List[mastapy.gears.ltca.ContactResultType]

        Note:
            This property is readonly.
        """
        return None
