"""Implementations of 'EnumWithSelectedValue' in Python.

As Python does not have an implicit operator, this is the next
best solution for implementing these types properly.
"""

from __future__ import annotations

from enum import Enum
from typing import TYPE_CHECKING

from mastapy._private.utility.model_validation import _1843
from mastapy._private._internal import mixins
from mastapy._private._internal.python_net import python_net_import

_ARRAY = python_net_import("System", "Array")
_ENUM_WITH_SELECTED_VALUE = python_net_import(
    "SMT.MastaAPI.Utility.Property", "EnumWithSelectedValue"
)

if TYPE_CHECKING:
    from typing import List, Type, Any, TypeVar

    Self = TypeVar("Self", bound="EnumWithSelectedValue_Severity")


__docformat__ = "restructuredtext en"
__all__ = ("EnumWithSelectedValue_Severity",)


class EnumWithSelectedValue_Severity(mixins.EnumWithSelectedValueMixin, Enum):
    """EnumWithSelectedValue_Severity

    A specific implementation of 'EnumWithSelectedValue' for 'Severity' types.
    """

    __qualname__ = "Severity"

    @classmethod
    def wrapper_type(cls: "Type[EnumWithSelectedValue_Severity]") -> "Any":
        """Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _ENUM_WITH_SELECTED_VALUE

    @classmethod
    def wrapped_type(cls: "Type[EnumWithSelectedValue_Severity]") -> "_1843.Severity":
        """Wrapped Pythonnet type of this class.

        Note:
            This property is readonly

        Returns:
            _1843.Severity
        """
        return _1843.Severity

    @classmethod
    def implicit_type(cls: "Type[EnumWithSelectedValue_Severity]") -> "Any":
        """Implicit Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _1843.Severity.type_()

    @property
    def selected_value(self: "Self") -> "_1843.Severity":
        """mastapy.utility.model_validation.Severity

        Note:
            This property is readonly.
        """
        return None

    @property
    def available_values(self: "Self") -> "List[_1843.Severity]":
        """List[mastapy.utility.model_validation.Severity]

        Note:
            This property is readonly.
        """
        return None
