"""LoadedSelfAligningBallBearingElement"""

from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import python_net_import
from mastapy._private.bearings.bearing_results.rolling import _2054
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal import utility

_LOADED_SELF_ALIGNING_BALL_BEARING_ELEMENT = python_net_import(
    "SMT.MastaAPI.Bearings.BearingResults.Rolling",
    "LoadedSelfAligningBallBearingElement",
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    from mastapy._private.bearings.bearing_results.rolling import _2068

    Self = TypeVar("Self", bound="LoadedSelfAligningBallBearingElement")
    CastSelf = TypeVar(
        "CastSelf",
        bound="LoadedSelfAligningBallBearingElement._Cast_LoadedSelfAligningBallBearingElement",
    )


__docformat__ = "restructuredtext en"
__all__ = ("LoadedSelfAligningBallBearingElement",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_LoadedSelfAligningBallBearingElement:
    """Special nested class for casting LoadedSelfAligningBallBearingElement to subclasses."""

    __parent__: "LoadedSelfAligningBallBearingElement"

    @property
    def loaded_ball_bearing_element(
        self: "CastSelf",
    ) -> "_2054.LoadedBallBearingElement":
        return self.__parent__._cast(_2054.LoadedBallBearingElement)

    @property
    def loaded_element(self: "CastSelf") -> "_2068.LoadedElement":
        from mastapy._private.bearings.bearing_results.rolling import _2068

        return self.__parent__._cast(_2068.LoadedElement)

    @property
    def loaded_self_aligning_ball_bearing_element(
        self: "CastSelf",
    ) -> "LoadedSelfAligningBallBearingElement":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class LoadedSelfAligningBallBearingElement(_2054.LoadedBallBearingElement):
    """LoadedSelfAligningBallBearingElement

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _LOADED_SELF_ALIGNING_BALL_BEARING_ELEMENT

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def cast_to(self: "Self") -> "_Cast_LoadedSelfAligningBallBearingElement":
        """Cast to another type.

        Returns:
            _Cast_LoadedSelfAligningBallBearingElement
        """
        return _Cast_LoadedSelfAligningBallBearingElement(self)
