"""SpecificationForTheEffectOfOilKinematicViscosity"""

from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.type_enforcement import enforce_parameter_types
from mastapy._private._internal.python_net import (
    pythonnet_property_get,
    pythonnet_property_set,
    python_net_import,
)
from mastapy._private._internal import utility
from mastapy._private.utility import _1635
from mastapy._private._internal.cast_exception import CastException

_SPECIFICATION_FOR_THE_EFFECT_OF_OIL_KINEMATIC_VISCOSITY = python_net_import(
    "SMT.MastaAPI.Gears", "SpecificationForTheEffectOfOilKinematicViscosity"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="SpecificationForTheEffectOfOilKinematicViscosity")
    CastSelf = TypeVar(
        "CastSelf",
        bound="SpecificationForTheEffectOfOilKinematicViscosity._Cast_SpecificationForTheEffectOfOilKinematicViscosity",
    )


__docformat__ = "restructuredtext en"
__all__ = ("SpecificationForTheEffectOfOilKinematicViscosity",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_SpecificationForTheEffectOfOilKinematicViscosity:
    """Special nested class for casting SpecificationForTheEffectOfOilKinematicViscosity to subclasses."""

    __parent__: "SpecificationForTheEffectOfOilKinematicViscosity"

    @property
    def independent_reportable_properties_base(
        self: "CastSelf",
    ) -> "_1635.IndependentReportablePropertiesBase":
        pass

        return self.__parent__._cast(_1635.IndependentReportablePropertiesBase)

    @property
    def specification_for_the_effect_of_oil_kinematic_viscosity(
        self: "CastSelf",
    ) -> "SpecificationForTheEffectOfOilKinematicViscosity":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class SpecificationForTheEffectOfOilKinematicViscosity(
    _1635.IndependentReportablePropertiesBase[
        "SpecificationForTheEffectOfOilKinematicViscosity"
    ]
):
    """SpecificationForTheEffectOfOilKinematicViscosity

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _SPECIFICATION_FOR_THE_EFFECT_OF_OIL_KINEMATIC_VISCOSITY

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def condition(self: "Self") -> "str":
        """str

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Condition")

        if temp is None:
            return ""

        return temp

    @property
    def intercept_of_linear_equation(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "InterceptOfLinearEquation")

        if temp is None:
            return 0.0

        return temp

    @intercept_of_linear_equation.setter
    @enforce_parameter_types
    def intercept_of_linear_equation(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped,
            "InterceptOfLinearEquation",
            float(value) if value is not None else 0.0,
        )

    @property
    def slope_of_linear_equation(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "SlopeOfLinearEquation")

        if temp is None:
            return 0.0

        return temp

    @slope_of_linear_equation.setter
    @enforce_parameter_types
    def slope_of_linear_equation(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped,
            "SlopeOfLinearEquation",
            float(value) if value is not None else 0.0,
        )

    @property
    def cast_to(
        self: "Self",
    ) -> "_Cast_SpecificationForTheEffectOfOilKinematicViscosity":
        """Cast to another type.

        Returns:
            _Cast_SpecificationForTheEffectOfOilKinematicViscosity
        """
        return _Cast_SpecificationForTheEffectOfOilKinematicViscosity(self)
