"""DrivenMachineCharacteristicGleason"""

from __future__ import annotations

from typing import TYPE_CHECKING
from enum import Enum

from mastapy._private._internal.python_net import python_net_import

_DRIVEN_MACHINE_CHARACTERISTIC_GLEASON = python_net_import(
    "SMT.MastaAPI.Gears.GearDesigns.Bevel", "DrivenMachineCharacteristicGleason"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="DrivenMachineCharacteristicGleason")
    CastSelf = TypeVar(
        "CastSelf",
        bound="DrivenMachineCharacteristicGleason._Cast_DrivenMachineCharacteristicGleason",
    )


__docformat__ = "restructuredtext en"
__all__ = ("DrivenMachineCharacteristicGleason",)


class DrivenMachineCharacteristicGleason(Enum):
    """DrivenMachineCharacteristicGleason

    This is a mastapy class.

    Note:
        This class is an Enum.
    """

    @classmethod
    def type_(cls) -> "Type":
        return _DRIVEN_MACHINE_CHARACTERISTIC_GLEASON

    UNIFORM = 0
    MEDIUM_SHOCK = 1
    HEAVY_SHOCK = 2


def __enum_setattr(self: "Self", attr: str, value: "Any") -> None:
    raise AttributeError("Cannot set the attributes of an Enum.") from None


def __enum_delattr(self: "Self", attr: str) -> None:
    raise AttributeError("Cannot delete the attributes of an Enum.") from None


DrivenMachineCharacteristicGleason.__setattr__ = __enum_setattr
DrivenMachineCharacteristicGleason.__delattr__ = __enum_delattr
