"""CylindricalGearSetParetoOptimiser"""

from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.type_enforcement import enforce_parameter_types
from mastapy._private._internal.python_net import (
    pythonnet_property_get,
    pythonnet_property_get_with_method,
    pythonnet_property_set_with_method,
    python_net_import,
)
from mastapy._private._internal import constructor, conversion, utility
from mastapy._private.gears.gear_set_pareto_optimiser import _937
from mastapy._private._internal.cast_exception import CastException

_DATABASE_WITH_SELECTED_ITEM = python_net_import(
    "SMT.MastaAPI.UtilityGUI.Databases", "DatabaseWithSelectedItem"
)
_CYLINDRICAL_GEAR_SET_PARETO_OPTIMISER = python_net_import(
    "SMT.MastaAPI.Gears.GearSetParetoOptimiser", "CylindricalGearSetParetoOptimiser"
)

if TYPE_CHECKING:
    from typing import Any, Type, List, TypeVar

    from mastapy._private.gears.gear_designs.cylindrical import _1060
    from mastapy._private.gears.gear_set_pareto_optimiser import _931

    Self = TypeVar("Self", bound="CylindricalGearSetParetoOptimiser")
    CastSelf = TypeVar(
        "CastSelf",
        bound="CylindricalGearSetParetoOptimiser._Cast_CylindricalGearSetParetoOptimiser",
    )


__docformat__ = "restructuredtext en"
__all__ = ("CylindricalGearSetParetoOptimiser",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_CylindricalGearSetParetoOptimiser:
    """Special nested class for casting CylindricalGearSetParetoOptimiser to subclasses."""

    __parent__: "CylindricalGearSetParetoOptimiser"

    @property
    def gear_set_pareto_optimiser(self: "CastSelf") -> "_937.GearSetParetoOptimiser":
        return self.__parent__._cast(_937.GearSetParetoOptimiser)

    @property
    def design_space_search_base(self: "CastSelf") -> "_931.DesignSpaceSearchBase":
        pass

        from mastapy._private.gears.gear_set_pareto_optimiser import _931

        return self.__parent__._cast(_931.DesignSpaceSearchBase)

    @property
    def cylindrical_gear_set_pareto_optimiser(
        self: "CastSelf",
    ) -> "CylindricalGearSetParetoOptimiser":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class CylindricalGearSetParetoOptimiser(_937.GearSetParetoOptimiser):
    """CylindricalGearSetParetoOptimiser

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _CYLINDRICAL_GEAR_SET_PARETO_OPTIMISER

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def design_space_search_strategy(self: "Self") -> "str":
        """str"""
        temp = pythonnet_property_get_with_method(
            self.wrapped, "DesignSpaceSearchStrategy", "SelectedItemName"
        )

        if temp is None:
            return ""

        return temp

    @design_space_search_strategy.setter
    @enforce_parameter_types
    def design_space_search_strategy(self: "Self", value: "str") -> None:
        pythonnet_property_set_with_method(
            self.wrapped,
            "DesignSpaceSearchStrategy",
            "SetSelectedItem",
            str(value) if value is not None else "",
        )

    @property
    def design_space_search_strategy_duty_cycle(self: "Self") -> "str":
        """str"""
        temp = pythonnet_property_get_with_method(
            self.wrapped, "DesignSpaceSearchStrategyDutyCycle", "SelectedItemName"
        )

        if temp is None:
            return ""

        return temp

    @design_space_search_strategy_duty_cycle.setter
    @enforce_parameter_types
    def design_space_search_strategy_duty_cycle(self: "Self", value: "str") -> None:
        pythonnet_property_set_with_method(
            self.wrapped,
            "DesignSpaceSearchStrategyDutyCycle",
            "SetSelectedItem",
            str(value) if value is not None else "",
        )

    @property
    def selected_candidate_geometry(self: "Self") -> "_1060.CylindricalGearSetDesign":
        """mastapy.gears.gear_designs.cylindrical.CylindricalGearSetDesign

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "SelectedCandidateGeometry")

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def all_candidate_gear_sets(self: "Self") -> "List[_1060.CylindricalGearSetDesign]":
        """List[mastapy.gears.gear_designs.cylindrical.CylindricalGearSetDesign]

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "AllCandidateGearSets")

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def candidate_gear_sets(self: "Self") -> "List[_1060.CylindricalGearSetDesign]":
        """List[mastapy.gears.gear_designs.cylindrical.CylindricalGearSetDesign]

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "CandidateGearSets")

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def cast_to(self: "Self") -> "_Cast_CylindricalGearSetParetoOptimiser":
        """Cast to another type.

        Returns:
            _Cast_CylindricalGearSetParetoOptimiser
        """
        return _Cast_CylindricalGearSetParetoOptimiser(self)
