"""PinionRoughCutter"""

from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.type_enforcement import enforce_parameter_types
from mastapy._private._internal.python_net import (
    pythonnet_property_get,
    pythonnet_property_set,
    python_net_import,
)
from mastapy._private._internal import utility
from mastapy._private.gears.gear_designs.conical import _1193
from mastapy._private._internal.cast_exception import CastException

_PINION_ROUGH_CUTTER = python_net_import(
    "SMT.MastaAPI.Gears.Manufacturing.Bevel.Cutters", "PinionRoughCutter"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="PinionRoughCutter")
    CastSelf = TypeVar("CastSelf", bound="PinionRoughCutter._Cast_PinionRoughCutter")


__docformat__ = "restructuredtext en"
__all__ = ("PinionRoughCutter",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_PinionRoughCutter:
    """Special nested class for casting PinionRoughCutter to subclasses."""

    __parent__: "PinionRoughCutter"

    @property
    def conical_gear_cutter(self: "CastSelf") -> "_1193.ConicalGearCutter":
        return self.__parent__._cast(_1193.ConicalGearCutter)

    @property
    def pinion_rough_cutter(self: "CastSelf") -> "PinionRoughCutter":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class PinionRoughCutter(_1193.ConicalGearCutter):
    """PinionRoughCutter

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _PINION_ROUGH_CUTTER

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def point_width(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "PointWidth")

        if temp is None:
            return 0.0

        return temp

    @point_width.setter
    @enforce_parameter_types
    def point_width(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped, "PointWidth", float(value) if value is not None else 0.0
        )

    @property
    def cast_to(self: "Self") -> "_Cast_PinionRoughCutter":
        """Cast to another type.

        Returns:
            _Cast_PinionRoughCutter
        """
        return _Cast_PinionRoughCutter(self)
