"""DynamicModelForModalAnalysis"""

from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import python_net_import
from mastapy._private.system_model.analyses_and_results import _2704
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal import utility

_DYNAMIC_MODEL_FOR_MODAL_ANALYSIS = python_net_import(
    "SMT.MastaAPI.SystemModel.AnalysesAndResults", "DynamicModelForModalAnalysis"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    from mastapy._private import _7722

    Self = TypeVar("Self", bound="DynamicModelForModalAnalysis")
    CastSelf = TypeVar(
        "CastSelf",
        bound="DynamicModelForModalAnalysis._Cast_DynamicModelForModalAnalysis",
    )


__docformat__ = "restructuredtext en"
__all__ = ("DynamicModelForModalAnalysis",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_DynamicModelForModalAnalysis:
    """Special nested class for casting DynamicModelForModalAnalysis to subclasses."""

    __parent__: "DynamicModelForModalAnalysis"

    @property
    def single_analysis(self: "CastSelf") -> "_2704.SingleAnalysis":
        return self.__parent__._cast(_2704.SingleAnalysis)

    @property
    def marshal_by_ref_object_permanent(
        self: "CastSelf",
    ) -> "_7722.MarshalByRefObjectPermanent":
        from mastapy._private import _7722

        return self.__parent__._cast(_7722.MarshalByRefObjectPermanent)

    @property
    def dynamic_model_for_modal_analysis(
        self: "CastSelf",
    ) -> "DynamicModelForModalAnalysis":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class DynamicModelForModalAnalysis(_2704.SingleAnalysis):
    """DynamicModelForModalAnalysis

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _DYNAMIC_MODEL_FOR_MODAL_ANALYSIS

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def cast_to(self: "Self") -> "_Cast_DynamicModelForModalAnalysis":
        """Cast to another type.

        Returns:
            _Cast_DynamicModelForModalAnalysis
        """
        return _Cast_DynamicModelForModalAnalysis(self)
