"""DynamicModelForSteadyStateSynchronousResponseAnalysis"""

from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import python_net_import
from mastapy._private.system_model.analyses_and_results import _2704
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal import utility

_DYNAMIC_MODEL_FOR_STEADY_STATE_SYNCHRONOUS_RESPONSE_ANALYSIS = python_net_import(
    "SMT.MastaAPI.SystemModel.AnalysesAndResults",
    "DynamicModelForSteadyStateSynchronousResponseAnalysis",
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    from mastapy._private import _7722

    Self = TypeVar(
        "Self", bound="DynamicModelForSteadyStateSynchronousResponseAnalysis"
    )
    CastSelf = TypeVar(
        "CastSelf",
        bound="DynamicModelForSteadyStateSynchronousResponseAnalysis._Cast_DynamicModelForSteadyStateSynchronousResponseAnalysis",
    )


__docformat__ = "restructuredtext en"
__all__ = ("DynamicModelForSteadyStateSynchronousResponseAnalysis",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_DynamicModelForSteadyStateSynchronousResponseAnalysis:
    """Special nested class for casting DynamicModelForSteadyStateSynchronousResponseAnalysis to subclasses."""

    __parent__: "DynamicModelForSteadyStateSynchronousResponseAnalysis"

    @property
    def single_analysis(self: "CastSelf") -> "_2704.SingleAnalysis":
        return self.__parent__._cast(_2704.SingleAnalysis)

    @property
    def marshal_by_ref_object_permanent(
        self: "CastSelf",
    ) -> "_7722.MarshalByRefObjectPermanent":
        from mastapy._private import _7722

        return self.__parent__._cast(_7722.MarshalByRefObjectPermanent)

    @property
    def dynamic_model_for_steady_state_synchronous_response_analysis(
        self: "CastSelf",
    ) -> "DynamicModelForSteadyStateSynchronousResponseAnalysis":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class DynamicModelForSteadyStateSynchronousResponseAnalysis(_2704.SingleAnalysis):
    """DynamicModelForSteadyStateSynchronousResponseAnalysis

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = (
        _DYNAMIC_MODEL_FOR_STEADY_STATE_SYNCHRONOUS_RESPONSE_ANALYSIS
    )

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def cast_to(
        self: "Self",
    ) -> "_Cast_DynamicModelForSteadyStateSynchronousResponseAnalysis":
        """Cast to another type.

        Returns:
            _Cast_DynamicModelForSteadyStateSynchronousResponseAnalysis
        """
        return _Cast_DynamicModelForSteadyStateSynchronousResponseAnalysis(self)
