"""ModalContributionFilteringMethod"""

from __future__ import annotations

from typing import TYPE_CHECKING
from enum import Enum

from mastapy._private._internal.python_net import python_net_import

_MODAL_CONTRIBUTION_FILTERING_METHOD = python_net_import(
    "SMT.MastaAPI.SystemModel.AnalysesAndResults.HarmonicAnalyses.Results",
    "ModalContributionFilteringMethod",
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="ModalContributionFilteringMethod")
    CastSelf = TypeVar(
        "CastSelf",
        bound="ModalContributionFilteringMethod._Cast_ModalContributionFilteringMethod",
    )


__docformat__ = "restructuredtext en"
__all__ = ("ModalContributionFilteringMethod",)


class ModalContributionFilteringMethod(Enum):
    """ModalContributionFilteringMethod

    This is a mastapy class.

    Note:
        This class is an Enum.
    """

    @classmethod
    def type_(cls) -> "Type":
        return _MODAL_CONTRIBUTION_FILTERING_METHOD

    NO_FILTERING = 0
    ABSOLUTE_AT_MODE_NATURAL_FREQUENCY = 1
    ABSOLUTE_AT_FIXED_FREQUENCY = 2
    INTEGRAL_OVER_FREQUENCY_RANGE = 3


def __enum_setattr(self: "Self", attr: str, value: "Any") -> None:
    raise AttributeError("Cannot set the attributes of an Enum.") from None


def __enum_delattr(self: "Self", attr: str) -> None:
    raise AttributeError("Cannot delete the attributes of an Enum.") from None


ModalContributionFilteringMethod.__setattr__ = __enum_setattr
ModalContributionFilteringMethod.__delattr__ = __enum_delattr
