"""MonteCarloDistribution"""

from __future__ import annotations

from typing import TYPE_CHECKING
from enum import Enum

from mastapy._private._internal.python_net import python_net_import

_MONTE_CARLO_DISTRIBUTION = python_net_import(
    "SMT.MastaAPI.SystemModel.AnalysesAndResults.ParametricStudyTools",
    "MonteCarloDistribution",
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="MonteCarloDistribution")
    CastSelf = TypeVar(
        "CastSelf", bound="MonteCarloDistribution._Cast_MonteCarloDistribution"
    )


__docformat__ = "restructuredtext en"
__all__ = ("MonteCarloDistribution",)


class MonteCarloDistribution(Enum):
    """MonteCarloDistribution

    This is a mastapy class.

    Note:
        This class is an Enum.
    """

    @classmethod
    def type_(cls) -> "Type":
        return _MONTE_CARLO_DISTRIBUTION

    NORMAL_DISTRIBUTION = 1
    UNIFORM_DISTRIBUTION = 2


def __enum_setattr(self: "Self", attr: str, value: "Any") -> None:
    raise AttributeError("Cannot set the attributes of an Enum.") from None


def __enum_delattr(self: "Self", attr: str) -> None:
    raise AttributeError("Cannot delete the attributes of an Enum.") from None


MonteCarloDistribution.__setattr__ = __enum_setattr
MonteCarloDistribution.__delattr__ = __enum_delattr
