"""SKFLossMomentMultipliers"""

from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.type_enforcement import enforce_parameter_types
from mastapy._private._internal.python_net import (
    pythonnet_property_get,
    pythonnet_property_set,
    python_net_import,
)
from mastapy._private._internal.implicit import overridable
from mastapy._private._internal.overridable_constructor import _unpack_overridable
from mastapy._private._internal import constructor, utility
from mastapy._private.utility import _1635
from mastapy._private._internal.cast_exception import CastException

_SKF_LOSS_MOMENT_MULTIPLIERS = python_net_import(
    "SMT.MastaAPI.Utility", "SKFLossMomentMultipliers"
)

if TYPE_CHECKING:
    from typing import Any, Type, Union, Tuple, TypeVar

    Self = TypeVar("Self", bound="SKFLossMomentMultipliers")
    CastSelf = TypeVar(
        "CastSelf", bound="SKFLossMomentMultipliers._Cast_SKFLossMomentMultipliers"
    )


__docformat__ = "restructuredtext en"
__all__ = ("SKFLossMomentMultipliers",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_SKFLossMomentMultipliers:
    """Special nested class for casting SKFLossMomentMultipliers to subclasses."""

    __parent__: "SKFLossMomentMultipliers"

    @property
    def independent_reportable_properties_base(
        self: "CastSelf",
    ) -> "_1635.IndependentReportablePropertiesBase":
        pass

        return self.__parent__._cast(_1635.IndependentReportablePropertiesBase)

    @property
    def skf_loss_moment_multipliers(self: "CastSelf") -> "SKFLossMomentMultipliers":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class SKFLossMomentMultipliers(
    _1635.IndependentReportablePropertiesBase["SKFLossMomentMultipliers"]
):
    """SKFLossMomentMultipliers

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _SKF_LOSS_MOMENT_MULTIPLIERS

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def frictional_moment_of_drag_losses_multiplier(
        self: "Self",
    ) -> "overridable.Overridable_float":
        """Overridable[float]"""
        temp = pythonnet_property_get(
            self.wrapped, "FrictionalMomentOfDragLossesMultiplier"
        )

        if temp is None:
            return 0.0

        return constructor.new_from_mastapy(
            "mastapy._private._internal.implicit.overridable", "Overridable_float"
        )(temp)

    @frictional_moment_of_drag_losses_multiplier.setter
    @enforce_parameter_types
    def frictional_moment_of_drag_losses_multiplier(
        self: "Self", value: "Union[float, Tuple[float, bool]]"
    ) -> None:
        wrapper_type = overridable.Overridable_float.wrapper_type()
        enclosed_type = overridable.Overridable_float.implicit_type()
        value, is_overridden = _unpack_overridable(value)
        value = wrapper_type[enclosed_type](
            enclosed_type(value) if value is not None else 0.0, is_overridden
        )
        pythonnet_property_set(
            self.wrapped, "FrictionalMomentOfDragLossesMultiplier", value
        )

    @property
    def frictional_moment_of_seals_multiplier(
        self: "Self",
    ) -> "overridable.Overridable_float":
        """Overridable[float]"""
        temp = pythonnet_property_get(self.wrapped, "FrictionalMomentOfSealsMultiplier")

        if temp is None:
            return 0.0

        return constructor.new_from_mastapy(
            "mastapy._private._internal.implicit.overridable", "Overridable_float"
        )(temp)

    @frictional_moment_of_seals_multiplier.setter
    @enforce_parameter_types
    def frictional_moment_of_seals_multiplier(
        self: "Self", value: "Union[float, Tuple[float, bool]]"
    ) -> None:
        wrapper_type = overridable.Overridable_float.wrapper_type()
        enclosed_type = overridable.Overridable_float.implicit_type()
        value, is_overridden = _unpack_overridable(value)
        value = wrapper_type[enclosed_type](
            enclosed_type(value) if value is not None else 0.0, is_overridden
        )
        pythonnet_property_set(self.wrapped, "FrictionalMomentOfSealsMultiplier", value)

    @property
    def rolling_frictional_moment_multiplier(
        self: "Self",
    ) -> "overridable.Overridable_float":
        """Overridable[float]"""
        temp = pythonnet_property_get(self.wrapped, "RollingFrictionalMomentMultiplier")

        if temp is None:
            return 0.0

        return constructor.new_from_mastapy(
            "mastapy._private._internal.implicit.overridable", "Overridable_float"
        )(temp)

    @rolling_frictional_moment_multiplier.setter
    @enforce_parameter_types
    def rolling_frictional_moment_multiplier(
        self: "Self", value: "Union[float, Tuple[float, bool]]"
    ) -> None:
        wrapper_type = overridable.Overridable_float.wrapper_type()
        enclosed_type = overridable.Overridable_float.implicit_type()
        value, is_overridden = _unpack_overridable(value)
        value = wrapper_type[enclosed_type](
            enclosed_type(value) if value is not None else 0.0, is_overridden
        )
        pythonnet_property_set(self.wrapped, "RollingFrictionalMomentMultiplier", value)

    @property
    def sliding_frictional_moment_multiplier(
        self: "Self",
    ) -> "overridable.Overridable_float":
        """Overridable[float]"""
        temp = pythonnet_property_get(self.wrapped, "SlidingFrictionalMomentMultiplier")

        if temp is None:
            return 0.0

        return constructor.new_from_mastapy(
            "mastapy._private._internal.implicit.overridable", "Overridable_float"
        )(temp)

    @sliding_frictional_moment_multiplier.setter
    @enforce_parameter_types
    def sliding_frictional_moment_multiplier(
        self: "Self", value: "Union[float, Tuple[float, bool]]"
    ) -> None:
        wrapper_type = overridable.Overridable_float.wrapper_type()
        enclosed_type = overridable.Overridable_float.implicit_type()
        value, is_overridden = _unpack_overridable(value)
        value = wrapper_type[enclosed_type](
            enclosed_type(value) if value is not None else 0.0, is_overridden
        )
        pythonnet_property_set(self.wrapped, "SlidingFrictionalMomentMultiplier", value)

    @property
    def cast_to(self: "Self") -> "_Cast_SKFLossMomentMultipliers":
        """Cast to another type.

        Returns:
            _Cast_SKFLossMomentMultipliers
        """
        return _Cast_SKFLossMomentMultipliers(self)
