"""Subpackage."""

from typing import TYPE_CHECKING as __tc


if __tc:
    from mastapy._private.math_utility.measured_data_scaling._1617 import (
        DataScalingOptions,
    )
    from mastapy._private.math_utility.measured_data_scaling._1618 import (
        DataScalingReferenceValues,
    )
    from mastapy._private.math_utility.measured_data_scaling._1619 import (
        DataScalingReferenceValuesBase,
    )
else:
    import sys as __sys

    from lazy_imports import LazyImporter as __LazyImporter

    __import_structure = {
        "_private.math_utility.measured_data_scaling._1617": ["DataScalingOptions"],
        "_private.math_utility.measured_data_scaling._1618": [
            "DataScalingReferenceValues"
        ],
        "_private.math_utility.measured_data_scaling._1619": [
            "DataScalingReferenceValuesBase"
        ],
    }

    __sys.modules[__name__] = __LazyImporter(
        "mastapy",
        globals()["__file__"],
        __import_structure,
    )

__all__ = (
    "DataScalingOptions",
    "DataScalingReferenceValues",
    "DataScalingReferenceValuesBase",
)
