# Generated by Django 4.2.23 on 2025-08-14 20:50

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('fittings', '0016_remove_dogmaattribute_type_remove_dogmaeffect_type_and_more'),
        ('esi', '0013_squashed_0012_fix_token_type_choices'),
        ('authentication', '0024_alter_userprofile_language'),
        ('eveuniverse', '0011_extend_industry_activites'),
        ('auth', '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='General',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'permissions': (('basic_access', 'Can access this app'), ('can_manage_stocks', 'Can set tracked items'), ('can_manage_deliveries', 'Can see all finished deliveries and delete current ones')),
                'managed': False,
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='ContractSnapshot',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('contract_id', models.BigIntegerField(unique=True)),
                ('owner_character_id', models.BigIntegerField()),
                ('owner_character_name', models.CharField(blank=True, default='', max_length=128)),
                ('type', models.CharField(blank=True, default='', max_length=32)),
                ('availability', models.CharField(blank=True, default='', max_length=32)),
                ('status', models.CharField(blank=True, default='', max_length=32)),
                ('title', models.CharField(blank=True, default='', max_length=255)),
                ('date_issued', models.DateTimeField(blank=True, null=True)),
                ('date_expired', models.DateTimeField(blank=True, null=True)),
                ('start_location_id', models.BigIntegerField(blank=True, null=True)),
                ('end_location_id', models.BigIntegerField(blank=True, null=True)),
                ('price', models.FloatField(blank=True, null=True)),
                ('reward', models.FloatField(blank=True, null=True)),
                ('collateral', models.FloatField(blank=True, null=True)),
                ('volume', models.FloatField(blank=True, null=True)),
                ('for_corporation', models.BooleanField(default=False)),
                ('assignee_id', models.BigIntegerField(blank=True, null=True)),
                ('acceptor_id', models.BigIntegerField(blank=True, null=True)),
                ('issuer_id', models.BigIntegerField(blank=True, null=True)),
                ('issuer_corporation_id', models.BigIntegerField(blank=True, null=True)),
                ('items', models.JSONField(blank=True, default=list)),
                ('fetched_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='DiscordWebhook',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(unique=True, verbose_name='Webhook URL')),
                ('name', models.CharField(default='name', max_length=100)),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='TrackedStructure',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('structure_id', models.BigIntegerField(unique=True)),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='TrackedItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('desired_quantity', models.IntegerField(default=0, verbose_name='Desired quantity')),
                ('last_status', models.CharField(default='OK', max_length=10, verbose_name='Last status')),
                ('item', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='eveuniverse.evetype', verbose_name='Item')),
                ('structure', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='tracked_items', to='markettracker.trackedstructure')),
            ],
            options={
                'default_permissions': (),
                'unique_together': {('item', 'structure')},
            },
        ),
        migrations.CreateModel(
            name='TrackedContract',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mode', models.CharField(choices=[('custom', 'Custom (title match)'), ('doctrine', 'Doctrine (fitting match)')], default='custom', max_length=16)),
                ('title_filter', models.CharField(blank=True, help_text='Substring to match in contract title', max_length=120)),
                ('max_price', models.DecimalField(decimal_places=2, default=0, max_digits=20)),
                ('is_active', models.BooleanField(default=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('desired_quantity', models.PositiveIntegerField(default=0, help_text='Desired contracts on market')),
                ('last_status', models.CharField(default='OK', max_length=10)),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('fitting', models.ForeignKey(blank=True, help_text='Fitting to match contracts against (requires fittings app)', null=True, on_delete=django.db.models.deletion.SET_NULL, to='fittings.fitting')),
            ],
            options={
                'ordering': ['mode', 'title_filter'],
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='MarketTrackingConfig',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('scope', models.CharField(choices=[('region', 'Region'), ('structure', 'Structure')], default='region', max_length=20)),
                ('location_id', models.BigIntegerField(verbose_name='Region or Structure ID')),
                ('yellow_threshold', models.PositiveIntegerField(default=50, help_text='Percentage of desired quantity at which item turns yellow.', verbose_name='Yellow status threshold (%)')),
                ('red_threshold', models.PositiveIntegerField(default=25, help_text='Percentage of desired quantity at which item turns red.', verbose_name='Red status threshold (%)')),
                ('discord_alert_header', models.CharField(default='⚠️ MarketTracker Alert', help_text='Header text used for Discord alerts about items.', max_length=200)),
                ('contract_discord_alert_header', models.CharField(default='📦 MarketTracker Contracts', help_text='Header text used for Discord alerts about contracts.', max_length=200)),
                ('discord_ping_group_text', models.CharField(blank=True, help_text='Special ping target: none, here, everyone', max_length=32, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('discord_ping_group', models.ForeignKey(blank=True, help_text='Discord role to ping (optional)', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='markettracker_ping_group', to='auth.group')),
                ('discord_webhooks', models.ManyToManyField(blank=True, to='markettracker.discordwebhook')),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='MarketOrderSnapshot',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order_id', models.BigIntegerField(unique=True)),
                ('structure_id', models.BigIntegerField()),
                ('price', models.FloatField()),
                ('volume_remain', models.IntegerField()),
                ('is_buy_order', models.BooleanField(default=False)),
                ('issued', models.DateTimeField()),
                ('tracked_item', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='order_snapshots', to='markettracker.trackeditem')),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='MarketCharacter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(default='user', max_length=20)),
                ('character', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='market_character', to='authentication.characterownership')),
                ('token', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='esi.token')),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='Delivery',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('declared_quantity', models.PositiveIntegerField(verbose_name='Declared quantity')),
                ('delivered_quantity', models.PositiveIntegerField(default=0, verbose_name='Delivered quantity')),
                ('status', models.CharField(choices=[('PENDING', 'Pending'), ('FINISHED', 'Finished')], default='PENDING', max_length=10, verbose_name='Status')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('character', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='authentication.characterownership', verbose_name='Character')),
                ('item', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='eveuniverse.evetype', verbose_name='Item')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='ContractError',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('contract_id', models.BigIntegerField()),
                ('owner_name', models.CharField(blank=True, max_length=128)),
                ('code', models.CharField(choices=[('price', 'Price exceeds max'), ('hull', 'Wrong hull'), ('modules', 'Modules mismatch'), ('title', 'Title mismatch'), ('doctrine', 'Doctrine fitting missing')], max_length=16)),
                ('message', models.TextField(blank=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('is_resolved', models.BooleanField(default=False)),
                ('tracked', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='errors', to='markettracker.trackedcontract')),
            ],
            options={
                'ordering': ['-created_at'],
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='ContractDelivery',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('declared_quantity', models.PositiveIntegerField(verbose_name='Declared quantity')),
                ('delivered_quantity', models.PositiveIntegerField(default=0, verbose_name='Delivered quantity')),
                ('status', models.CharField(choices=[('PENDING', 'Pending'), ('FINISHED', 'Finished')], default='PENDING', max_length=10, verbose_name='Status')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('tracked_contract', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='deliveries', to='markettracker.trackedcontract', verbose_name='Tracked contract')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'default_permissions': (),
            },
        ),
    ]
