# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetVulnerabilityAuditResult',
    'AwaitableGetVulnerabilityAuditResult',
    'get_vulnerability_audit',
    'get_vulnerability_audit_output',
]

@pulumi.output_type
class GetVulnerabilityAuditResult:
    """
    A collection of values returned by getVulnerabilityAudit.
    """
    def __init__(__self__, application_dependencies=None, build_type=None, compartment_id=None, configurations=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, is_success=None, knowledge_base_id=None, lifecycle_details=None, max_observed_cvss_v2score=None, max_observed_cvss_v2score_with_ignored=None, max_observed_cvss_v3score=None, max_observed_cvss_v3score_with_ignored=None, max_observed_severity=None, max_observed_severity_with_ignored=None, sources=None, state=None, system_tags=None, time_created=None, time_updated=None, usage_datas=None, vulnerabilities=None, vulnerability_audit_id=None, vulnerable_artifacts_count=None, vulnerable_artifacts_count_with_ignored=None):
        if application_dependencies and not isinstance(application_dependencies, list):
            raise TypeError("Expected argument 'application_dependencies' to be a list")
        pulumi.set(__self__, "application_dependencies", application_dependencies)
        if build_type and not isinstance(build_type, str):
            raise TypeError("Expected argument 'build_type' to be a str")
        pulumi.set(__self__, "build_type", build_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if configurations and not isinstance(configurations, list):
            raise TypeError("Expected argument 'configurations' to be a list")
        pulumi.set(__self__, "configurations", configurations)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_success and not isinstance(is_success, bool):
            raise TypeError("Expected argument 'is_success' to be a bool")
        pulumi.set(__self__, "is_success", is_success)
        if knowledge_base_id and not isinstance(knowledge_base_id, str):
            raise TypeError("Expected argument 'knowledge_base_id' to be a str")
        pulumi.set(__self__, "knowledge_base_id", knowledge_base_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if max_observed_cvss_v2score and not isinstance(max_observed_cvss_v2score, float):
            raise TypeError("Expected argument 'max_observed_cvss_v2score' to be a float")
        pulumi.set(__self__, "max_observed_cvss_v2score", max_observed_cvss_v2score)
        if max_observed_cvss_v2score_with_ignored and not isinstance(max_observed_cvss_v2score_with_ignored, float):
            raise TypeError("Expected argument 'max_observed_cvss_v2score_with_ignored' to be a float")
        pulumi.set(__self__, "max_observed_cvss_v2score_with_ignored", max_observed_cvss_v2score_with_ignored)
        if max_observed_cvss_v3score and not isinstance(max_observed_cvss_v3score, float):
            raise TypeError("Expected argument 'max_observed_cvss_v3score' to be a float")
        pulumi.set(__self__, "max_observed_cvss_v3score", max_observed_cvss_v3score)
        if max_observed_cvss_v3score_with_ignored and not isinstance(max_observed_cvss_v3score_with_ignored, float):
            raise TypeError("Expected argument 'max_observed_cvss_v3score_with_ignored' to be a float")
        pulumi.set(__self__, "max_observed_cvss_v3score_with_ignored", max_observed_cvss_v3score_with_ignored)
        if max_observed_severity and not isinstance(max_observed_severity, str):
            raise TypeError("Expected argument 'max_observed_severity' to be a str")
        pulumi.set(__self__, "max_observed_severity", max_observed_severity)
        if max_observed_severity_with_ignored and not isinstance(max_observed_severity_with_ignored, str):
            raise TypeError("Expected argument 'max_observed_severity_with_ignored' to be a str")
        pulumi.set(__self__, "max_observed_severity_with_ignored", max_observed_severity_with_ignored)
        if sources and not isinstance(sources, list):
            raise TypeError("Expected argument 'sources' to be a list")
        pulumi.set(__self__, "sources", sources)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if usage_datas and not isinstance(usage_datas, list):
            raise TypeError("Expected argument 'usage_datas' to be a list")
        pulumi.set(__self__, "usage_datas", usage_datas)
        if vulnerabilities and not isinstance(vulnerabilities, list):
            raise TypeError("Expected argument 'vulnerabilities' to be a list")
        pulumi.set(__self__, "vulnerabilities", vulnerabilities)
        if vulnerability_audit_id and not isinstance(vulnerability_audit_id, str):
            raise TypeError("Expected argument 'vulnerability_audit_id' to be a str")
        pulumi.set(__self__, "vulnerability_audit_id", vulnerability_audit_id)
        if vulnerable_artifacts_count and not isinstance(vulnerable_artifacts_count, int):
            raise TypeError("Expected argument 'vulnerable_artifacts_count' to be a int")
        pulumi.set(__self__, "vulnerable_artifacts_count", vulnerable_artifacts_count)
        if vulnerable_artifacts_count_with_ignored and not isinstance(vulnerable_artifacts_count_with_ignored, int):
            raise TypeError("Expected argument 'vulnerable_artifacts_count_with_ignored' to be a int")
        pulumi.set(__self__, "vulnerable_artifacts_count_with_ignored", vulnerable_artifacts_count_with_ignored)

    @property
    @pulumi.getter(name="applicationDependencies")
    def application_dependencies(self) -> Sequence['outputs.GetVulnerabilityAuditApplicationDependencyResult']:
        return pulumi.get(self, "application_dependencies")

    @property
    @pulumi.getter(name="buildType")
    def build_type(self) -> str:
        """
        The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET when the list of application dependencies is not Maven-related or is a mix of Maven and other ecosystems. This option is soon to be deprecated.
        """
        return pulumi.get(self, "build_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the vulnerability audit.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetVulnerabilityAuditConfigurationResult']:
        """
        Configuration for a vulnerability audit. A vulnerable application dependency is ignored if its name does match any of the items in `exclusions`, or all of the associated Vulnerabilies have a CVSS v2 score below `maxPermissibleCvssV2Score` and a CVSS v3 score below `maxPermissibleCvssV3Score`. type: object
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The name of the vulnerability audit.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique vulnerability identifier, e.g. CVE-1999-0067.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isSuccess")
    def is_success(self) -> bool:
        """
        Indicates if an audit succeeded according to the configuration. The value is `null` if the audit is in the `CREATING` state.
        """
        return pulumi.get(self, "is_success")

    @property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> str:
        """
        The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        """
        return pulumi.get(self, "knowledge_base_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Details on the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maxObservedCvssV2score")
    def max_observed_cvss_v2score(self) -> float:
        """
        Maximum Common Vulnerability Scoring System Version 2 score observed for non-ignored vulnerable application dependencies.
        """
        return pulumi.get(self, "max_observed_cvss_v2score")

    @property
    @pulumi.getter(name="maxObservedCvssV2scoreWithIgnored")
    def max_observed_cvss_v2score_with_ignored(self) -> float:
        """
        Maximum Common Vulnerability Scoring System Version 2 score observed for vulnerable application dependencies including ignored ones.
        """
        return pulumi.get(self, "max_observed_cvss_v2score_with_ignored")

    @property
    @pulumi.getter(name="maxObservedCvssV3score")
    def max_observed_cvss_v3score(self) -> float:
        """
        Maximum Common Vulnerability Scoring System Version 3 score observed for non-ignored vulnerable application dependencies.
        """
        return pulumi.get(self, "max_observed_cvss_v3score")

    @property
    @pulumi.getter(name="maxObservedCvssV3scoreWithIgnored")
    def max_observed_cvss_v3score_with_ignored(self) -> float:
        """
        Maximum Common Vulnerability Scoring System Version 3 score observed for vulnerable application dependencies including ignored ones.
        """
        return pulumi.get(self, "max_observed_cvss_v3score_with_ignored")

    @property
    @pulumi.getter(name="maxObservedSeverity")
    def max_observed_severity(self) -> str:
        """
        Maximum ADM Severity observed for non-ignored vulnerable application dependencies.
        """
        return pulumi.get(self, "max_observed_severity")

    @property
    @pulumi.getter(name="maxObservedSeverityWithIgnored")
    def max_observed_severity_with_ignored(self) -> str:
        """
        Maximum ADM Severity observed for vulnerable application dependencies including ignored ones.
        """
        return pulumi.get(self, "max_observed_severity_with_ignored")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetVulnerabilityAuditSourceResult']:
        """
        Source that published the vulnerability
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the vulnerability audit.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The creation date and time of the vulnerability audit (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The update date and time of the vulnerability audit (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="usageDatas")
    def usage_datas(self) -> Sequence['outputs.GetVulnerabilityAuditUsageDataResult']:
        """
        The source details of the usage data in object storage. The usage data file uploaded to object storage must be a gzip archive of the JSON usage data returned from the GraalVM native-image-inspect tool after a native-image build. Set `sourceType` to `objectStorageTuple` and use [UsageDataViaObjectStorageTupleDetails](https://docs.cloud.oracle.com/iaas/api/#/en/adm/latest/requests/UsageDataViaObjectStorageTupleDetails) when specifying the namespace, bucket name, and object name.
        """
        return pulumi.get(self, "usage_datas")

    @property
    @pulumi.getter
    def vulnerabilities(self) -> Sequence['outputs.GetVulnerabilityAuditVulnerabilityResult']:
        """
        List of vulnerabilities found in the vulnerability audit. If a vulnerability affects multiple dependencies, the metadata returned here consists of audit-wide aggregates.
        """
        return pulumi.get(self, "vulnerabilities")

    @property
    @pulumi.getter(name="vulnerabilityAuditId")
    def vulnerability_audit_id(self) -> str:
        return pulumi.get(self, "vulnerability_audit_id")

    @property
    @pulumi.getter(name="vulnerableArtifactsCount")
    def vulnerable_artifacts_count(self) -> int:
        """
        Count of non-ignored vulnerable application dependencies.
        """
        return pulumi.get(self, "vulnerable_artifacts_count")

    @property
    @pulumi.getter(name="vulnerableArtifactsCountWithIgnored")
    def vulnerable_artifacts_count_with_ignored(self) -> int:
        """
        Count of all vulnerable application dependencies.
        """
        return pulumi.get(self, "vulnerable_artifacts_count_with_ignored")


class AwaitableGetVulnerabilityAuditResult(GetVulnerabilityAuditResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVulnerabilityAuditResult(
            application_dependencies=self.application_dependencies,
            build_type=self.build_type,
            compartment_id=self.compartment_id,
            configurations=self.configurations,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_success=self.is_success,
            knowledge_base_id=self.knowledge_base_id,
            lifecycle_details=self.lifecycle_details,
            max_observed_cvss_v2score=self.max_observed_cvss_v2score,
            max_observed_cvss_v2score_with_ignored=self.max_observed_cvss_v2score_with_ignored,
            max_observed_cvss_v3score=self.max_observed_cvss_v3score,
            max_observed_cvss_v3score_with_ignored=self.max_observed_cvss_v3score_with_ignored,
            max_observed_severity=self.max_observed_severity,
            max_observed_severity_with_ignored=self.max_observed_severity_with_ignored,
            sources=self.sources,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            usage_datas=self.usage_datas,
            vulnerabilities=self.vulnerabilities,
            vulnerability_audit_id=self.vulnerability_audit_id,
            vulnerable_artifacts_count=self.vulnerable_artifacts_count,
            vulnerable_artifacts_count_with_ignored=self.vulnerable_artifacts_count_with_ignored)


def get_vulnerability_audit(vulnerability_audit_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVulnerabilityAuditResult:
    """
    This data source provides details about a specific Vulnerability Audit resource in Oracle Cloud Infrastructure ADM service.

    Returns the details of the specified Vulnerability Audit.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vulnerability_audit = oci.Adm.get_vulnerability_audit(vulnerability_audit_id=test_vulnerability_audit_oci_adm_vulnerability_audit["id"])
    ```


    :param str vulnerability_audit_id: Unique Vulnerability Audit identifier path parameter.
    """
    __args__ = dict()
    __args__['vulnerabilityAuditId'] = vulnerability_audit_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Adm/getVulnerabilityAudit:getVulnerabilityAudit', __args__, opts=opts, typ=GetVulnerabilityAuditResult).value

    return AwaitableGetVulnerabilityAuditResult(
        application_dependencies=pulumi.get(__ret__, 'application_dependencies'),
        build_type=pulumi.get(__ret__, 'build_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        configurations=pulumi.get(__ret__, 'configurations'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_success=pulumi.get(__ret__, 'is_success'),
        knowledge_base_id=pulumi.get(__ret__, 'knowledge_base_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        max_observed_cvss_v2score=pulumi.get(__ret__, 'max_observed_cvss_v2score'),
        max_observed_cvss_v2score_with_ignored=pulumi.get(__ret__, 'max_observed_cvss_v2score_with_ignored'),
        max_observed_cvss_v3score=pulumi.get(__ret__, 'max_observed_cvss_v3score'),
        max_observed_cvss_v3score_with_ignored=pulumi.get(__ret__, 'max_observed_cvss_v3score_with_ignored'),
        max_observed_severity=pulumi.get(__ret__, 'max_observed_severity'),
        max_observed_severity_with_ignored=pulumi.get(__ret__, 'max_observed_severity_with_ignored'),
        sources=pulumi.get(__ret__, 'sources'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        usage_datas=pulumi.get(__ret__, 'usage_datas'),
        vulnerabilities=pulumi.get(__ret__, 'vulnerabilities'),
        vulnerability_audit_id=pulumi.get(__ret__, 'vulnerability_audit_id'),
        vulnerable_artifacts_count=pulumi.get(__ret__, 'vulnerable_artifacts_count'),
        vulnerable_artifacts_count_with_ignored=pulumi.get(__ret__, 'vulnerable_artifacts_count_with_ignored'))


@_utilities.lift_output_func(get_vulnerability_audit)
def get_vulnerability_audit_output(vulnerability_audit_id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVulnerabilityAuditResult]:
    """
    This data source provides details about a specific Vulnerability Audit resource in Oracle Cloud Infrastructure ADM service.

    Returns the details of the specified Vulnerability Audit.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vulnerability_audit = oci.Adm.get_vulnerability_audit(vulnerability_audit_id=test_vulnerability_audit_oci_adm_vulnerability_audit["id"])
    ```


    :param str vulnerability_audit_id: Unique Vulnerability Audit identifier path parameter.
    """
    ...
