# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ModelArgs', 'Model']

@pulumi.input_type
class ModelArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 model_details: pulumi.Input['ModelModelDetailsArgs'],
                 project_id: pulumi.Input[str],
                 training_dataset: pulumi.Input['ModelTrainingDatasetArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 test_strategy: Optional[pulumi.Input['ModelTestStrategyArgs']] = None):
        """
        The set of arguments for constructing a Model resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)  for the models compartment.
        :param pulumi.Input['ModelModelDetailsArgs'] model_details: Possible model types
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        :param pulumi.Input['ModelTrainingDatasetArgs'] training_dataset: Possible data set type
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the a model.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input['ModelTestStrategyArgs'] test_strategy: Possible strategy as testing and validation(optional) dataset.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "model_details", model_details)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "training_dataset", training_dataset)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if test_strategy is not None:
            pulumi.set(__self__, "test_strategy", test_strategy)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)  for the models compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="modelDetails")
    def model_details(self) -> pulumi.Input['ModelModelDetailsArgs']:
        """
        Possible model types
        """
        return pulumi.get(self, "model_details")

    @model_details.setter
    def model_details(self, value: pulumi.Input['ModelModelDetailsArgs']):
        pulumi.set(self, "model_details", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="trainingDataset")
    def training_dataset(self) -> pulumi.Input['ModelTrainingDatasetArgs']:
        """
        Possible data set type
        """
        return pulumi.get(self, "training_dataset")

    @training_dataset.setter
    def training_dataset(self, value: pulumi.Input['ModelTrainingDatasetArgs']):
        pulumi.set(self, "training_dataset", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A short description of the a model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="testStrategy")
    def test_strategy(self) -> Optional[pulumi.Input['ModelTestStrategyArgs']]:
        """
        Possible strategy as testing and validation(optional) dataset.
        """
        return pulumi.get(self, "test_strategy")

    @test_strategy.setter
    def test_strategy(self, value: Optional[pulumi.Input['ModelTestStrategyArgs']]):
        pulumi.set(self, "test_strategy", value)


@pulumi.input_type
class _ModelState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 evaluation_results: Optional[pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 model_details: Optional[pulumi.Input['ModelModelDetailsArgs']] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 test_strategy: Optional[pulumi.Input['ModelTestStrategyArgs']] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 training_dataset: Optional[pulumi.Input['ModelTrainingDatasetArgs']] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Model resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)  for the models compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the a model.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultArgs']]] evaluation_results: model training results of different models
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in failed state.
        :param pulumi.Input['ModelModelDetailsArgs'] model_details: Possible model types
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        :param pulumi.Input[str] state: The state of the model.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input['ModelTestStrategyArgs'] test_strategy: Possible strategy as testing and validation(optional) dataset.
        :param pulumi.Input[str] time_created: The time the the model was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time the model was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input['ModelTrainingDatasetArgs'] training_dataset: Possible data set type
        :param pulumi.Input[str] version: For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if evaluation_results is not None:
            pulumi.set(__self__, "evaluation_results", evaluation_results)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if model_details is not None:
            pulumi.set(__self__, "model_details", model_details)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if test_strategy is not None:
            pulumi.set(__self__, "test_strategy", test_strategy)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if training_dataset is not None:
            pulumi.set(__self__, "training_dataset", training_dataset)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)  for the models compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A short description of the a model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="evaluationResults")
    def evaluation_results(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultArgs']]]]:
        """
        model training results of different models
        """
        return pulumi.get(self, "evaluation_results")

    @evaluation_results.setter
    def evaluation_results(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultArgs']]]]):
        pulumi.set(self, "evaluation_results", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="modelDetails")
    def model_details(self) -> Optional[pulumi.Input['ModelModelDetailsArgs']]:
        """
        Possible model types
        """
        return pulumi.get(self, "model_details")

    @model_details.setter
    def model_details(self, value: Optional[pulumi.Input['ModelModelDetailsArgs']]):
        pulumi.set(self, "model_details", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the model.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="testStrategy")
    def test_strategy(self) -> Optional[pulumi.Input['ModelTestStrategyArgs']]:
        """
        Possible strategy as testing and validation(optional) dataset.
        """
        return pulumi.get(self, "test_strategy")

    @test_strategy.setter
    def test_strategy(self, value: Optional[pulumi.Input['ModelTestStrategyArgs']]):
        pulumi.set(self, "test_strategy", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the the model was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the model was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="trainingDataset")
    def training_dataset(self) -> Optional[pulumi.Input['ModelTrainingDatasetArgs']]:
        """
        Possible data set type
        """
        return pulumi.get(self, "training_dataset")

    @training_dataset.setter
    def training_dataset(self, value: Optional[pulumi.Input['ModelTrainingDatasetArgs']]):
        pulumi.set(self, "training_dataset", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class Model(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 model_details: Optional[pulumi.Input[Union['ModelModelDetailsArgs', 'ModelModelDetailsArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 test_strategy: Optional[pulumi.Input[Union['ModelTestStrategyArgs', 'ModelTestStrategyArgsDict']]] = None,
                 training_dataset: Optional[pulumi.Input[Union['ModelTrainingDatasetArgs', 'ModelTrainingDatasetArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Model resource in Oracle Cloud Infrastructure Ai Language service.

        Creates a new model for training and train the model with date provided.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_model = oci.ai_language.Model("test_model",
            compartment_id=compartment_id,
            model_details={
                "model_type": model_model_details_model_type,
                "classification_mode": {
                    "classification_mode": model_model_details_classification_mode_classification_mode,
                    "version": model_model_details_classification_mode_version,
                },
                "language_code": model_model_details_language_code,
                "version": model_model_details_version,
            },
            project_id=test_project["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=model_description,
            display_name=model_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            test_strategy={
                "strategy_type": model_test_strategy_strategy_type,
                "testing_dataset": {
                    "dataset_type": model_test_strategy_testing_dataset_dataset_type,
                    "dataset_id": test_dataset["id"],
                    "location_details": {
                        "bucket": model_test_strategy_testing_dataset_location_details_bucket,
                        "location_type": model_test_strategy_testing_dataset_location_details_location_type,
                        "namespace": model_test_strategy_testing_dataset_location_details_namespace,
                        "object_names": model_test_strategy_testing_dataset_location_details_object_names,
                    },
                },
                "validation_dataset": {
                    "dataset_type": model_test_strategy_validation_dataset_dataset_type,
                    "dataset_id": test_dataset["id"],
                    "location_details": {
                        "bucket": model_test_strategy_validation_dataset_location_details_bucket,
                        "location_type": model_test_strategy_validation_dataset_location_details_location_type,
                        "namespace": model_test_strategy_validation_dataset_location_details_namespace,
                        "object_names": model_test_strategy_validation_dataset_location_details_object_names,
                    },
                },
            },
            training_dataset={
                "dataset_type": model_training_dataset_dataset_type,
                "dataset_id": test_dataset["id"],
                "location_details": {
                    "bucket": model_training_dataset_location_details_bucket,
                    "location_type": model_training_dataset_location_details_location_type,
                    "namespace": model_training_dataset_location_details_namespace,
                    "object_names": model_training_dataset_location_details_object_names,
                },
            })
        ```

        ## Import

        Models can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:AiLanguage/model:Model test_model "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)  for the models compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the a model.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Union['ModelModelDetailsArgs', 'ModelModelDetailsArgsDict']] model_details: Possible model types
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        :param pulumi.Input[Union['ModelTestStrategyArgs', 'ModelTestStrategyArgsDict']] test_strategy: Possible strategy as testing and validation(optional) dataset.
        :param pulumi.Input[Union['ModelTrainingDatasetArgs', 'ModelTrainingDatasetArgsDict']] training_dataset: Possible data set type
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ModelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Model resource in Oracle Cloud Infrastructure Ai Language service.

        Creates a new model for training and train the model with date provided.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_model = oci.ai_language.Model("test_model",
            compartment_id=compartment_id,
            model_details={
                "model_type": model_model_details_model_type,
                "classification_mode": {
                    "classification_mode": model_model_details_classification_mode_classification_mode,
                    "version": model_model_details_classification_mode_version,
                },
                "language_code": model_model_details_language_code,
                "version": model_model_details_version,
            },
            project_id=test_project["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=model_description,
            display_name=model_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            test_strategy={
                "strategy_type": model_test_strategy_strategy_type,
                "testing_dataset": {
                    "dataset_type": model_test_strategy_testing_dataset_dataset_type,
                    "dataset_id": test_dataset["id"],
                    "location_details": {
                        "bucket": model_test_strategy_testing_dataset_location_details_bucket,
                        "location_type": model_test_strategy_testing_dataset_location_details_location_type,
                        "namespace": model_test_strategy_testing_dataset_location_details_namespace,
                        "object_names": model_test_strategy_testing_dataset_location_details_object_names,
                    },
                },
                "validation_dataset": {
                    "dataset_type": model_test_strategy_validation_dataset_dataset_type,
                    "dataset_id": test_dataset["id"],
                    "location_details": {
                        "bucket": model_test_strategy_validation_dataset_location_details_bucket,
                        "location_type": model_test_strategy_validation_dataset_location_details_location_type,
                        "namespace": model_test_strategy_validation_dataset_location_details_namespace,
                        "object_names": model_test_strategy_validation_dataset_location_details_object_names,
                    },
                },
            },
            training_dataset={
                "dataset_type": model_training_dataset_dataset_type,
                "dataset_id": test_dataset["id"],
                "location_details": {
                    "bucket": model_training_dataset_location_details_bucket,
                    "location_type": model_training_dataset_location_details_location_type,
                    "namespace": model_training_dataset_location_details_namespace,
                    "object_names": model_training_dataset_location_details_object_names,
                },
            })
        ```

        ## Import

        Models can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:AiLanguage/model:Model test_model "id"
        ```

        :param str resource_name: The name of the resource.
        :param ModelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 model_details: Optional[pulumi.Input[Union['ModelModelDetailsArgs', 'ModelModelDetailsArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 test_strategy: Optional[pulumi.Input[Union['ModelTestStrategyArgs', 'ModelTestStrategyArgsDict']]] = None,
                 training_dataset: Optional[pulumi.Input[Union['ModelTrainingDatasetArgs', 'ModelTrainingDatasetArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModelArgs.__new__(ModelArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if model_details is None and not opts.urn:
                raise TypeError("Missing required property 'model_details'")
            __props__.__dict__["model_details"] = model_details
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["test_strategy"] = test_strategy
            if training_dataset is None and not opts.urn:
                raise TypeError("Missing required property 'training_dataset'")
            __props__.__dict__["training_dataset"] = training_dataset
            __props__.__dict__["evaluation_results"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["version"] = None
        super(Model, __self__).__init__(
            'oci:AiLanguage/model:Model',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            evaluation_results: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelEvaluationResultArgs', 'ModelEvaluationResultArgsDict']]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            model_details: Optional[pulumi.Input[Union['ModelModelDetailsArgs', 'ModelModelDetailsArgsDict']]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            test_strategy: Optional[pulumi.Input[Union['ModelTestStrategyArgs', 'ModelTestStrategyArgsDict']]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            training_dataset: Optional[pulumi.Input[Union['ModelTrainingDatasetArgs', 'ModelTrainingDatasetArgsDict']]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'Model':
        """
        Get an existing Model resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)  for the models compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the a model.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelEvaluationResultArgs', 'ModelEvaluationResultArgsDict']]]] evaluation_results: model training results of different models
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in failed state.
        :param pulumi.Input[Union['ModelModelDetailsArgs', 'ModelModelDetailsArgsDict']] model_details: Possible model types
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        :param pulumi.Input[str] state: The state of the model.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Union['ModelTestStrategyArgs', 'ModelTestStrategyArgsDict']] test_strategy: Possible strategy as testing and validation(optional) dataset.
        :param pulumi.Input[str] time_created: The time the the model was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time the model was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[Union['ModelTrainingDatasetArgs', 'ModelTrainingDatasetArgsDict']] training_dataset: Possible data set type
        :param pulumi.Input[str] version: For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ModelState.__new__(_ModelState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["evaluation_results"] = evaluation_results
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["model_details"] = model_details
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["test_strategy"] = test_strategy
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["training_dataset"] = training_dataset
        __props__.__dict__["version"] = version
        return Model(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)  for the models compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) A short description of the a model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="evaluationResults")
    def evaluation_results(self) -> pulumi.Output[Sequence['outputs.ModelEvaluationResult']]:
        """
        model training results of different models
        """
        return pulumi.get(self, "evaluation_results")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="modelDetails")
    def model_details(self) -> pulumi.Output['outputs.ModelModelDetails']:
        """
        Possible model types
        """
        return pulumi.get(self, "model_details")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the model.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="testStrategy")
    def test_strategy(self) -> pulumi.Output['outputs.ModelTestStrategy']:
        """
        Possible strategy as testing and validation(optional) dataset.
        """
        return pulumi.get(self, "test_strategy")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the the model was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the model was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="trainingDataset")
    def training_dataset(self) -> pulumi.Output['outputs.ModelTrainingDataset']:
        """
        Possible data set type
        """
        return pulumi.get(self, "training_dataset")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        return pulumi.get(self, "version")

