# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVirtualCircuitsResult',
    'AwaitableGetVirtualCircuitsResult',
    'get_virtual_circuits',
    'get_virtual_circuits_output',
]

@pulumi.output_type
class GetVirtualCircuitsResult:
    """
    A collection of values returned by getVirtualCircuits.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, state=None, virtual_circuits=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if virtual_circuits and not isinstance(virtual_circuits, list):
            raise TypeError("Expected argument 'virtual_circuits' to be a list")
        pulumi.set(__self__, "virtual_circuits", virtual_circuits)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the virtual circuit.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVirtualCircuitsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The virtual circuit's current state. For information about the different states, see [FastConnect Overview](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnect.htm).
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="virtualCircuits")
    def virtual_circuits(self) -> Sequence['outputs.GetVirtualCircuitsVirtualCircuitResult']:
        """
        The list of virtual_circuits.
        """
        return pulumi.get(self, "virtual_circuits")


class AwaitableGetVirtualCircuitsResult(GetVirtualCircuitsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualCircuitsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            virtual_circuits=self.virtual_circuits)


def get_virtual_circuits(compartment_id: Optional[str] = None,
                         display_name: Optional[str] = None,
                         filters: Optional[Sequence[Union['GetVirtualCircuitsFilterArgs', 'GetVirtualCircuitsFilterArgsDict']]] = None,
                         state: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualCircuitsResult:
    """
    This data source provides the list of Virtual Circuits in Oracle Cloud Infrastructure Core service.

    Lists the virtual circuits in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_virtual_circuits = oci.Core.get_virtual_circuits(compartment_id=compartment_id,
        display_name=virtual_circuit_display_name,
        state=virtual_circuit_state)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getVirtualCircuits:getVirtualCircuits', __args__, opts=opts, typ=GetVirtualCircuitsResult).value

    return AwaitableGetVirtualCircuitsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        virtual_circuits=pulumi.get(__ret__, 'virtual_circuits'))


@_utilities.lift_output_func(get_virtual_circuits)
def get_virtual_circuits_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVirtualCircuitsFilterArgs', 'GetVirtualCircuitsFilterArgsDict']]]]] = None,
                                state: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVirtualCircuitsResult]:
    """
    This data source provides the list of Virtual Circuits in Oracle Cloud Infrastructure Core service.

    Lists the virtual circuits in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_virtual_circuits = oci.Core.get_virtual_circuits(compartment_id=compartment_id,
        display_name=virtual_circuit_display_name,
        state=virtual_circuit_state)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
    """
    ...
