# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExternalDatabaseConnectorArgs', 'ExternalDatabaseConnector']

@pulumi.input_type
class ExternalDatabaseConnectorArgs:
    def __init__(__self__, *,
                 connection_credentials: pulumi.Input['ExternalDatabaseConnectorConnectionCredentialsArgs'],
                 connection_string: pulumi.Input['ExternalDatabaseConnectorConnectionStringArgs'],
                 connector_agent_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 external_database_id: pulumi.Input[str],
                 connector_type: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a ExternalDatabaseConnector resource.
        :param pulumi.Input['ExternalDatabaseConnectorConnectionCredentialsArgs'] connection_credentials: (Updatable) Credentials used to connect to the database. Currently only the `DETAILS` type is supported for creating MACS connector crendentials.
        :param pulumi.Input['ExternalDatabaseConnectorConnectionStringArgs'] connection_string: (Updatable) The Oracle Database connection string.
        :param pulumi.Input[str] connector_agent_id: The ID of the agent used for the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails). The name does not have to be unique.
        :param pulumi.Input[str] external_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external database resource.
        :param pulumi.Input[str] connector_type: (Updatable) The type of connector used by the external database resource.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "connection_credentials", connection_credentials)
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "connector_agent_id", connector_agent_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "external_database_id", external_database_id)
        if connector_type is not None:
            pulumi.set(__self__, "connector_type", connector_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="connectionCredentials")
    def connection_credentials(self) -> pulumi.Input['ExternalDatabaseConnectorConnectionCredentialsArgs']:
        """
        (Updatable) Credentials used to connect to the database. Currently only the `DETAILS` type is supported for creating MACS connector crendentials.
        """
        return pulumi.get(self, "connection_credentials")

    @connection_credentials.setter
    def connection_credentials(self, value: pulumi.Input['ExternalDatabaseConnectorConnectionCredentialsArgs']):
        pulumi.set(self, "connection_credentials", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Input['ExternalDatabaseConnectorConnectionStringArgs']:
        """
        (Updatable) The Oracle Database connection string.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: pulumi.Input['ExternalDatabaseConnectorConnectionStringArgs']):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="connectorAgentId")
    def connector_agent_id(self) -> pulumi.Input[str]:
        """
        The ID of the agent used for the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        return pulumi.get(self, "connector_agent_id")

    @connector_agent_id.setter
    def connector_agent_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "connector_agent_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The user-friendly name for the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails). The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="externalDatabaseId")
    def external_database_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external database resource.
        """
        return pulumi.get(self, "external_database_id")

    @external_database_id.setter
    def external_database_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "external_database_id", value)

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of connector used by the external database resource.
        """
        return pulumi.get(self, "connector_type")

    @connector_type.setter
    def connector_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connector_type", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _ExternalDatabaseConnectorState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connection_credentials: Optional[pulumi.Input['ExternalDatabaseConnectorConnectionCredentialsArgs']] = None,
                 connection_status: Optional[pulumi.Input[str]] = None,
                 connection_string: Optional[pulumi.Input['ExternalDatabaseConnectorConnectionStringArgs']] = None,
                 connector_agent_id: Optional[pulumi.Input[str]] = None,
                 connector_type: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 external_database_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_connection_status_last_updated: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ExternalDatabaseConnector resources.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input['ExternalDatabaseConnectorConnectionCredentialsArgs'] connection_credentials: (Updatable) Credentials used to connect to the database. Currently only the `DETAILS` type is supported for creating MACS connector crendentials.
        :param pulumi.Input[str] connection_status: The status of connectivity to the external database.
        :param pulumi.Input['ExternalDatabaseConnectorConnectionStringArgs'] connection_string: (Updatable) The Oracle Database connection string.
        :param pulumi.Input[str] connector_agent_id: The ID of the agent used for the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        :param pulumi.Input[str] connector_type: (Updatable) The type of connector used by the external database resource.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails). The name does not have to be unique.
        :param pulumi.Input[str] external_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external database resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] state: The current lifecycle state of the external database connector resource.
        :param pulumi.Input[str] time_connection_status_last_updated: The date and time the `connectionStatus` of this external connector was last updated.
        :param pulumi.Input[str] time_created: The date and time the external connector was created.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_credentials is not None:
            pulumi.set(__self__, "connection_credentials", connection_credentials)
        if connection_status is not None:
            pulumi.set(__self__, "connection_status", connection_status)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if connector_agent_id is not None:
            pulumi.set(__self__, "connector_agent_id", connector_agent_id)
        if connector_type is not None:
            pulumi.set(__self__, "connector_type", connector_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if external_database_id is not None:
            pulumi.set(__self__, "external_database_id", external_database_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_connection_status_last_updated is not None:
            pulumi.set(__self__, "time_connection_status_last_updated", time_connection_status_last_updated)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectionCredentials")
    def connection_credentials(self) -> Optional[pulumi.Input['ExternalDatabaseConnectorConnectionCredentialsArgs']]:
        """
        (Updatable) Credentials used to connect to the database. Currently only the `DETAILS` type is supported for creating MACS connector crendentials.
        """
        return pulumi.get(self, "connection_credentials")

    @connection_credentials.setter
    def connection_credentials(self, value: Optional[pulumi.Input['ExternalDatabaseConnectorConnectionCredentialsArgs']]):
        pulumi.set(self, "connection_credentials", value)

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of connectivity to the external database.
        """
        return pulumi.get(self, "connection_status")

    @connection_status.setter
    def connection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_status", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input['ExternalDatabaseConnectorConnectionStringArgs']]:
        """
        (Updatable) The Oracle Database connection string.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input['ExternalDatabaseConnectorConnectionStringArgs']]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="connectorAgentId")
    def connector_agent_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the agent used for the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        return pulumi.get(self, "connector_agent_id")

    @connector_agent_id.setter
    def connector_agent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connector_agent_id", value)

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of connector used by the external database resource.
        """
        return pulumi.get(self, "connector_type")

    @connector_type.setter
    def connector_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connector_type", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The user-friendly name for the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails). The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="externalDatabaseId")
    def external_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external database resource.
        """
        return pulumi.get(self, "external_database_id")

    @external_database_id.setter
    def external_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_database_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifecycle state of the external database connector resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeConnectionStatusLastUpdated")
    def time_connection_status_last_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the `connectionStatus` of this external connector was last updated.
        """
        return pulumi.get(self, "time_connection_status_last_updated")

    @time_connection_status_last_updated.setter
    def time_connection_status_last_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_connection_status_last_updated", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the external connector was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class ExternalDatabaseConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_credentials: Optional[pulumi.Input[Union['ExternalDatabaseConnectorConnectionCredentialsArgs', 'ExternalDatabaseConnectorConnectionCredentialsArgsDict']]] = None,
                 connection_string: Optional[pulumi.Input[Union['ExternalDatabaseConnectorConnectionStringArgs', 'ExternalDatabaseConnectorConnectionStringArgsDict']]] = None,
                 connector_agent_id: Optional[pulumi.Input[str]] = None,
                 connector_type: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 external_database_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        """
        This resource provides the External Database Connector resource in Oracle Cloud Infrastructure Database service.

        Creates a new external database connector.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_external_database_connector = oci.database.ExternalDatabaseConnector("test_external_database_connector",
            connection_credentials={
                "credential_name": external_database_connector_connection_credentials_credential_name,
                "credential_type": external_database_connector_connection_credentials_credential_type,
                "password": external_database_connector_connection_credentials_password,
                "role": external_database_connector_connection_credentials_role,
                "ssl_secret_id": test_secret["id"],
                "username": external_database_connector_connection_credentials_username,
            },
            connection_string={
                "hostname": external_database_connector_connection_string_hostname,
                "port": external_database_connector_connection_string_port,
                "protocol": external_database_connector_connection_string_protocol,
                "service": external_database_connector_connection_string_service,
            },
            connector_agent_id=test_connector_agent["id"],
            display_name=external_database_connector_display_name,
            external_database_id=test_database["id"],
            connector_type=external_database_connector_connector_type,
            defined_tags=external_database_connector_defined_tags,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        ExternalDatabaseConnectors can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/externalDatabaseConnector:ExternalDatabaseConnector test_external_database_connector "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ExternalDatabaseConnectorConnectionCredentialsArgs', 'ExternalDatabaseConnectorConnectionCredentialsArgsDict']] connection_credentials: (Updatable) Credentials used to connect to the database. Currently only the `DETAILS` type is supported for creating MACS connector crendentials.
        :param pulumi.Input[Union['ExternalDatabaseConnectorConnectionStringArgs', 'ExternalDatabaseConnectorConnectionStringArgsDict']] connection_string: (Updatable) The Oracle Database connection string.
        :param pulumi.Input[str] connector_agent_id: The ID of the agent used for the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        :param pulumi.Input[str] connector_type: (Updatable) The type of connector used by the external database resource.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails). The name does not have to be unique.
        :param pulumi.Input[str] external_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external database resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalDatabaseConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the External Database Connector resource in Oracle Cloud Infrastructure Database service.

        Creates a new external database connector.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_external_database_connector = oci.database.ExternalDatabaseConnector("test_external_database_connector",
            connection_credentials={
                "credential_name": external_database_connector_connection_credentials_credential_name,
                "credential_type": external_database_connector_connection_credentials_credential_type,
                "password": external_database_connector_connection_credentials_password,
                "role": external_database_connector_connection_credentials_role,
                "ssl_secret_id": test_secret["id"],
                "username": external_database_connector_connection_credentials_username,
            },
            connection_string={
                "hostname": external_database_connector_connection_string_hostname,
                "port": external_database_connector_connection_string_port,
                "protocol": external_database_connector_connection_string_protocol,
                "service": external_database_connector_connection_string_service,
            },
            connector_agent_id=test_connector_agent["id"],
            display_name=external_database_connector_display_name,
            external_database_id=test_database["id"],
            connector_type=external_database_connector_connector_type,
            defined_tags=external_database_connector_defined_tags,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        ExternalDatabaseConnectors can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/externalDatabaseConnector:ExternalDatabaseConnector test_external_database_connector "id"
        ```

        :param str resource_name: The name of the resource.
        :param ExternalDatabaseConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalDatabaseConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_credentials: Optional[pulumi.Input[Union['ExternalDatabaseConnectorConnectionCredentialsArgs', 'ExternalDatabaseConnectorConnectionCredentialsArgsDict']]] = None,
                 connection_string: Optional[pulumi.Input[Union['ExternalDatabaseConnectorConnectionStringArgs', 'ExternalDatabaseConnectorConnectionStringArgsDict']]] = None,
                 connector_agent_id: Optional[pulumi.Input[str]] = None,
                 connector_type: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 external_database_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalDatabaseConnectorArgs.__new__(ExternalDatabaseConnectorArgs)

            if connection_credentials is None and not opts.urn:
                raise TypeError("Missing required property 'connection_credentials'")
            __props__.__dict__["connection_credentials"] = connection_credentials
            if connection_string is None and not opts.urn:
                raise TypeError("Missing required property 'connection_string'")
            __props__.__dict__["connection_string"] = connection_string
            if connector_agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'connector_agent_id'")
            __props__.__dict__["connector_agent_id"] = connector_agent_id
            __props__.__dict__["connector_type"] = connector_type
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if external_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_database_id'")
            __props__.__dict__["external_database_id"] = external_database_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["connection_status"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_connection_status_last_updated"] = None
            __props__.__dict__["time_created"] = None
        super(ExternalDatabaseConnector, __self__).__init__(
            'oci:Database/externalDatabaseConnector:ExternalDatabaseConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            connection_credentials: Optional[pulumi.Input[Union['ExternalDatabaseConnectorConnectionCredentialsArgs', 'ExternalDatabaseConnectorConnectionCredentialsArgsDict']]] = None,
            connection_status: Optional[pulumi.Input[str]] = None,
            connection_string: Optional[pulumi.Input[Union['ExternalDatabaseConnectorConnectionStringArgs', 'ExternalDatabaseConnectorConnectionStringArgsDict']]] = None,
            connector_agent_id: Optional[pulumi.Input[str]] = None,
            connector_type: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            external_database_id: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_connection_status_last_updated: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'ExternalDatabaseConnector':
        """
        Get an existing ExternalDatabaseConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Union['ExternalDatabaseConnectorConnectionCredentialsArgs', 'ExternalDatabaseConnectorConnectionCredentialsArgsDict']] connection_credentials: (Updatable) Credentials used to connect to the database. Currently only the `DETAILS` type is supported for creating MACS connector crendentials.
        :param pulumi.Input[str] connection_status: The status of connectivity to the external database.
        :param pulumi.Input[Union['ExternalDatabaseConnectorConnectionStringArgs', 'ExternalDatabaseConnectorConnectionStringArgsDict']] connection_string: (Updatable) The Oracle Database connection string.
        :param pulumi.Input[str] connector_agent_id: The ID of the agent used for the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        :param pulumi.Input[str] connector_type: (Updatable) The type of connector used by the external database resource.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails). The name does not have to be unique.
        :param pulumi.Input[str] external_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external database resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] state: The current lifecycle state of the external database connector resource.
        :param pulumi.Input[str] time_connection_status_last_updated: The date and time the `connectionStatus` of this external connector was last updated.
        :param pulumi.Input[str] time_created: The date and time the external connector was created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalDatabaseConnectorState.__new__(_ExternalDatabaseConnectorState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connection_credentials"] = connection_credentials
        __props__.__dict__["connection_status"] = connection_status
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["connector_agent_id"] = connector_agent_id
        __props__.__dict__["connector_type"] = connector_type
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["external_database_id"] = external_database_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["state"] = state
        __props__.__dict__["time_connection_status_last_updated"] = time_connection_status_last_updated
        __props__.__dict__["time_created"] = time_created
        return ExternalDatabaseConnector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionCredentials")
    def connection_credentials(self) -> pulumi.Output['outputs.ExternalDatabaseConnectorConnectionCredentials']:
        """
        (Updatable) Credentials used to connect to the database. Currently only the `DETAILS` type is supported for creating MACS connector crendentials.
        """
        return pulumi.get(self, "connection_credentials")

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> pulumi.Output[str]:
        """
        The status of connectivity to the external database.
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output['outputs.ExternalDatabaseConnectorConnectionString']:
        """
        (Updatable) The Oracle Database connection string.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="connectorAgentId")
    def connector_agent_id(self) -> pulumi.Output[str]:
        """
        The ID of the agent used for the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        return pulumi.get(self, "connector_agent_id")

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The type of connector used by the external database resource.
        """
        return pulumi.get(self, "connector_type")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The user-friendly name for the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails). The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalDatabaseId")
    def external_database_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external database resource.
        """
        return pulumi.get(self, "external_database_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of the external database connector resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeConnectionStatusLastUpdated")
    def time_connection_status_last_updated(self) -> pulumi.Output[str]:
        """
        The date and time the `connectionStatus` of this external connector was last updated.
        """
        return pulumi.get(self, "time_connection_status_last_updated")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the external connector was created.
        """
        return pulumi.get(self, "time_created")

