# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDbNodesResult',
    'AwaitableGetDbNodesResult',
    'get_db_nodes',
    'get_db_nodes_output',
]

@pulumi.output_type
class GetDbNodesResult:
    """
    A collection of values returned by getDbNodes.
    """
    def __init__(__self__, compartment_id=None, db_nodes=None, db_server_id=None, db_system_id=None, filters=None, id=None, state=None, vm_cluster_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_nodes and not isinstance(db_nodes, list):
            raise TypeError("Expected argument 'db_nodes' to be a list")
        pulumi.set(__self__, "db_nodes", db_nodes)
        if db_server_id and not isinstance(db_server_id, str):
            raise TypeError("Expected argument 'db_server_id' to be a str")
        pulumi.set(__self__, "db_server_id", db_server_id)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vm_cluster_id and not isinstance(vm_cluster_id, str):
            raise TypeError("Expected argument 'vm_cluster_id' to be a str")
        pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbNodes")
    def db_nodes(self) -> Sequence['outputs.GetDbNodesDbNodeResult']:
        """
        The list of db_nodes.
        """
        return pulumi.get(self, "db_nodes")

    @property
    @pulumi.getter(name="dbServerId")
    def db_server_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exacc Db server associated with the database node.
        """
        return pulumi.get(self, "db_server_id")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDbNodesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the database node.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> Optional[str]:
        return pulumi.get(self, "vm_cluster_id")


class AwaitableGetDbNodesResult(GetDbNodesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbNodesResult(
            compartment_id=self.compartment_id,
            db_nodes=self.db_nodes,
            db_server_id=self.db_server_id,
            db_system_id=self.db_system_id,
            filters=self.filters,
            id=self.id,
            state=self.state,
            vm_cluster_id=self.vm_cluster_id)


def get_db_nodes(compartment_id: Optional[str] = None,
                 db_server_id: Optional[str] = None,
                 db_system_id: Optional[str] = None,
                 filters: Optional[Sequence[Union['GetDbNodesFilterArgs', 'GetDbNodesFilterArgsDict']]] = None,
                 state: Optional[str] = None,
                 vm_cluster_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbNodesResult:
    """
    This data source provides the list of Db Nodes in Oracle Cloud Infrastructure Database service.

    Lists the database nodes in the specified compartment. A database node is a server running database software. In addition to the other required parameters, either '--db-system-id' or '--vm-cluster-id' also must be provided, depending on the service being accessed.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_nodes = oci.Database.get_db_nodes(compartment_id=compartment_id,
        db_server_id=test_db_server["id"],
        db_system_id=test_db_system["id"],
        state=db_node_state,
        vm_cluster_id=test_vm_cluster["id"])
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str db_server_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exacc Db server.
    :param str db_system_id: The DB system [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). If provided, filters the results to the set of database versions which are supported for the DB system.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    :param str vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['dbServerId'] = db_server_id
    __args__['dbSystemId'] = db_system_id
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['vmClusterId'] = vm_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDbNodes:getDbNodes', __args__, opts=opts, typ=GetDbNodesResult).value

    return AwaitableGetDbNodesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_nodes=pulumi.get(__ret__, 'db_nodes'),
        db_server_id=pulumi.get(__ret__, 'db_server_id'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        vm_cluster_id=pulumi.get(__ret__, 'vm_cluster_id'))


@_utilities.lift_output_func(get_db_nodes)
def get_db_nodes_output(compartment_id: Optional[pulumi.Input[str]] = None,
                        db_server_id: Optional[pulumi.Input[Optional[str]]] = None,
                        db_system_id: Optional[pulumi.Input[Optional[str]]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDbNodesFilterArgs', 'GetDbNodesFilterArgsDict']]]]] = None,
                        state: Optional[pulumi.Input[Optional[str]]] = None,
                        vm_cluster_id: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbNodesResult]:
    """
    This data source provides the list of Db Nodes in Oracle Cloud Infrastructure Database service.

    Lists the database nodes in the specified compartment. A database node is a server running database software. In addition to the other required parameters, either '--db-system-id' or '--vm-cluster-id' also must be provided, depending on the service being accessed.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_nodes = oci.Database.get_db_nodes(compartment_id=compartment_id,
        db_server_id=test_db_server["id"],
        db_system_id=test_db_system["id"],
        state=db_node_state,
        vm_cluster_id=test_vm_cluster["id"])
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str db_server_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exacc Db server.
    :param str db_system_id: The DB system [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). If provided, filters the results to the set of database versions which are supported for the DB system.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    :param str vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
    """
    ...
