# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceImportRequestArgs', 'WorkspaceImportRequest']

@pulumi.input_type
class WorkspaceImportRequestArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 file_name: pulumi.Input[str],
                 workspace_id: pulumi.Input[str],
                 are_data_asset_references_included: Optional[pulumi.Input[bool]] = None,
                 import_conflict_resolution: Optional[pulumi.Input['WorkspaceImportRequestImportConflictResolutionArgs']] = None,
                 object_key_for_import: Optional[pulumi.Input[str]] = None,
                 object_storage_region: Optional[pulumi.Input[str]] = None,
                 object_storage_tenancy_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a WorkspaceImportRequest resource.
        :param pulumi.Input[str] bucket: Name of the Object Storage bucket where the object will be imported from.
        :param pulumi.Input[str] file_name: Name of the zip file to be imported.
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[bool] are_data_asset_references_included: This field controls if the data asset references will be included during import.
        :param pulumi.Input['WorkspaceImportRequestImportConflictResolutionArgs'] import_conflict_resolution: Import Objects Conflict resolution.
        :param pulumi.Input[str] object_key_for_import: Key of the object inside which all the objects will be imported
        :param pulumi.Input[str] object_storage_region: Region of the object storage (if using object storage of different region)
        :param pulumi.Input[str] object_storage_tenancy_id: Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "file_name", file_name)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if are_data_asset_references_included is not None:
            pulumi.set(__self__, "are_data_asset_references_included", are_data_asset_references_included)
        if import_conflict_resolution is not None:
            pulumi.set(__self__, "import_conflict_resolution", import_conflict_resolution)
        if object_key_for_import is not None:
            pulumi.set(__self__, "object_key_for_import", object_key_for_import)
        if object_storage_region is not None:
            pulumi.set(__self__, "object_storage_region", object_storage_region)
        if object_storage_tenancy_id is not None:
            pulumi.set(__self__, "object_storage_tenancy_id", object_storage_tenancy_id)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Name of the Object Storage bucket where the object will be imported from.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> pulumi.Input[str]:
        """
        Name of the zip file to be imported.
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_name", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)

    @property
    @pulumi.getter(name="areDataAssetReferencesIncluded")
    def are_data_asset_references_included(self) -> Optional[pulumi.Input[bool]]:
        """
        This field controls if the data asset references will be included during import.
        """
        return pulumi.get(self, "are_data_asset_references_included")

    @are_data_asset_references_included.setter
    def are_data_asset_references_included(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "are_data_asset_references_included", value)

    @property
    @pulumi.getter(name="importConflictResolution")
    def import_conflict_resolution(self) -> Optional[pulumi.Input['WorkspaceImportRequestImportConflictResolutionArgs']]:
        """
        Import Objects Conflict resolution.
        """
        return pulumi.get(self, "import_conflict_resolution")

    @import_conflict_resolution.setter
    def import_conflict_resolution(self, value: Optional[pulumi.Input['WorkspaceImportRequestImportConflictResolutionArgs']]):
        pulumi.set(self, "import_conflict_resolution", value)

    @property
    @pulumi.getter(name="objectKeyForImport")
    def object_key_for_import(self) -> Optional[pulumi.Input[str]]:
        """
        Key of the object inside which all the objects will be imported
        """
        return pulumi.get(self, "object_key_for_import")

    @object_key_for_import.setter
    def object_key_for_import(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_key_for_import", value)

    @property
    @pulumi.getter(name="objectStorageRegion")
    def object_storage_region(self) -> Optional[pulumi.Input[str]]:
        """
        Region of the object storage (if using object storage of different region)
        """
        return pulumi.get(self, "object_storage_region")

    @object_storage_region.setter
    def object_storage_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_storage_region", value)

    @property
    @pulumi.getter(name="objectStorageTenancyId")
    def object_storage_tenancy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)
        """
        return pulumi.get(self, "object_storage_tenancy_id")

    @object_storage_tenancy_id.setter
    def object_storage_tenancy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_storage_tenancy_id", value)


@pulumi.input_type
class _WorkspaceImportRequestState:
    def __init__(__self__, *,
                 are_data_asset_references_included: Optional[pulumi.Input[bool]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 error_messages: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 file_name: Optional[pulumi.Input[str]] = None,
                 import_conflict_resolution: Optional[pulumi.Input['WorkspaceImportRequestImportConflictResolutionArgs']] = None,
                 imported_objects: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceImportRequestImportedObjectArgs']]]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_key_for_import: Optional[pulumi.Input[str]] = None,
                 object_storage_region: Optional[pulumi.Input[str]] = None,
                 object_storage_tenancy_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 time_ended_in_millis: Optional[pulumi.Input[str]] = None,
                 time_started_in_millis: Optional[pulumi.Input[str]] = None,
                 total_imported_object_count: Optional[pulumi.Input[int]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceImportRequest resources.
        :param pulumi.Input[bool] are_data_asset_references_included: This field controls if the data asset references will be included during import.
        :param pulumi.Input[str] bucket: Name of the Object Storage bucket where the object will be imported from.
        :param pulumi.Input[str] created_by: Name of the user who initiated import request.
        :param pulumi.Input[Mapping[str, Any]] error_messages: Contains key of the error
        :param pulumi.Input[str] file_name: Name of the zip file to be imported.
        :param pulumi.Input['WorkspaceImportRequestImportConflictResolutionArgs'] import_conflict_resolution: Import Objects Conflict resolution.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceImportRequestImportedObjectArgs']]] imported_objects: The array of imported object details.
        :param pulumi.Input[str] key: Import object request key
        :param pulumi.Input[str] name: Name of the import request.
        :param pulumi.Input[str] object_key_for_import: Key of the object inside which all the objects will be imported
        :param pulumi.Input[str] object_storage_region: Region of the object storage (if using object storage of different region)
        :param pulumi.Input[str] object_storage_tenancy_id: Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)
        :param pulumi.Input[str] status: Import Objects request status.
        :param pulumi.Input[str] time_ended_in_millis: Time at which the request was completely processed.
        :param pulumi.Input[str] time_started_in_millis: Time at which the request started getting processed.
        :param pulumi.Input[int] total_imported_object_count: Number of objects that are imported.
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if are_data_asset_references_included is not None:
            pulumi.set(__self__, "are_data_asset_references_included", are_data_asset_references_included)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if error_messages is not None:
            pulumi.set(__self__, "error_messages", error_messages)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if import_conflict_resolution is not None:
            pulumi.set(__self__, "import_conflict_resolution", import_conflict_resolution)
        if imported_objects is not None:
            pulumi.set(__self__, "imported_objects", imported_objects)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_key_for_import is not None:
            pulumi.set(__self__, "object_key_for_import", object_key_for_import)
        if object_storage_region is not None:
            pulumi.set(__self__, "object_storage_region", object_storage_region)
        if object_storage_tenancy_id is not None:
            pulumi.set(__self__, "object_storage_tenancy_id", object_storage_tenancy_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if time_ended_in_millis is not None:
            pulumi.set(__self__, "time_ended_in_millis", time_ended_in_millis)
        if time_started_in_millis is not None:
            pulumi.set(__self__, "time_started_in_millis", time_started_in_millis)
        if total_imported_object_count is not None:
            pulumi.set(__self__, "total_imported_object_count", total_imported_object_count)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="areDataAssetReferencesIncluded")
    def are_data_asset_references_included(self) -> Optional[pulumi.Input[bool]]:
        """
        This field controls if the data asset references will be included during import.
        """
        return pulumi.get(self, "are_data_asset_references_included")

    @are_data_asset_references_included.setter
    def are_data_asset_references_included(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "are_data_asset_references_included", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Object Storage bucket where the object will be imported from.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the user who initiated import request.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="errorMessages")
    def error_messages(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Contains key of the error
        """
        return pulumi.get(self, "error_messages")

    @error_messages.setter
    def error_messages(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "error_messages", value)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the zip file to be imported.
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_name", value)

    @property
    @pulumi.getter(name="importConflictResolution")
    def import_conflict_resolution(self) -> Optional[pulumi.Input['WorkspaceImportRequestImportConflictResolutionArgs']]:
        """
        Import Objects Conflict resolution.
        """
        return pulumi.get(self, "import_conflict_resolution")

    @import_conflict_resolution.setter
    def import_conflict_resolution(self, value: Optional[pulumi.Input['WorkspaceImportRequestImportConflictResolutionArgs']]):
        pulumi.set(self, "import_conflict_resolution", value)

    @property
    @pulumi.getter(name="importedObjects")
    def imported_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceImportRequestImportedObjectArgs']]]]:
        """
        The array of imported object details.
        """
        return pulumi.get(self, "imported_objects")

    @imported_objects.setter
    def imported_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceImportRequestImportedObjectArgs']]]]):
        pulumi.set(self, "imported_objects", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Import object request key
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the import request.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectKeyForImport")
    def object_key_for_import(self) -> Optional[pulumi.Input[str]]:
        """
        Key of the object inside which all the objects will be imported
        """
        return pulumi.get(self, "object_key_for_import")

    @object_key_for_import.setter
    def object_key_for_import(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_key_for_import", value)

    @property
    @pulumi.getter(name="objectStorageRegion")
    def object_storage_region(self) -> Optional[pulumi.Input[str]]:
        """
        Region of the object storage (if using object storage of different region)
        """
        return pulumi.get(self, "object_storage_region")

    @object_storage_region.setter
    def object_storage_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_storage_region", value)

    @property
    @pulumi.getter(name="objectStorageTenancyId")
    def object_storage_tenancy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)
        """
        return pulumi.get(self, "object_storage_tenancy_id")

    @object_storage_tenancy_id.setter
    def object_storage_tenancy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_storage_tenancy_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Import Objects request status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="timeEndedInMillis")
    def time_ended_in_millis(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which the request was completely processed.
        """
        return pulumi.get(self, "time_ended_in_millis")

    @time_ended_in_millis.setter
    def time_ended_in_millis(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_ended_in_millis", value)

    @property
    @pulumi.getter(name="timeStartedInMillis")
    def time_started_in_millis(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which the request started getting processed.
        """
        return pulumi.get(self, "time_started_in_millis")

    @time_started_in_millis.setter
    def time_started_in_millis(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_started_in_millis", value)

    @property
    @pulumi.getter(name="totalImportedObjectCount")
    def total_imported_object_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of objects that are imported.
        """
        return pulumi.get(self, "total_imported_object_count")

    @total_imported_object_count.setter
    def total_imported_object_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_imported_object_count", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[str]]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_id", value)


class WorkspaceImportRequest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 are_data_asset_references_included: Optional[pulumi.Input[bool]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 file_name: Optional[pulumi.Input[str]] = None,
                 import_conflict_resolution: Optional[pulumi.Input[Union['WorkspaceImportRequestImportConflictResolutionArgs', 'WorkspaceImportRequestImportConflictResolutionArgsDict']]] = None,
                 object_key_for_import: Optional[pulumi.Input[str]] = None,
                 object_storage_region: Optional[pulumi.Input[str]] = None,
                 object_storage_tenancy_id: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Workspace Import Request resource in Oracle Cloud Infrastructure Data Integration service.

        Import Metadata Object

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_workspace_import_request = oci.data_integration.WorkspaceImportRequest("test_workspace_import_request",
            bucket=workspace_import_request_bucket,
            file_name=workspace_import_request_file_name,
            workspace_id=test_workspace["id"],
            are_data_asset_references_included=workspace_import_request_are_data_asset_references_included,
            import_conflict_resolution={
                "import_conflict_resolution_type": workspace_import_request_import_conflict_resolution_import_conflict_resolution_type,
                "duplicate_prefix": workspace_import_request_import_conflict_resolution_duplicate_prefix,
                "duplicate_suffix": workspace_import_request_import_conflict_resolution_duplicate_suffix,
            },
            object_key_for_import=workspace_import_request_object_key_for_import,
            object_storage_region=workspace_import_request_object_storage_region,
            object_storage_tenancy_id=test_tenancy["id"])
        ```

        ## Import

        WorkspaceImportRequests can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspaceImportRequest:WorkspaceImportRequest test_workspace_import_request "workspaces/{workspaceId}/importRequests/{importRequestKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] are_data_asset_references_included: This field controls if the data asset references will be included during import.
        :param pulumi.Input[str] bucket: Name of the Object Storage bucket where the object will be imported from.
        :param pulumi.Input[str] file_name: Name of the zip file to be imported.
        :param pulumi.Input[Union['WorkspaceImportRequestImportConflictResolutionArgs', 'WorkspaceImportRequestImportConflictResolutionArgsDict']] import_conflict_resolution: Import Objects Conflict resolution.
        :param pulumi.Input[str] object_key_for_import: Key of the object inside which all the objects will be imported
        :param pulumi.Input[str] object_storage_region: Region of the object storage (if using object storage of different region)
        :param pulumi.Input[str] object_storage_tenancy_id: Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceImportRequestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Workspace Import Request resource in Oracle Cloud Infrastructure Data Integration service.

        Import Metadata Object

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_workspace_import_request = oci.data_integration.WorkspaceImportRequest("test_workspace_import_request",
            bucket=workspace_import_request_bucket,
            file_name=workspace_import_request_file_name,
            workspace_id=test_workspace["id"],
            are_data_asset_references_included=workspace_import_request_are_data_asset_references_included,
            import_conflict_resolution={
                "import_conflict_resolution_type": workspace_import_request_import_conflict_resolution_import_conflict_resolution_type,
                "duplicate_prefix": workspace_import_request_import_conflict_resolution_duplicate_prefix,
                "duplicate_suffix": workspace_import_request_import_conflict_resolution_duplicate_suffix,
            },
            object_key_for_import=workspace_import_request_object_key_for_import,
            object_storage_region=workspace_import_request_object_storage_region,
            object_storage_tenancy_id=test_tenancy["id"])
        ```

        ## Import

        WorkspaceImportRequests can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspaceImportRequest:WorkspaceImportRequest test_workspace_import_request "workspaces/{workspaceId}/importRequests/{importRequestKey}"
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceImportRequestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceImportRequestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 are_data_asset_references_included: Optional[pulumi.Input[bool]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 file_name: Optional[pulumi.Input[str]] = None,
                 import_conflict_resolution: Optional[pulumi.Input[Union['WorkspaceImportRequestImportConflictResolutionArgs', 'WorkspaceImportRequestImportConflictResolutionArgsDict']]] = None,
                 object_key_for_import: Optional[pulumi.Input[str]] = None,
                 object_storage_region: Optional[pulumi.Input[str]] = None,
                 object_storage_tenancy_id: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceImportRequestArgs.__new__(WorkspaceImportRequestArgs)

            __props__.__dict__["are_data_asset_references_included"] = are_data_asset_references_included
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            if file_name is None and not opts.urn:
                raise TypeError("Missing required property 'file_name'")
            __props__.__dict__["file_name"] = file_name
            __props__.__dict__["import_conflict_resolution"] = import_conflict_resolution
            __props__.__dict__["object_key_for_import"] = object_key_for_import
            __props__.__dict__["object_storage_region"] = object_storage_region
            __props__.__dict__["object_storage_tenancy_id"] = object_storage_tenancy_id
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["created_by"] = None
            __props__.__dict__["error_messages"] = None
            __props__.__dict__["imported_objects"] = None
            __props__.__dict__["key"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["time_ended_in_millis"] = None
            __props__.__dict__["time_started_in_millis"] = None
            __props__.__dict__["total_imported_object_count"] = None
        super(WorkspaceImportRequest, __self__).__init__(
            'oci:DataIntegration/workspaceImportRequest:WorkspaceImportRequest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            are_data_asset_references_included: Optional[pulumi.Input[bool]] = None,
            bucket: Optional[pulumi.Input[str]] = None,
            created_by: Optional[pulumi.Input[str]] = None,
            error_messages: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            file_name: Optional[pulumi.Input[str]] = None,
            import_conflict_resolution: Optional[pulumi.Input[Union['WorkspaceImportRequestImportConflictResolutionArgs', 'WorkspaceImportRequestImportConflictResolutionArgsDict']]] = None,
            imported_objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceImportRequestImportedObjectArgs', 'WorkspaceImportRequestImportedObjectArgsDict']]]]] = None,
            key: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            object_key_for_import: Optional[pulumi.Input[str]] = None,
            object_storage_region: Optional[pulumi.Input[str]] = None,
            object_storage_tenancy_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            time_ended_in_millis: Optional[pulumi.Input[str]] = None,
            time_started_in_millis: Optional[pulumi.Input[str]] = None,
            total_imported_object_count: Optional[pulumi.Input[int]] = None,
            workspace_id: Optional[pulumi.Input[str]] = None) -> 'WorkspaceImportRequest':
        """
        Get an existing WorkspaceImportRequest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] are_data_asset_references_included: This field controls if the data asset references will be included during import.
        :param pulumi.Input[str] bucket: Name of the Object Storage bucket where the object will be imported from.
        :param pulumi.Input[str] created_by: Name of the user who initiated import request.
        :param pulumi.Input[Mapping[str, Any]] error_messages: Contains key of the error
        :param pulumi.Input[str] file_name: Name of the zip file to be imported.
        :param pulumi.Input[Union['WorkspaceImportRequestImportConflictResolutionArgs', 'WorkspaceImportRequestImportConflictResolutionArgsDict']] import_conflict_resolution: Import Objects Conflict resolution.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceImportRequestImportedObjectArgs', 'WorkspaceImportRequestImportedObjectArgsDict']]]] imported_objects: The array of imported object details.
        :param pulumi.Input[str] key: Import object request key
        :param pulumi.Input[str] name: Name of the import request.
        :param pulumi.Input[str] object_key_for_import: Key of the object inside which all the objects will be imported
        :param pulumi.Input[str] object_storage_region: Region of the object storage (if using object storage of different region)
        :param pulumi.Input[str] object_storage_tenancy_id: Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)
        :param pulumi.Input[str] status: Import Objects request status.
        :param pulumi.Input[str] time_ended_in_millis: Time at which the request was completely processed.
        :param pulumi.Input[str] time_started_in_millis: Time at which the request started getting processed.
        :param pulumi.Input[int] total_imported_object_count: Number of objects that are imported.
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceImportRequestState.__new__(_WorkspaceImportRequestState)

        __props__.__dict__["are_data_asset_references_included"] = are_data_asset_references_included
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["error_messages"] = error_messages
        __props__.__dict__["file_name"] = file_name
        __props__.__dict__["import_conflict_resolution"] = import_conflict_resolution
        __props__.__dict__["imported_objects"] = imported_objects
        __props__.__dict__["key"] = key
        __props__.__dict__["name"] = name
        __props__.__dict__["object_key_for_import"] = object_key_for_import
        __props__.__dict__["object_storage_region"] = object_storage_region
        __props__.__dict__["object_storage_tenancy_id"] = object_storage_tenancy_id
        __props__.__dict__["status"] = status
        __props__.__dict__["time_ended_in_millis"] = time_ended_in_millis
        __props__.__dict__["time_started_in_millis"] = time_started_in_millis
        __props__.__dict__["total_imported_object_count"] = total_imported_object_count
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceImportRequest(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="areDataAssetReferencesIncluded")
    def are_data_asset_references_included(self) -> pulumi.Output[bool]:
        """
        This field controls if the data asset references will be included during import.
        """
        return pulumi.get(self, "are_data_asset_references_included")

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[str]:
        """
        Name of the Object Storage bucket where the object will be imported from.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        """
        Name of the user who initiated import request.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="errorMessages")
    def error_messages(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Contains key of the error
        """
        return pulumi.get(self, "error_messages")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> pulumi.Output[str]:
        """
        Name of the zip file to be imported.
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter(name="importConflictResolution")
    def import_conflict_resolution(self) -> pulumi.Output['outputs.WorkspaceImportRequestImportConflictResolution']:
        """
        Import Objects Conflict resolution.
        """
        return pulumi.get(self, "import_conflict_resolution")

    @property
    @pulumi.getter(name="importedObjects")
    def imported_objects(self) -> pulumi.Output[Sequence['outputs.WorkspaceImportRequestImportedObject']]:
        """
        The array of imported object details.
        """
        return pulumi.get(self, "imported_objects")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        Import object request key
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the import request.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectKeyForImport")
    def object_key_for_import(self) -> pulumi.Output[str]:
        """
        Key of the object inside which all the objects will be imported
        """
        return pulumi.get(self, "object_key_for_import")

    @property
    @pulumi.getter(name="objectStorageRegion")
    def object_storage_region(self) -> pulumi.Output[str]:
        """
        Region of the object storage (if using object storage of different region)
        """
        return pulumi.get(self, "object_storage_region")

    @property
    @pulumi.getter(name="objectStorageTenancyId")
    def object_storage_tenancy_id(self) -> pulumi.Output[str]:
        """
        Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)
        """
        return pulumi.get(self, "object_storage_tenancy_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Import Objects request status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeEndedInMillis")
    def time_ended_in_millis(self) -> pulumi.Output[str]:
        """
        Time at which the request was completely processed.
        """
        return pulumi.get(self, "time_ended_in_millis")

    @property
    @pulumi.getter(name="timeStartedInMillis")
    def time_started_in_millis(self) -> pulumi.Output[str]:
        """
        Time at which the request started getting processed.
        """
        return pulumi.get(self, "time_started_in_millis")

    @property
    @pulumi.getter(name="totalImportedObjectCount")
    def total_imported_object_count(self) -> pulumi.Output[int]:
        """
        Number of objects that are imported.
        """
        return pulumi.get(self, "total_imported_object_count")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[str]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

