# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAlertPolicyResult',
    'AwaitableGetAlertPolicyResult',
    'get_alert_policy',
    'get_alert_policy_output',
]

@pulumi.output_type
class GetAlertPolicyResult:
    """
    A collection of values returned by getAlertPolicy.
    """
    def __init__(__self__, alert_policy_id=None, alert_policy_rule_details=None, alert_policy_type=None, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, is_user_defined=None, lifecycle_details=None, severity=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if alert_policy_id and not isinstance(alert_policy_id, str):
            raise TypeError("Expected argument 'alert_policy_id' to be a str")
        pulumi.set(__self__, "alert_policy_id", alert_policy_id)
        if alert_policy_rule_details and not isinstance(alert_policy_rule_details, list):
            raise TypeError("Expected argument 'alert_policy_rule_details' to be a list")
        pulumi.set(__self__, "alert_policy_rule_details", alert_policy_rule_details)
        if alert_policy_type and not isinstance(alert_policy_type, str):
            raise TypeError("Expected argument 'alert_policy_type' to be a str")
        pulumi.set(__self__, "alert_policy_type", alert_policy_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_user_defined and not isinstance(is_user_defined, bool):
            raise TypeError("Expected argument 'is_user_defined' to be a bool")
        pulumi.set(__self__, "is_user_defined", is_user_defined)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if severity and not isinstance(severity, str):
            raise TypeError("Expected argument 'severity' to be a str")
        pulumi.set(__self__, "severity", severity)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="alertPolicyId")
    def alert_policy_id(self) -> str:
        return pulumi.get(self, "alert_policy_id")

    @property
    @pulumi.getter(name="alertPolicyRuleDetails")
    def alert_policy_rule_details(self) -> Sequence['outputs.GetAlertPolicyAlertPolicyRuleDetailResult']:
        return pulumi.get(self, "alert_policy_rule_details")

    @property
    @pulumi.getter(name="alertPolicyType")
    def alert_policy_type(self) -> str:
        """
        Indicates the Data Safe feature to which the alert policy belongs.
        """
        return pulumi.get(self, "alert_policy_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the alert policy.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the alert policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the alert policy.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the alert policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isUserDefined")
    def is_user_defined(self) -> bool:
        """
        Indicates if the alert policy is user-defined (true) or pre-defined (false).
        """
        return pulumi.get(self, "is_user_defined")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Details about the current state of the alert policy.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Severity level of the alert raised by this policy.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the alert.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Creation date and time of the alert policy, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Last date and time the alert policy was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetAlertPolicyResult(GetAlertPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlertPolicyResult(
            alert_policy_id=self.alert_policy_id,
            alert_policy_rule_details=self.alert_policy_rule_details,
            alert_policy_type=self.alert_policy_type,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_user_defined=self.is_user_defined,
            lifecycle_details=self.lifecycle_details,
            severity=self.severity,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_alert_policy(alert_policy_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlertPolicyResult:
    """
    This data source provides details about a specific Alert Policy resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of alert policy by its ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alert_policy = oci.DataSafe.get_alert_policy(alert_policy_id=test_alert_policy_oci_data_safe_alert_policy["id"])
    ```


    :param str alert_policy_id: The OCID of the alert policy.
    """
    __args__ = dict()
    __args__['alertPolicyId'] = alert_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getAlertPolicy:getAlertPolicy', __args__, opts=opts, typ=GetAlertPolicyResult).value

    return AwaitableGetAlertPolicyResult(
        alert_policy_id=pulumi.get(__ret__, 'alert_policy_id'),
        alert_policy_rule_details=pulumi.get(__ret__, 'alert_policy_rule_details'),
        alert_policy_type=pulumi.get(__ret__, 'alert_policy_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_user_defined=pulumi.get(__ret__, 'is_user_defined'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        severity=pulumi.get(__ret__, 'severity'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_alert_policy)
def get_alert_policy_output(alert_policy_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAlertPolicyResult]:
    """
    This data source provides details about a specific Alert Policy resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of alert policy by its ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alert_policy = oci.DataSafe.get_alert_policy(alert_policy_id=test_alert_policy_oci_data_safe_alert_policy["id"])
    ```


    :param str alert_policy_id: The OCID of the alert policy.
    """
    ...
