# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobRunArgs', 'JobRun']

@pulumi.input_type
class JobRunArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 job_id: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 asynchronous: Optional[pulumi.Input[bool]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 job_configuration_override_details: Optional[pulumi.Input['JobRunJobConfigurationOverrideDetailsArgs']] = None,
                 job_environment_configuration_override_details: Optional[pulumi.Input['JobRunJobEnvironmentConfigurationOverrideDetailsArgs']] = None,
                 job_log_configuration_override_details: Optional[pulumi.Input['JobRunJobLogConfigurationOverrideDetailsArgs']] = None,
                 opc_parent_rpt_url: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a JobRun resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        :param pulumi.Input[str] job_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the job to create a run for.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[bool] asynchronous: If set to true, do not wait for the JobRun to reach completion prior to returning. Can be useful for JobRuns with a long duration.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input['JobRunJobConfigurationOverrideDetailsArgs'] job_configuration_override_details: The job configuration details
        :param pulumi.Input['JobRunJobEnvironmentConfigurationOverrideDetailsArgs'] job_environment_configuration_override_details: Environment configuration to capture job runtime dependencies.
        :param pulumi.Input['JobRunJobLogConfigurationOverrideDetailsArgs'] job_log_configuration_override_details: Logging configuration for resource.
        :param pulumi.Input[str] opc_parent_rpt_url: URL to fetch the Resource Principal Token from the parent resource.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "project_id", project_id)
        if asynchronous is not None:
            pulumi.set(__self__, "asynchronous", asynchronous)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if job_configuration_override_details is not None:
            pulumi.set(__self__, "job_configuration_override_details", job_configuration_override_details)
        if job_environment_configuration_override_details is not None:
            pulumi.set(__self__, "job_environment_configuration_override_details", job_environment_configuration_override_details)
        if job_log_configuration_override_details is not None:
            pulumi.set(__self__, "job_log_configuration_override_details", job_log_configuration_override_details)
        if opc_parent_rpt_url is not None:
            pulumi.set(__self__, "opc_parent_rpt_url", opc_parent_rpt_url)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the job to create a run for.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def asynchronous(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, do not wait for the JobRun to reach completion prior to returning. Can be useful for JobRuns with a long duration.
        """
        return pulumi.get(self, "asynchronous")

    @asynchronous.setter
    def asynchronous(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "asynchronous", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="jobConfigurationOverrideDetails")
    def job_configuration_override_details(self) -> Optional[pulumi.Input['JobRunJobConfigurationOverrideDetailsArgs']]:
        """
        The job configuration details
        """
        return pulumi.get(self, "job_configuration_override_details")

    @job_configuration_override_details.setter
    def job_configuration_override_details(self, value: Optional[pulumi.Input['JobRunJobConfigurationOverrideDetailsArgs']]):
        pulumi.set(self, "job_configuration_override_details", value)

    @property
    @pulumi.getter(name="jobEnvironmentConfigurationOverrideDetails")
    def job_environment_configuration_override_details(self) -> Optional[pulumi.Input['JobRunJobEnvironmentConfigurationOverrideDetailsArgs']]:
        """
        Environment configuration to capture job runtime dependencies.
        """
        return pulumi.get(self, "job_environment_configuration_override_details")

    @job_environment_configuration_override_details.setter
    def job_environment_configuration_override_details(self, value: Optional[pulumi.Input['JobRunJobEnvironmentConfigurationOverrideDetailsArgs']]):
        pulumi.set(self, "job_environment_configuration_override_details", value)

    @property
    @pulumi.getter(name="jobLogConfigurationOverrideDetails")
    def job_log_configuration_override_details(self) -> Optional[pulumi.Input['JobRunJobLogConfigurationOverrideDetailsArgs']]:
        """
        Logging configuration for resource.
        """
        return pulumi.get(self, "job_log_configuration_override_details")

    @job_log_configuration_override_details.setter
    def job_log_configuration_override_details(self, value: Optional[pulumi.Input['JobRunJobLogConfigurationOverrideDetailsArgs']]):
        pulumi.set(self, "job_log_configuration_override_details", value)

    @property
    @pulumi.getter(name="opcParentRptUrl")
    def opc_parent_rpt_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL to fetch the Resource Principal Token from the parent resource.
        """
        return pulumi.get(self, "opc_parent_rpt_url")

    @opc_parent_rpt_url.setter
    def opc_parent_rpt_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opc_parent_rpt_url", value)


@pulumi.input_type
class _JobRunState:
    def __init__(__self__, *,
                 asynchronous: Optional[pulumi.Input[bool]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 job_configuration_override_details: Optional[pulumi.Input['JobRunJobConfigurationOverrideDetailsArgs']] = None,
                 job_environment_configuration_override_details: Optional[pulumi.Input['JobRunJobEnvironmentConfigurationOverrideDetailsArgs']] = None,
                 job_id: Optional[pulumi.Input[str]] = None,
                 job_infrastructure_configuration_details: Optional[pulumi.Input[Sequence[pulumi.Input['JobRunJobInfrastructureConfigurationDetailArgs']]]] = None,
                 job_log_configuration_override_details: Optional[pulumi.Input['JobRunJobLogConfigurationOverrideDetailsArgs']] = None,
                 job_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input['JobRunJobStorageMountConfigurationDetailsListArgs']]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 log_details: Optional[pulumi.Input[Sequence[pulumi.Input['JobRunLogDetailArgs']]]] = None,
                 opc_parent_rpt_url: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_accepted: Optional[pulumi.Input[str]] = None,
                 time_finished: Optional[pulumi.Input[str]] = None,
                 time_started: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering JobRun resources.
        :param pulumi.Input[bool] asynchronous: If set to true, do not wait for the JobRun to reach completion prior to returning. Can be useful for JobRuns with a long duration.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        :param pulumi.Input[str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the job run.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input['JobRunJobConfigurationOverrideDetailsArgs'] job_configuration_override_details: The job configuration details
        :param pulumi.Input['JobRunJobEnvironmentConfigurationOverrideDetailsArgs'] job_environment_configuration_override_details: Environment configuration to capture job runtime dependencies.
        :param pulumi.Input[str] job_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the job to create a run for.
        :param pulumi.Input[Sequence[pulumi.Input['JobRunJobInfrastructureConfigurationDetailArgs']]] job_infrastructure_configuration_details: The job infrastructure configuration details (shape, block storage, etc.)
        :param pulumi.Input['JobRunJobLogConfigurationOverrideDetailsArgs'] job_log_configuration_override_details: Logging configuration for resource.
        :param pulumi.Input[Sequence[pulumi.Input['JobRunJobStorageMountConfigurationDetailsListArgs']]] job_storage_mount_configuration_details_lists: Collection of JobStorageMountConfigurationDetails.
        :param pulumi.Input[str] lifecycle_details: Details of the state of the job run.
        :param pulumi.Input[Sequence[pulumi.Input['JobRunLogDetailArgs']]] log_details: Customer logging details for job run.
        :param pulumi.Input[str] opc_parent_rpt_url: URL to fetch the Resource Principal Token from the parent resource.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The state of the job run.
        :param pulumi.Input[str] time_accepted: The date and time the job run was accepted in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_finished: The date and time the job run request was finished in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_started: The date and time the job run request was started in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        if asynchronous is not None:
            pulumi.set(__self__, "asynchronous", asynchronous)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if job_configuration_override_details is not None:
            pulumi.set(__self__, "job_configuration_override_details", job_configuration_override_details)
        if job_environment_configuration_override_details is not None:
            pulumi.set(__self__, "job_environment_configuration_override_details", job_environment_configuration_override_details)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if job_infrastructure_configuration_details is not None:
            pulumi.set(__self__, "job_infrastructure_configuration_details", job_infrastructure_configuration_details)
        if job_log_configuration_override_details is not None:
            pulumi.set(__self__, "job_log_configuration_override_details", job_log_configuration_override_details)
        if job_storage_mount_configuration_details_lists is not None:
            pulumi.set(__self__, "job_storage_mount_configuration_details_lists", job_storage_mount_configuration_details_lists)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if log_details is not None:
            pulumi.set(__self__, "log_details", log_details)
        if opc_parent_rpt_url is not None:
            pulumi.set(__self__, "opc_parent_rpt_url", opc_parent_rpt_url)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_accepted is not None:
            pulumi.set(__self__, "time_accepted", time_accepted)
        if time_finished is not None:
            pulumi.set(__self__, "time_finished", time_finished)
        if time_started is not None:
            pulumi.set(__self__, "time_started", time_started)

    @property
    @pulumi.getter
    def asynchronous(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, do not wait for the JobRun to reach completion prior to returning. Can be useful for JobRuns with a long duration.
        """
        return pulumi.get(self, "asynchronous")

    @asynchronous.setter
    def asynchronous(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "asynchronous", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the job run.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="jobConfigurationOverrideDetails")
    def job_configuration_override_details(self) -> Optional[pulumi.Input['JobRunJobConfigurationOverrideDetailsArgs']]:
        """
        The job configuration details
        """
        return pulumi.get(self, "job_configuration_override_details")

    @job_configuration_override_details.setter
    def job_configuration_override_details(self, value: Optional[pulumi.Input['JobRunJobConfigurationOverrideDetailsArgs']]):
        pulumi.set(self, "job_configuration_override_details", value)

    @property
    @pulumi.getter(name="jobEnvironmentConfigurationOverrideDetails")
    def job_environment_configuration_override_details(self) -> Optional[pulumi.Input['JobRunJobEnvironmentConfigurationOverrideDetailsArgs']]:
        """
        Environment configuration to capture job runtime dependencies.
        """
        return pulumi.get(self, "job_environment_configuration_override_details")

    @job_environment_configuration_override_details.setter
    def job_environment_configuration_override_details(self, value: Optional[pulumi.Input['JobRunJobEnvironmentConfigurationOverrideDetailsArgs']]):
        pulumi.set(self, "job_environment_configuration_override_details", value)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the job to create a run for.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter(name="jobInfrastructureConfigurationDetails")
    def job_infrastructure_configuration_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobRunJobInfrastructureConfigurationDetailArgs']]]]:
        """
        The job infrastructure configuration details (shape, block storage, etc.)
        """
        return pulumi.get(self, "job_infrastructure_configuration_details")

    @job_infrastructure_configuration_details.setter
    def job_infrastructure_configuration_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobRunJobInfrastructureConfigurationDetailArgs']]]]):
        pulumi.set(self, "job_infrastructure_configuration_details", value)

    @property
    @pulumi.getter(name="jobLogConfigurationOverrideDetails")
    def job_log_configuration_override_details(self) -> Optional[pulumi.Input['JobRunJobLogConfigurationOverrideDetailsArgs']]:
        """
        Logging configuration for resource.
        """
        return pulumi.get(self, "job_log_configuration_override_details")

    @job_log_configuration_override_details.setter
    def job_log_configuration_override_details(self, value: Optional[pulumi.Input['JobRunJobLogConfigurationOverrideDetailsArgs']]):
        pulumi.set(self, "job_log_configuration_override_details", value)

    @property
    @pulumi.getter(name="jobStorageMountConfigurationDetailsLists")
    def job_storage_mount_configuration_details_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobRunJobStorageMountConfigurationDetailsListArgs']]]]:
        """
        Collection of JobStorageMountConfigurationDetails.
        """
        return pulumi.get(self, "job_storage_mount_configuration_details_lists")

    @job_storage_mount_configuration_details_lists.setter
    def job_storage_mount_configuration_details_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobRunJobStorageMountConfigurationDetailsListArgs']]]]):
        pulumi.set(self, "job_storage_mount_configuration_details_lists", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details of the state of the job run.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="logDetails")
    def log_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobRunLogDetailArgs']]]]:
        """
        Customer logging details for job run.
        """
        return pulumi.get(self, "log_details")

    @log_details.setter
    def log_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobRunLogDetailArgs']]]]):
        pulumi.set(self, "log_details", value)

    @property
    @pulumi.getter(name="opcParentRptUrl")
    def opc_parent_rpt_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL to fetch the Resource Principal Token from the parent resource.
        """
        return pulumi.get(self, "opc_parent_rpt_url")

    @opc_parent_rpt_url.setter
    def opc_parent_rpt_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opc_parent_rpt_url", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the job run.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the job run was accepted in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_accepted")

    @time_accepted.setter
    def time_accepted(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_accepted", value)

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the job run request was finished in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_finished")

    @time_finished.setter
    def time_finished(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_finished", value)

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the job run request was started in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_started")

    @time_started.setter
    def time_started(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_started", value)


class JobRun(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 asynchronous: Optional[pulumi.Input[bool]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 job_configuration_override_details: Optional[pulumi.Input[Union['JobRunJobConfigurationOverrideDetailsArgs', 'JobRunJobConfigurationOverrideDetailsArgsDict']]] = None,
                 job_environment_configuration_override_details: Optional[pulumi.Input[Union['JobRunJobEnvironmentConfigurationOverrideDetailsArgs', 'JobRunJobEnvironmentConfigurationOverrideDetailsArgsDict']]] = None,
                 job_id: Optional[pulumi.Input[str]] = None,
                 job_log_configuration_override_details: Optional[pulumi.Input[Union['JobRunJobLogConfigurationOverrideDetailsArgs', 'JobRunJobLogConfigurationOverrideDetailsArgsDict']]] = None,
                 opc_parent_rpt_url: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Job Run resource in Oracle Cloud Infrastructure Data Science service.

        Creates a job run.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_job_run = oci.data_science.JobRun("test_job_run",
            compartment_id=compartment_id,
            job_id=test_job["id"],
            project_id=test_project["id"],
            asynchronous=asynchronous,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=job_run_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            job_configuration_override_details={
                "job_type": job_run_job_configuration_override_details_job_type,
                "command_line_arguments": job_run_job_configuration_override_details_command_line_arguments,
                "environment_variables": job_run_job_configuration_override_details_environment_variables,
                "maximum_runtime_in_minutes": job_run_job_configuration_override_details_maximum_runtime_in_minutes,
            },
            job_environment_configuration_override_details={
                "image": job_run_job_environment_configuration_override_details_image,
                "job_environment_type": job_run_job_environment_configuration_override_details_job_environment_type,
                "cmds": job_run_job_environment_configuration_override_details_cmd,
                "entrypoints": job_run_job_environment_configuration_override_details_entrypoint,
                "image_digest": job_run_job_environment_configuration_override_details_image_digest,
                "image_signature_id": test_image_signature["id"],
            },
            job_log_configuration_override_details={
                "enable_auto_log_creation": job_run_job_log_configuration_override_details_enable_auto_log_creation,
                "enable_logging": job_run_job_log_configuration_override_details_enable_logging,
                "log_group_id": test_log_group["id"],
                "log_id": test_log["id"],
            },
            opc_parent_rpt_url=job_run_opc_parent_rpt_url)
        ```

        ## Import

        JobRuns can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/jobRun:JobRun test_job_run "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] asynchronous: If set to true, do not wait for the JobRun to reach completion prior to returning. Can be useful for JobRuns with a long duration.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['JobRunJobConfigurationOverrideDetailsArgs', 'JobRunJobConfigurationOverrideDetailsArgsDict']] job_configuration_override_details: The job configuration details
        :param pulumi.Input[Union['JobRunJobEnvironmentConfigurationOverrideDetailsArgs', 'JobRunJobEnvironmentConfigurationOverrideDetailsArgsDict']] job_environment_configuration_override_details: Environment configuration to capture job runtime dependencies.
        :param pulumi.Input[str] job_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the job to create a run for.
        :param pulumi.Input[Union['JobRunJobLogConfigurationOverrideDetailsArgs', 'JobRunJobLogConfigurationOverrideDetailsArgsDict']] job_log_configuration_override_details: Logging configuration for resource.
        :param pulumi.Input[str] opc_parent_rpt_url: URL to fetch the Resource Principal Token from the parent resource.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobRunArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Job Run resource in Oracle Cloud Infrastructure Data Science service.

        Creates a job run.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_job_run = oci.data_science.JobRun("test_job_run",
            compartment_id=compartment_id,
            job_id=test_job["id"],
            project_id=test_project["id"],
            asynchronous=asynchronous,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=job_run_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            job_configuration_override_details={
                "job_type": job_run_job_configuration_override_details_job_type,
                "command_line_arguments": job_run_job_configuration_override_details_command_line_arguments,
                "environment_variables": job_run_job_configuration_override_details_environment_variables,
                "maximum_runtime_in_minutes": job_run_job_configuration_override_details_maximum_runtime_in_minutes,
            },
            job_environment_configuration_override_details={
                "image": job_run_job_environment_configuration_override_details_image,
                "job_environment_type": job_run_job_environment_configuration_override_details_job_environment_type,
                "cmds": job_run_job_environment_configuration_override_details_cmd,
                "entrypoints": job_run_job_environment_configuration_override_details_entrypoint,
                "image_digest": job_run_job_environment_configuration_override_details_image_digest,
                "image_signature_id": test_image_signature["id"],
            },
            job_log_configuration_override_details={
                "enable_auto_log_creation": job_run_job_log_configuration_override_details_enable_auto_log_creation,
                "enable_logging": job_run_job_log_configuration_override_details_enable_logging,
                "log_group_id": test_log_group["id"],
                "log_id": test_log["id"],
            },
            opc_parent_rpt_url=job_run_opc_parent_rpt_url)
        ```

        ## Import

        JobRuns can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/jobRun:JobRun test_job_run "id"
        ```

        :param str resource_name: The name of the resource.
        :param JobRunArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobRunArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 asynchronous: Optional[pulumi.Input[bool]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 job_configuration_override_details: Optional[pulumi.Input[Union['JobRunJobConfigurationOverrideDetailsArgs', 'JobRunJobConfigurationOverrideDetailsArgsDict']]] = None,
                 job_environment_configuration_override_details: Optional[pulumi.Input[Union['JobRunJobEnvironmentConfigurationOverrideDetailsArgs', 'JobRunJobEnvironmentConfigurationOverrideDetailsArgsDict']]] = None,
                 job_id: Optional[pulumi.Input[str]] = None,
                 job_log_configuration_override_details: Optional[pulumi.Input[Union['JobRunJobLogConfigurationOverrideDetailsArgs', 'JobRunJobLogConfigurationOverrideDetailsArgsDict']]] = None,
                 opc_parent_rpt_url: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobRunArgs.__new__(JobRunArgs)

            __props__.__dict__["asynchronous"] = asynchronous
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["job_configuration_override_details"] = job_configuration_override_details
            __props__.__dict__["job_environment_configuration_override_details"] = job_environment_configuration_override_details
            if job_id is None and not opts.urn:
                raise TypeError("Missing required property 'job_id'")
            __props__.__dict__["job_id"] = job_id
            __props__.__dict__["job_log_configuration_override_details"] = job_log_configuration_override_details
            __props__.__dict__["opc_parent_rpt_url"] = opc_parent_rpt_url
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["created_by"] = None
            __props__.__dict__["job_infrastructure_configuration_details"] = None
            __props__.__dict__["job_storage_mount_configuration_details_lists"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["log_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_accepted"] = None
            __props__.__dict__["time_finished"] = None
            __props__.__dict__["time_started"] = None
        super(JobRun, __self__).__init__(
            'oci:DataScience/jobRun:JobRun',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            asynchronous: Optional[pulumi.Input[bool]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            created_by: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            job_configuration_override_details: Optional[pulumi.Input[Union['JobRunJobConfigurationOverrideDetailsArgs', 'JobRunJobConfigurationOverrideDetailsArgsDict']]] = None,
            job_environment_configuration_override_details: Optional[pulumi.Input[Union['JobRunJobEnvironmentConfigurationOverrideDetailsArgs', 'JobRunJobEnvironmentConfigurationOverrideDetailsArgsDict']]] = None,
            job_id: Optional[pulumi.Input[str]] = None,
            job_infrastructure_configuration_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobRunJobInfrastructureConfigurationDetailArgs', 'JobRunJobInfrastructureConfigurationDetailArgsDict']]]]] = None,
            job_log_configuration_override_details: Optional[pulumi.Input[Union['JobRunJobLogConfigurationOverrideDetailsArgs', 'JobRunJobLogConfigurationOverrideDetailsArgsDict']]] = None,
            job_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobRunJobStorageMountConfigurationDetailsListArgs', 'JobRunJobStorageMountConfigurationDetailsListArgsDict']]]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            log_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobRunLogDetailArgs', 'JobRunLogDetailArgsDict']]]]] = None,
            opc_parent_rpt_url: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_accepted: Optional[pulumi.Input[str]] = None,
            time_finished: Optional[pulumi.Input[str]] = None,
            time_started: Optional[pulumi.Input[str]] = None) -> 'JobRun':
        """
        Get an existing JobRun resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] asynchronous: If set to true, do not wait for the JobRun to reach completion prior to returning. Can be useful for JobRuns with a long duration.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        :param pulumi.Input[str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the job run.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['JobRunJobConfigurationOverrideDetailsArgs', 'JobRunJobConfigurationOverrideDetailsArgsDict']] job_configuration_override_details: The job configuration details
        :param pulumi.Input[Union['JobRunJobEnvironmentConfigurationOverrideDetailsArgs', 'JobRunJobEnvironmentConfigurationOverrideDetailsArgsDict']] job_environment_configuration_override_details: Environment configuration to capture job runtime dependencies.
        :param pulumi.Input[str] job_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the job to create a run for.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobRunJobInfrastructureConfigurationDetailArgs', 'JobRunJobInfrastructureConfigurationDetailArgsDict']]]] job_infrastructure_configuration_details: The job infrastructure configuration details (shape, block storage, etc.)
        :param pulumi.Input[Union['JobRunJobLogConfigurationOverrideDetailsArgs', 'JobRunJobLogConfigurationOverrideDetailsArgsDict']] job_log_configuration_override_details: Logging configuration for resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobRunJobStorageMountConfigurationDetailsListArgs', 'JobRunJobStorageMountConfigurationDetailsListArgsDict']]]] job_storage_mount_configuration_details_lists: Collection of JobStorageMountConfigurationDetails.
        :param pulumi.Input[str] lifecycle_details: Details of the state of the job run.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobRunLogDetailArgs', 'JobRunLogDetailArgsDict']]]] log_details: Customer logging details for job run.
        :param pulumi.Input[str] opc_parent_rpt_url: URL to fetch the Resource Principal Token from the parent resource.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The state of the job run.
        :param pulumi.Input[str] time_accepted: The date and time the job run was accepted in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_finished: The date and time the job run request was finished in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_started: The date and time the job run request was started in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobRunState.__new__(_JobRunState)

        __props__.__dict__["asynchronous"] = asynchronous
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["job_configuration_override_details"] = job_configuration_override_details
        __props__.__dict__["job_environment_configuration_override_details"] = job_environment_configuration_override_details
        __props__.__dict__["job_id"] = job_id
        __props__.__dict__["job_infrastructure_configuration_details"] = job_infrastructure_configuration_details
        __props__.__dict__["job_log_configuration_override_details"] = job_log_configuration_override_details
        __props__.__dict__["job_storage_mount_configuration_details_lists"] = job_storage_mount_configuration_details_lists
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["log_details"] = log_details
        __props__.__dict__["opc_parent_rpt_url"] = opc_parent_rpt_url
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_accepted"] = time_accepted
        __props__.__dict__["time_finished"] = time_finished
        __props__.__dict__["time_started"] = time_started
        return JobRun(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def asynchronous(self) -> pulumi.Output[Optional[bool]]:
        """
        If set to true, do not wait for the JobRun to reach completion prior to returning. Can be useful for JobRuns with a long duration.
        """
        return pulumi.get(self, "asynchronous")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the job run.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="jobConfigurationOverrideDetails")
    def job_configuration_override_details(self) -> pulumi.Output['outputs.JobRunJobConfigurationOverrideDetails']:
        """
        The job configuration details
        """
        return pulumi.get(self, "job_configuration_override_details")

    @property
    @pulumi.getter(name="jobEnvironmentConfigurationOverrideDetails")
    def job_environment_configuration_override_details(self) -> pulumi.Output['outputs.JobRunJobEnvironmentConfigurationOverrideDetails']:
        """
        Environment configuration to capture job runtime dependencies.
        """
        return pulumi.get(self, "job_environment_configuration_override_details")

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the job to create a run for.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter(name="jobInfrastructureConfigurationDetails")
    def job_infrastructure_configuration_details(self) -> pulumi.Output[Sequence['outputs.JobRunJobInfrastructureConfigurationDetail']]:
        """
        The job infrastructure configuration details (shape, block storage, etc.)
        """
        return pulumi.get(self, "job_infrastructure_configuration_details")

    @property
    @pulumi.getter(name="jobLogConfigurationOverrideDetails")
    def job_log_configuration_override_details(self) -> pulumi.Output['outputs.JobRunJobLogConfigurationOverrideDetails']:
        """
        Logging configuration for resource.
        """
        return pulumi.get(self, "job_log_configuration_override_details")

    @property
    @pulumi.getter(name="jobStorageMountConfigurationDetailsLists")
    def job_storage_mount_configuration_details_lists(self) -> pulumi.Output[Sequence['outputs.JobRunJobStorageMountConfigurationDetailsList']]:
        """
        Collection of JobStorageMountConfigurationDetails.
        """
        return pulumi.get(self, "job_storage_mount_configuration_details_lists")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Details of the state of the job run.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="logDetails")
    def log_details(self) -> pulumi.Output[Sequence['outputs.JobRunLogDetail']]:
        """
        Customer logging details for job run.
        """
        return pulumi.get(self, "log_details")

    @property
    @pulumi.getter(name="opcParentRptUrl")
    def opc_parent_rpt_url(self) -> pulumi.Output[Optional[str]]:
        """
        URL to fetch the Resource Principal Token from the parent resource.
        """
        return pulumi.get(self, "opc_parent_rpt_url")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the job run.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> pulumi.Output[str]:
        """
        The date and time the job run was accepted in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_accepted")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> pulumi.Output[str]:
        """
        The date and time the job run request was finished in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> pulumi.Output[str]:
        """
        The date and time the job run request was started in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_started")

